/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;

public class OverlappingOutputs {
    private final String propertyName;
    private final String overlappedFilePath;

    public OverlappingOutputs(String propertyName, String overlappedFilePath) {
        this.propertyName = propertyName;
        this.overlappedFilePath = overlappedFilePath;
    }

    public static Optional<OverlappingOutputs> detect(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
        for (Map.Entry entry : current.entrySet()) {
            String propertyName = (String)entry.getKey();
            CurrentFileCollectionFingerprint beforeExecution = (CurrentFileCollectionFingerprint)entry.getValue();
            FileCollectionFingerprint afterPreviousExecution = OverlappingOutputs.getFingerprintAfterPreviousExecution(previous, propertyName);
            OverlappingOutputs overlappingOutputs = OverlappingOutputs.detect(propertyName, afterPreviousExecution, beforeExecution);
            if (overlappingOutputs == null) continue;
            return Optional.of(overlappingOutputs);
        }
        return Optional.empty();
    }

    private static FileCollectionFingerprint getFingerprintAfterPreviousExecution(@Nullable ImmutableSortedMap<String, FileCollectionFingerprint> previous, String propertyName) {
        FileCollectionFingerprint afterPreviousExecution;
        if (previous != null && (afterPreviousExecution = (FileCollectionFingerprint)previous.get((Object)propertyName)) != null) {
            return afterPreviousExecution;
        }
        return FileCollectionFingerprint.EMPTY;
    }

    @Nullable
    private static OverlappingOutputs detect(String propertyName, FileCollectionFingerprint previous, CurrentFileCollectionFingerprint before) {
        Map previousFingerprints = previous.getFingerprints();
        Map beforeFingerprints = before.getFingerprints();
        for (Map.Entry beforeEntry : beforeFingerprints.entrySet()) {
            HashCode previousContentHash;
            String path = (String)beforeEntry.getKey();
            FileSystemLocationFingerprint beforeFingerprint = (FileSystemLocationFingerprint)beforeEntry.getValue();
            HashCode contentHash = beforeFingerprint.getNormalizedContentHash();
            FileSystemLocationFingerprint previousFingerprint = (FileSystemLocationFingerprint)previousFingerprints.get(path);
            HashCode hashCode = previousContentHash = previousFingerprint == null ? null : previousFingerprint.getNormalizedContentHash();
            if (beforeFingerprint.getType() == FileType.Missing || !OverlappingOutputs.createdSincePreviousExecution(previousContentHash) && !OverlappingOutputs.changedSincePreviousExecution(contentHash, previousContentHash)) continue;
            return new OverlappingOutputs(propertyName, path);
        }
        return null;
    }

    private static boolean changedSincePreviousExecution(HashCode contentHash, HashCode previousContentHash) {
        return !contentHash.equals((Object)previousContentHash);
    }

    private static boolean createdSincePreviousExecution(@Nullable HashCode previousContentHash) {
        return previousContentHash == null;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getOverlappedFilePath() {
        return this.overlappedFilePath;
    }

    public String toString() {
        return String.format("output property '%s' with path '%s'", this.propertyName, this.overlappedFilePath);
    }
}

