/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.WrappedType;
import org.jetbrains.kotlin.util.Box;
import org.jetbrains.kotlin.util.ReenteringLazyValueComputationException;

public class DeferredType
extends WrappedType {
    private static final Function1<Boolean, KotlinType> RECURSION_PREVENTER = firstTime -> {
        if (firstTime.booleanValue()) {
            throw new ReenteringLazyValueComputationException();
        }
        return ErrorUtils.createErrorType("Recursive dependency");
    };
    private final NotNullLazyValue<KotlinType> lazyValue;

    @NotNull
    static DeferredType create(@NotNull StorageManager storageManager, @NotNull BindingTrace trace, @NotNull Function0<KotlinType> compute) {
        if (storageManager == null) {
            DeferredType.$$$reportNull$$$0(0);
        }
        if (trace == null) {
            DeferredType.$$$reportNull$$$0(1);
        }
        if (compute == null) {
            DeferredType.$$$reportNull$$$0(2);
        }
        DeferredType deferredType = new DeferredType(storageManager.createLazyValue(compute));
        trace.record(BindingContext.DEFERRED_TYPE, new Box<DeferredType>(deferredType));
        DeferredType deferredType2 = deferredType;
        if (deferredType2 == null) {
            DeferredType.$$$reportNull$$$0(3);
        }
        return deferredType2;
    }

    @NotNull
    static DeferredType createRecursionIntolerant(@NotNull StorageManager storageManager, @NotNull BindingTrace trace, @NotNull Function0<KotlinType> compute) {
        if (storageManager == null) {
            DeferredType.$$$reportNull$$$0(4);
        }
        if (trace == null) {
            DeferredType.$$$reportNull$$$0(5);
        }
        if (compute == null) {
            DeferredType.$$$reportNull$$$0(6);
        }
        DeferredType deferredType = new DeferredType(storageManager.createLazyValueWithPostCompute(compute, RECURSION_PREVENTER, t -> null));
        trace.record(BindingContext.DEFERRED_TYPE, new Box<DeferredType>(deferredType));
        DeferredType deferredType2 = deferredType;
        if (deferredType2 == null) {
            DeferredType.$$$reportNull$$$0(7);
        }
        return deferredType2;
    }

    private DeferredType(@NotNull NotNullLazyValue<KotlinType> lazyValue) {
        if (lazyValue == null) {
            DeferredType.$$$reportNull$$$0(8);
        }
        this.lazyValue = lazyValue;
    }

    public boolean isComputing() {
        return this.lazyValue.isComputing();
    }

    @Override
    public boolean isComputed() {
        return this.lazyValue.isComputed();
    }

    @Override
    @NotNull
    public KotlinType getDelegate() {
        KotlinType kotlinType2 = (KotlinType)this.lazyValue.invoke();
        if (kotlinType2 == null) {
            DeferredType.$$$reportNull$$$0(9);
        }
        return kotlinType2;
    }

    @Override
    @NotNull
    public String toString() {
        String string;
        block6: {
            block5: {
                String string2;
                try {
                    if (!this.lazyValue.isComputed()) break block5;
                    string2 = this.getDelegate().toString();
                }
                catch (ReenteringLazyValueComputationException e) {
                    if ("<Failed to compute this type>" == null) {
                        DeferredType.$$$reportNull$$$0(12);
                    }
                    return "<Failed to compute this type>";
                }
                if (string2 == null) {
                    DeferredType.$$$reportNull$$$0(10);
                }
                return string2;
            }
            string = "<Not computed yet>";
            if ("<Not computed yet>" != null) break block6;
            DeferredType.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageManager";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compute";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/DeferredType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/DeferredType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRecursionIntolerant";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRecursionIntolerant";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

