/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class ClassNameMismatch
implements ErrorRule<Void> {
    private static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.err.class.public.should.be.in.file"));

    public Set<String> getCodes() {
        return CODES;
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        FileObject file = info.getFileObject();
        if (!file.getParent().canWrite()) {
            return Collections.emptyList();
        }
        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)treePath.getLeaf().getKind())) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RenameFile(file, ((ClassTree)treePath.getLeaf()).getSimpleName().toString()));
    }

    public String getId() {
        return ClassNameMismatch.class.getName();
    }

    public String getDisplayName() {
        return Bundle.DN_ClassNameMismatch();
    }

    public void cancel() {
    }

    private static final class RenameFile
    implements Fix {
        private final FileObject toRename;
        private final String newName;

        public RenameFile(FileObject toRename, String newName) {
            this.toRename = toRename;
            this.newName = newName;
        }

        public String getText() {
            return Bundle.FIX_ChangeFileName(this.newName + "." + this.toRename.getExt());
        }

        public ChangeInfo implement() throws Exception {
            DataObject.find((FileObject)this.toRename).rename(this.newName);
            return null;
        }
    }
}

