/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.exec;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunType;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.javascript.karma.coverage.CoverageProcessor;
import org.netbeans.modules.javascript.karma.coverage.CoverageWatcher;
import org.netbeans.modules.javascript.karma.exec.Bundle;
import org.netbeans.modules.javascript.karma.exec.KarmaExecutable;
import org.netbeans.modules.javascript.karma.exec.KarmaServers;
import org.netbeans.modules.javascript.karma.preferences.KarmaPreferences;
import org.netbeans.modules.javascript.karma.run.KarmaRunInfo;
import org.netbeans.modules.javascript.karma.ui.KarmaErrorsDialog;
import org.netbeans.modules.javascript.karma.util.KarmaUtils;
import org.netbeans.modules.javascript.karma.util.StringUtils;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.clientproject.api.jstesting.Coverage;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.ChangeSupport;

public final class KarmaServer
implements PropertyChangeListener {
    static final Logger LOGGER = Logger.getLogger(KarmaServer.class.getName());
    private static final String SERVER_URL = "http://localhost:%d/";
    private final int port;
    private final Project project;
    private final Coverage coverage;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final ConfigFileChangeListener configFileChangeListener;
    volatile boolean started = false;
    volatile boolean starting = false;
    private Future<Integer> server;
    private BrowserSupport browserSupport;
    private File netBeansKarmaCoverageDir = null;
    private CoverageWatcher coverageWatcher = null;
    private volatile File netBeansKarmaReporter = null;
    private volatile File netBeansKarmaConfig = null;
    private volatile URL debugUrl = null;
    private volatile KarmaRunInfo karmaRunInfo = null;
    private String debugPageContent = null;

    KarmaServer(int port, Project project) {
        assert (project != null);
        this.port = port;
        this.project = project;
        this.coverage = Coverage.forProject((Project)project);
        this.configFileChangeListener = new ConfigFileChangeListener(project);
    }

    public synchronized boolean start() {
        assert (Thread.holdsLock(this));
        this.initCoverageWatcher();
        if (this.isStarted()) {
            return true;
        }
        this.starting = true;
        this.fireChange();
        KarmaExecutable karmaExecutable = KarmaExecutable.getDefault(this.project, true);
        if (karmaExecutable == null) {
            this.starting = false;
            this.fireChange();
            return false;
        }
        this.karmaRunInfo = this.getKarmaRunInfo();
        if (this.karmaRunInfo == null) {
            return false;
        }
        this.server = karmaExecutable.start(this.port, this.karmaRunInfo);
        this.starting = false;
        if (this.server != null) {
            this.started = true;
            this.addCoverageListener();
            this.addConfigFileListener();
        } else {
            KarmaErrorsDialog.getInstance().show(Bundle.KarmaServer_start_error());
        }
        this.fireChange();
        return this.started;
    }

    public synchronized void runTests() {
        assert (Thread.holdsLock(this));
        if (!this.isStarted()) {
            this.start();
        }
        if (this.server == null) {
            return;
        }
        KarmaExecutable karmaExecutable = KarmaExecutable.getDefault(this.project, true);
        assert (karmaExecutable != null);
        karmaExecutable.runTests(this.port);
        if (this.isDebug()) {
            this.openDebugUrl();
        }
    }

    void rerunTests() {
        this.runTests();
    }

    public synchronized void stop() {
        assert (Thread.holdsLock(this));
        this.stopCoverageWatcher();
        this.removeCoverageListener();
        this.removeConfigFileListener();
        this.karmaRunInfo = null;
        if (this.server == null) {
            return;
        }
        this.closeDebugUrl();
        if (this.server.isDone() || this.server.isCancelled()) {
            return;
        }
        this.server.cancel(true);
        this.server = null;
        this.started = false;
        this.fireChange();
    }

    public boolean isStarting() {
        return this.starting;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isRunning() {
        return this.isStarting() || this.isStarted();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public int getPort() {
        return this.port;
    }

    public Project getProject() {
        return this.project;
    }

    public String getServerUrl(@NullAllowed String path) {
        assert (path == null || !path.startsWith("/")) : path;
        String url = SERVER_URL;
        if (StringUtils.hasText(path)) {
            url = url + path;
        }
        return String.format(url, this.getPort());
    }

    public boolean servesUrl(URL url) {
        String serverUrl;
        String externalForm = url.toExternalForm();
        if (externalForm.startsWith(serverUrl = this.getServerUrl(null))) {
            externalForm = externalForm.substring(serverUrl.length() - 1);
        }
        if (this.getDebugPageContent().contains("'" + externalForm + "'")) {
            return true;
        }
        return this.getDebugPageContent().contains("\"" + externalForm + "\"");
    }

    private synchronized String getDebugPageContent() {
        if (this.debugPageContent == null) {
            this.debugPageContent = KarmaUtils.readContent(this.getDebugUrl());
            assert (this.debugPageContent != null);
        }
        return this.debugPageContent;
    }

    private synchronized void openDebugUrl() {
        assert (this.server != null) : this;
        this.initBrowserSupport();
        URL url = this.getDebugUrl();
        assert (url != null);
        if (this.browserSupport.canReload(url)) {
            this.browserSupport.reload(url);
        } else {
            this.browserSupport.load(url, this.project.getProjectDirectory());
        }
    }

    public synchronized void closeDebugUrl() {
        if (this.browserSupport != null) {
            this.browserSupport.close(true);
        }
    }

    private void initBrowserSupport() {
        assert (Thread.holdsLock(this));
        if (this.browserSupport == null) {
            String browserId = KarmaPreferences.getDebugBrowserId(this.project);
            assert (browserId != null);
            this.browserSupport = BrowserSupport.create((WebBrowser)BrowserUISupport.getBrowser((String)browserId));
        }
    }

    private void initCoverageWatcher() {
        assert (Thread.holdsLock(this));
        if (this.coverage == null) {
            return;
        }
        if (this.coverageWatcher == null) {
            this.coverageWatcher = new CoverageWatcher(this.coverage, FileUtil.toFile((FileObject)this.project.getProjectDirectory()), this.getNetBeansKarmaCoverageDir());
            this.coverageWatcher.start();
        }
    }

    private void stopCoverageWatcher() {
        assert (Thread.holdsLock(this));
        if (this.coverageWatcher != null) {
            this.coverageWatcher.stop();
            this.coverageWatcher = null;
        }
    }

    private void addCoverageListener() {
        if (this.coverage != null) {
            this.coverage.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private void removeCoverageListener() {
        if (this.coverage != null) {
            this.coverage.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private void addConfigFileListener() {
        this.configFileChangeListener.startListen(this.getProjectConfigFile());
    }

    private void removeConfigFileListener() {
        this.configFileChangeListener.stopListen();
    }

    private URL getDebugUrl() {
        if (this.debugUrl == null) {
            try {
                String url = KarmaServers.getInstance().getServerUrl(this.project, "debug.html");
                assert (url != null);
                this.debugUrl = new URL(url);
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
            assert (this.debugUrl != null);
        }
        return this.debugUrl;
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    @CheckForNull
    private KarmaRunInfo getKarmaRunInfo() {
        File projectConfig = this.getProjectConfigFile();
        return new KarmaRunInfo.Builder(this.project).setProjectConfigFile(projectConfig.getAbsolutePath()).setNbConfigFile(this.getNetBeansKarmaConfig().getAbsolutePath()).setRerunHandler(new RerunHandlerImpl(this)).setFailOnBrowserError(KarmaPreferences.isFailOnBrowserError(this.project)).addEnvVars(this.getEnvVars(projectConfig)).build();
    }

    private Map<String, String> getEnvVars(File projectConfigFile) {
        HashMap<String, String> envVars = new HashMap<String, String>();
        envVars.put("FILE_SEPARATOR", File.separator);
        envVars.put("PROJECT_CONFIG", projectConfigFile.getAbsolutePath());
        envVars.put("BASE_DIR", projectConfigFile.getParentFile().getAbsolutePath());
        envVars.put("AUTOWATCH", KarmaPreferences.isAutowatch(this.project) ? "1" : "");
        envVars.put("KARMA_NETBEANS_REPORTER", this.getNetBeansKarmaReporter().getAbsolutePath());
        envVars.put("COVERAGE", this.isCoverageEnabled() ? "1" : "");
        envVars.put("COVERAGE_DIR", this.getNetBeansKarmaCoverageDir().getAbsolutePath());
        envVars.put("DEBUG", this.isDebug() ? "1" : "");
        return envVars;
    }

    private File getProjectConfigFile() {
        String config = KarmaPreferences.getConfig(this.project);
        assert (config != null) : this.project.getProjectDirectory();
        return new File(config);
    }

    private File getNetBeansKarmaReporter() {
        if (this.netBeansKarmaReporter == null) {
            this.netBeansKarmaReporter = InstalledFileLocator.getDefault().locate("karma/karma-netbeans-reporter", "org.netbeans.modules.javascript.karma", false);
            assert (this.netBeansKarmaReporter != null);
        }
        return this.netBeansKarmaReporter;
    }

    private File getNetBeansKarmaConfig() {
        if (this.netBeansKarmaConfig == null) {
            this.netBeansKarmaConfig = InstalledFileLocator.getDefault().locate("karma/karma-netbeans.conf.js", "org.netbeans.modules.javascript.karma", false);
            assert (this.netBeansKarmaConfig != null);
        }
        return this.netBeansKarmaConfig;
    }

    private synchronized File getNetBeansKarmaCoverageDir() {
        assert (Thread.holdsLock(this));
        if (this.netBeansKarmaCoverageDir == null) {
            FileObject nbproject = this.project.getProjectDirectory().getFileObject("nbproject");
            assert (nbproject != null);
            this.netBeansKarmaCoverageDir = new File(FileUtil.toFile((FileObject)nbproject), "private" + File.separatorChar + "karma-coverage");
        }
        return this.netBeansKarmaCoverageDir;
    }

    private boolean isDebug() {
        return KarmaPreferences.isDebug(this.project);
    }

    private boolean isCoverageEnabled() {
        boolean enabled;
        boolean bl = enabled = this.coverage != null && this.coverage.isEnabled();
        if (this.isDebug()) {
            if (enabled) {
                CoverageProcessor.warnDebugCoverage();
            }
            return false;
        }
        return enabled;
    }

    public String toString() {
        return "KarmaServer{port=" + this.port + ", project=" + this.project.getProjectDirectory() + '}';
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("ENABLED".equals(evt.getPropertyName()) && this.isRunning()) {
            KarmaServers.getInstance().restartServer(this.project);
        }
    }

    private static final class ConfigFileChangeListener
    extends FileChangeAdapter {
        private final Project project;
        private File projectConfigFile = null;

        public ConfigFileChangeListener(Project project) {
            assert (project != null);
            this.project = project;
        }

        public synchronized void startListen(File projectConfigFile) {
            assert (Thread.holdsLock((Object)this));
            assert (projectConfigFile != null);
            this.stopListen();
            assert (this.projectConfigFile == null) : this.projectConfigFile;
            this.projectConfigFile = projectConfigFile;
            FileUtil.addFileChangeListener((FileChangeListener)this, (File)projectConfigFile);
        }

        public synchronized void stopListen() {
            assert (Thread.holdsLock((Object)this));
            if (this.projectConfigFile != null) {
                FileUtil.removeFileChangeListener((FileChangeListener)this, (File)this.projectConfigFile);
            }
            this.projectConfigFile = null;
        }

        public void fileChanged(FileEvent fe) {
            if (KarmaServers.getInstance().isServerRunning(this.project)) {
                KarmaServers.getInstance().restartServer(this.project);
            }
        }

        public void fileDeleted(FileEvent fe) {
            if (KarmaServers.getInstance().isServerRunning(this.project)) {
                KarmaServers.getInstance().stopServer(this.project, false);
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            if (KarmaServers.getInstance().isServerRunning(this.project)) {
                KarmaServers.getInstance().stopServer(this.project, false);
            }
        }
    }

    private static final class RerunHandlerImpl
    implements RerunHandler {
        private final KarmaServer karmaServer;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private volatile boolean enabled = true;

        public RerunHandlerImpl(KarmaServer karmaServer) {
            assert (karmaServer != null);
            this.karmaServer = karmaServer;
        }

        public void rerun() {
            this.setEnabled(false);
            this.karmaServer.rerunTests();
            this.setEnabled(true);
        }

        public void rerun(Set<Testcase> tests) {
            throw new UnsupportedOperationException("Not supported by Karma");
        }

        public boolean enabled(RerunType type) {
            switch (type) {
                case ALL: {
                    return this.enabled;
                }
                case CUSTOM: {
                    return false;
                }
            }
            assert (false) : "Unknown rerun type: " + type;
            return false;
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        private void setEnabled(boolean newEnabled) {
            if (this.enabled != newEnabled) {
                this.enabled = newEnabled;
                this.changeSupport.fireChange();
            }
        }
    }
}

