/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.mercurial;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.hudson.mercurial.Bundle;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.netbeans.modules.hudson.ui.api.HudsonSCMHelper;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

class MercurialHyperlink
implements OutputListener {
    private static final Logger LOG = Logger.getLogger(MercurialHyperlink.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(MercurialHyperlink.class);
    private final URI repo;
    private final String node;
    private final HudsonJobChangeItem.HudsonJobChangeFile file;
    private static final Map<String, String> parents = new HashMap<String, String>();
    private static final Pattern PARENT_COMMENT = Pattern.compile("# Parent +([0-9a-f]{40})");

    MercurialHyperlink(URI repo, String node, HudsonJobChangeItem.HudsonJobChangeFile file) {
        this.repo = repo;
        this.node = node;
        this.file = file;
    }

    public void outputLineAction(OutputEvent ev) {
        HudsonSCMHelper.noteWillShowDiff((String)this.file.getName());
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    StreamSource before = MercurialHyperlink.this.makeSource(false);
                    StreamSource after = MercurialHyperlink.this.makeSource(true);
                    HudsonSCMHelper.showDiff((StreamSource)before, (StreamSource)after, (String)MercurialHyperlink.this.file.getName());
                }
                catch (IOException x) {
                    LOG.log(Level.INFO, null, x);
                }
            }
        });
    }

    public void outputLineSelected(OutputEvent ev) {
    }

    public void outputLineCleared(OutputEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSource makeSource(boolean after) throws IOException {
        String rev;
        StringReader r;
        if (this.file.getEditType() == (after ? HudsonJobChangeItem.HudsonJobChangeFile.EditType.delete : HudsonJobChangeItem.HudsonJobChangeFile.EditType.add)) {
            r = new StringReader("");
            rev = null;
        } else {
            rev = after ? this.node : MercurialHyperlink.findParent(this.repo, this.node);
            try (InputStream is = this.repo.resolve("raw-file/" + rev + "/" + this.file.getName()).toURL().openStream();){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FileUtil.copy((InputStream)is, (OutputStream)baos);
                r = new StringReader(baos.toString());
            }
        }
        String mimeType = "text/plain";
        String name = this.file.getName();
        String title = Bundle.MercurialHyperlink_title(name.replaceFirst(".+/", ""), rev != null ? rev.substring(0, 12) : "null");
        return StreamSource.createSource((String)name, (String)title, (String)mimeType, (Reader)r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String findParent(URI repo, String node) throws IOException {
        String parent = parents.get(node);
        if (parent == null) {
            URL rawrev = repo.resolve("raw-rev/" + node).toURL();
            try {
                try (InputStream is = rawrev.openStream();){
                    String line;
                    BufferedReader r = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
                    while ((line = r.readLine()) != null) {
                        Matcher m = PARENT_COMMENT.matcher(line);
                        if (!m.matches()) continue;
                        parent = m.group(1);
                        break;
                    }
                }
                if (parent == null) {
                    throw new IOException("No parent rev spec found");
                }
            }
            catch (IOException x) {
                throw (IOException)new IOException("Could not parse " + rawrev + ": " + x).initCause(x);
            }
            parents.put(node, parent);
        }
        return parent;
    }
}

