/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.ohlc;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.BaseChartRenderer;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.ohlc.OhlcChart;
import org.primefaces.model.chart.OhlcChartModel;
import org.primefaces.model.chart.OhlcChartSeries;

public class OhlcChartRenderer
extends BaseChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        OhlcChart chart = (OhlcChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, UIChart uichart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        OhlcChart chart = (OhlcChart)uichart;
        String clientId = chart.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('OhlcChart','" + chart.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        this.encodeData(context, chart);
        this.encodeOptions(context, chart);
        this.encodeClientBehaviors(context, chart);
        writer.write("},'charts');});");
        this.endScript(writer);
    }

    protected void encodeData(FacesContext context, OhlcChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        OhlcChartModel model = chart.getValue();
        List<OhlcChartSeries> data = model.getData();
        writer.write(",data:[[");
        Iterator<OhlcChartSeries> it = data.iterator();
        while (it.hasNext()) {
            OhlcChartSeries s = it.next();
            writer.write("[");
            writer.write(String.valueOf(s.getValue()));
            writer.write(",");
            writer.write(String.valueOf(s.getOpen()));
            writer.write(",");
            writer.write(String.valueOf(s.getHigh()));
            writer.write(",");
            writer.write(String.valueOf(s.getLow()));
            writer.write(",");
            writer.write(String.valueOf(s.getClose()));
            writer.write("]");
            if (!it.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]]");
    }

    protected void encodeOptions(FacesContext context, OhlcChart chart) throws IOException {
        super.encodeOptions(context, chart);
        ResponseWriter writer = context.getResponseWriter();
        writer.write(",axes:{");
        this.encodeAxis(context, "xaxis", chart.getXaxisLabel(), chart.getXaxisAngle(), Double.MIN_VALUE, Double.MAX_VALUE);
        this.encodeAxis(context, ",yaxis", chart.getYaxisLabel(), chart.getYaxisAngle(), Double.MIN_VALUE, Double.MAX_VALUE);
        writer.write("}");
        if (chart.isCandleStick()) {
            writer.write(",candleStick:true");
        }
        if (chart.isZoom()) {
            writer.write(",zoom:true");
        }
        if (chart.isAnimate()) {
            writer.write(",animate:true");
        }
        if (chart.isShowDatatip()) {
            writer.write(",datatip:true");
            if (chart.getDatatipFormat() != null) {
                writer.write(",datatipFormat:'" + chart.getDatatipFormat() + "'");
            }
        }
    }
}

