/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldAddNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.JSAttributes;

public abstract class PrivateFieldAddNode
extends JavaScriptBaseNode {
    protected final JSContext context;

    public static PrivateFieldAddNode create(JSContext context) {
        return PrivateFieldAddNodeGen.create(context);
    }

    protected PrivateFieldAddNode(JSContext context) {
        this.context = context;
    }

    public abstract void execute(Object var1, Object var2, Object var3);

    @Specialization(guards={"isJSObject(target)"}, limit="3")
    void doFieldAdd(DynamicObject target, HiddenKey key, Object value, @CachedLibrary(value="target") DynamicObjectLibrary access) {
        if (!access.containsKey(target, (Object)key)) {
            access.putWithFlags(target, (Object)key, value, JSAttributes.getDefaultNotEnumerable());
        } else {
            this.duplicate(key);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private Object duplicate(HiddenKey key) {
        throw Errors.createTypeErrorCannotAddPrivateMember(key.getName(), this);
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    void doFallback(Object target, Object key, Object value) {
        throw Errors.createTypeErrorCannotSetProperty(key.toString(), target, this);
    }
}

