/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.nodes.unary.TypeOfNodeGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.Null;
import java.util.Set;

@NodeInfo(shortName="typeof")
@ImportStatic(value={JSRuntime.class})
public abstract class TypeOfNode
extends JSUnaryNode {
    protected static final int MAX_CLASSES = 3;

    protected TypeOfNode(JavaScriptNode operand) {
        super(operand);
    }

    public static TypeOfNode create(JavaScriptNode operand) {
        return TypeOfNodeGen.create(operand);
    }

    public static TypeOfNode create() {
        return TypeOfNode.create(null);
    }

    public abstract String executeString(Object var1);

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        return tag == JSTags.UnaryOperationTag.class ? true : super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("operator", ((Object)((Object)this)).getClass().getAnnotation(NodeInfo.class).shortName());
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == String.class;
    }

    @Specialization
    protected String doString(CharSequence operand) {
        return "string";
    }

    @Specialization
    protected String doInt(int operand) {
        return "number";
    }

    @Specialization
    protected String doDouble(double operand) {
        return "number";
    }

    @Specialization
    protected String doBoolean(boolean operand) {
        return "boolean";
    }

    @Specialization
    protected String doBigInt(BigInt operand) {
        return "bigint";
    }

    @Specialization(guards={"isJSNull(operand)"})
    protected String doNull(Object operand) {
        return "object";
    }

    @Specialization(guards={"isUndefined(operand)"})
    protected String doUndefined(Object operand) {
        return "undefined";
    }

    @Specialization(guards={"isJSFunction(operand)"})
    protected String doJSFunction(DynamicObject operand) {
        return "function";
    }

    @Specialization(guards={"isJSDynamicObject(operand)", "!isJSFunction(operand)", "!isUndefined(operand)", "!isJSProxy(operand)"})
    protected String doJSObjectOnly(DynamicObject operand) {
        return "object";
    }

    @Specialization(guards={"isJSProxy(operand)"})
    protected String doJSProxy(DynamicObject operand, @Cached(value="create()") TypeOfNode typeofNode, @Cached(value="create()") BranchProfile revokedProxyBranch) {
        Object target = JSProxy.getTarget(operand);
        if (target == Null.instance) {
            revokedProxyBranch.enter();
            return JSRuntime.isRevokedCallableProxy(operand) ? "function" : "object";
        }
        return typeofNode.executeString(target);
    }

    @Specialization
    protected String doSymbol(Symbol operand) {
        return "symbol";
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isForeignObject(operand)"}, limit="5")
    protected String doTruffleObject(Object operand, @CachedLibrary(value="operand") InteropLibrary interop) {
        if (interop.isBoolean(operand)) {
            return "boolean";
        }
        if (interop.isString(operand)) {
            return "string";
        }
        if (interop.isNumber(operand)) {
            return "number";
        }
        if (interop.isExecutable(operand) || interop.isInstantiable(operand)) {
            return "function";
        }
        return "object";
    }

    @Fallback
    protected String doJavaObject(Object operand) {
        assert (operand != null);
        return operand instanceof Number ? "number" : "object";
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return TypeOfNodeGen.create(TypeOfNode.cloneUninitialized(this.getOperand(), materializedTags));
    }
}

