/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querymodel;

import java.util.Collection;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnItem;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Expression;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Value;

public final class Predicate
implements Expression {
    Value _val1;
    Value _val2;
    String _op;

    public Predicate() {
    }

    public Predicate(Value val1, Value val2) {
        this(val1, val2, "=");
    }

    public Predicate(Value val1, Value val2, String op) {
        this._val1 = val1;
        this._val2 = val2;
        this._op = op;
    }

    public Predicate(String[] rel) {
        this._val1 = new ColumnNode(rel[0], rel[1]);
        this._val2 = new ColumnNode(rel[2], rel[3]);
        this._op = "=";
    }

    @Override
    public Expression findExpression(String table1, String column1, String table2, String column2) {
        if (this._val1 instanceof ColumnNode && this._val2 instanceof ColumnNode) {
            ColumnNode col1 = (ColumnNode)this._val1;
            ColumnNode col2 = (ColumnNode)this._val2;
            if (col1.matches(table1, column1) && col2.matches(table2, column2) || col2.matches(table1, column1) && col1.matches(table2, column2)) {
                return this;
            }
        }
        return null;
    }

    @Override
    public void getReferencedColumns(Collection columns) {
        if (this._val1 instanceof ColumnItem) {
            columns.add(((ColumnItem)this._val1).getReferencedColumn());
        }
        if (this._val2 instanceof ColumnItem) {
            columns.add(((ColumnItem)this._val2).getReferencedColumn());
        }
    }

    @Override
    public String genText(SQLIdentifiers.Quoter quoter) {
        return this._val1.genText(quoter) + " " + this._op + " " + this._val2.genText(quoter);
    }

    public Value getVal1() {
        return this._val1;
    }

    public void setVal1(Value val1) {
        this._val1 = val1;
    }

    public Value getVal2() {
        return this._val2;
    }

    public void setVal2(Value val2) {
        this._val2 = val2;
    }

    public String getOp() {
        return this._op;
    }

    public void setFields(String tableName1, String columnName1, String tableName2, String columnName2) {
        this._val1 = new ColumnNode(tableName1, columnName1);
        this._val2 = new ColumnNode(tableName2, columnName2);
    }

    public boolean isCriterion() {
        return !(this.getVal1() instanceof ColumnNode) || !(this.getVal2() instanceof ColumnNode);
    }

    @Override
    public void renameTableSpec(String oldTableSpec, String corrName) {
        if (this._val1 instanceof ColumnNode) {
            ((ColumnNode)this._val1).renameTableSpec(oldTableSpec, corrName);
        }
        if (this._val2 instanceof ColumnNode) {
            ((ColumnNode)this._val2).renameTableSpec(oldTableSpec, corrName);
        }
    }

    @Override
    public boolean isParameterized() {
        return this._val1.isParameterized() || this._val2.isParameterized();
    }
}

