/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.netbeans.modules.payara.tooling.PayaraStatusListener;
import org.netbeans.modules.payara.tooling.data.DataException;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.data.PayaraServerStatus;
import org.netbeans.modules.payara.tooling.logging.Logger;
import org.netbeans.modules.payara.tooling.server.state.PayaraStatusEntity;
import org.netbeans.modules.payara.tooling.server.state.StatusJob;
import org.netbeans.modules.payara.tooling.server.state.StatusScheduler;

public enum PayaraStatus {
    UNKNOWN,
    OFFLINE,
    STARTUP,
    ONLINE,
    SHUTDOWN;

    private static final Logger LOGGER;
    public static final int length;
    private static final String UNKNOWN_STR = "UNKNOWN";
    private static final String OFFLINE_STR = "OFFLINE";
    private static final String STARTUP_STR = "STARTUP";
    private static final String ONLINE_STR = "ONLINE";
    private static final String SHUTDOWN_STR = "SHUTDOWN";
    private static final Map<String, PayaraStatus> stringValuesMap;

    public static PayaraStatus toValue(String name) {
        if (name != null) {
            return stringValuesMap.get(name.toUpperCase());
        }
        return null;
    }

    public static void initScheduler(ScheduledThreadPoolExecutor executor) {
        StatusScheduler.init(executor);
    }

    public static boolean add(PayaraServer srv) {
        StatusScheduler scheduler = StatusScheduler.getInstance();
        if (!scheduler.exists(srv)) {
            PayaraStatusEntity status = new PayaraStatusEntity(srv);
            return StatusScheduler.getInstance().add(status);
        }
        return false;
    }

    public static boolean add(PayaraServer srv, PayaraStatusListener listener, boolean currentState, PayaraStatus ... newState) {
        StatusScheduler scheduler = StatusScheduler.getInstance();
        if (!scheduler.exists(srv)) {
            PayaraStatusEntity status = new PayaraStatusEntity(srv);
            return StatusScheduler.getInstance().add(status, listener, currentState, newState);
        }
        return false;
    }

    public static PayaraStatus getStatus(PayaraServer srv) {
        PayaraServerStatus status = StatusScheduler.getInstance().get(srv, null);
        return status != null ? status.getStatus() : UNKNOWN;
    }

    public static PayaraStatus getStatus(PayaraServer srv, PayaraStatusListener listener) {
        PayaraServerStatus status = StatusScheduler.getInstance().get(srv, listener);
        return status != null ? status.getStatus() : UNKNOWN;
    }

    public static PayaraServerStatus get(PayaraServer srv) {
        return StatusScheduler.getInstance().get(srv, null);
    }

    public static PayaraServerStatus get(PayaraServer srv, PayaraStatusListener listener) {
        return StatusScheduler.getInstance().get(srv, listener);
    }

    public static boolean start(PayaraServer srv, boolean force, PayaraStatusListener listener, PayaraStatus ... newState) {
        return StatusScheduler.getInstance().start(srv, force, listener, newState);
    }

    public static boolean start(PayaraServer srv) {
        return StatusScheduler.getInstance().start(srv, false, null, new PayaraStatus[0]);
    }

    public static boolean shutdown(PayaraServer srv) {
        return StatusScheduler.getInstance().shutdown(srv);
    }

    public static boolean remove(PayaraServer srv) {
        return StatusScheduler.getInstance().remove(srv);
    }

    public static boolean suspend(PayaraServer srv) {
        return StatusScheduler.getInstance().suspend(srv);
    }

    public static boolean addCheckListener(PayaraServer srv, PayaraStatusListener listener) {
        StatusJob job = StatusScheduler.getInstance().getJob(srv);
        if (job != null) {
            return job.addCurrStatusListener(listener);
        }
        return false;
    }

    public static boolean addChangeListener(PayaraServer srv, PayaraStatusListener listener, PayaraStatus ... newState) {
        StatusJob job = StatusScheduler.getInstance().getJob(srv);
        if (job != null) {
            return job.addNewStatusListener(listener, newState);
        }
        return false;
    }

    public static boolean addErrorListener(PayaraServer srv, PayaraStatusListener listener) {
        StatusJob job = StatusScheduler.getInstance().getJob(srv);
        if (job != null) {
            return job.addErrorListener(listener);
        }
        return false;
    }

    public static boolean addListener(PayaraServer srv, PayaraStatusListener listener, boolean currentState, PayaraStatus ... newState) {
        StatusJob job = StatusScheduler.getInstance().getJob(srv);
        if (job != null) {
            return job.addStatusListener(listener, currentState, newState);
        }
        return false;
    }

    public static boolean removeListener(PayaraServer srv, PayaraStatusListener listener) {
        StatusJob job = StatusScheduler.getInstance().getJob(srv);
        if (job != null) {
            return job.removeStatusListener(listener);
        }
        return false;
    }

    public String toString() {
        String METHOD = "toString";
        switch (this) {
            case UNKNOWN: {
                return UNKNOWN_STR;
            }
            case OFFLINE: {
                return OFFLINE_STR;
            }
            case STARTUP: {
                return STARTUP_STR;
            }
            case ONLINE: {
                return ONLINE_STR;
            }
            case SHUTDOWN: {
                return SHUTDOWN_STR;
            }
        }
        throw new DataException(LOGGER.excMsg("toString", "invalidState"));
    }

    static {
        LOGGER = new Logger(PayaraStatus.class);
        length = PayaraStatus.values().length;
        stringValuesMap = new HashMap<String, PayaraStatus>(PayaraStatus.values().length);
        for (PayaraStatus state : PayaraStatus.values()) {
            stringValuesMap.put(state.toString().toUpperCase(), state);
        }
    }
}

