/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDataGuardAssociationRequest
extends BmcRequest<Void> {
    private String databaseId;
    private String dataGuardAssociationId;

    @ConstructorProperties(value={"databaseId", "dataGuardAssociationId"})
    GetDataGuardAssociationRequest(String databaseId, String dataGuardAssociationId) {
        this.databaseId = databaseId;
        this.dataGuardAssociationId = dataGuardAssociationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).dataGuardAssociationId(this.dataGuardAssociationId);
    }

    public String toString() {
        return "GetDataGuardAssociationRequest(super=" + super.toString() + ", databaseId=" + this.getDatabaseId() + ", dataGuardAssociationId=" + this.getDataGuardAssociationId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetDataGuardAssociationRequest)) {
            return false;
        }
        GetDataGuardAssociationRequest other = (GetDataGuardAssociationRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$databaseId = this.getDatabaseId();
        String other$databaseId = other.getDatabaseId();
        if (this$databaseId == null ? other$databaseId != null : !this$databaseId.equals(other$databaseId)) {
            return false;
        }
        String this$dataGuardAssociationId = this.getDataGuardAssociationId();
        String other$dataGuardAssociationId = other.getDataGuardAssociationId();
        return !(this$dataGuardAssociationId == null ? other$dataGuardAssociationId != null : !this$dataGuardAssociationId.equals(other$dataGuardAssociationId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetDataGuardAssociationRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $databaseId = this.getDatabaseId();
        result = result * 59 + ($databaseId == null ? 43 : $databaseId.hashCode());
        String $dataGuardAssociationId = this.getDataGuardAssociationId();
        result = result * 59 + ($dataGuardAssociationId == null ? 43 : $dataGuardAssociationId.hashCode());
        return result;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getDataGuardAssociationId() {
        return this.dataGuardAssociationId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDataGuardAssociationRequest, Void> {
        private String databaseId;
        private String dataGuardAssociationId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDataGuardAssociationRequest o) {
            this.databaseId(o.getDatabaseId());
            this.dataGuardAssociationId(o.getDataGuardAssociationId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDataGuardAssociationRequest build() {
            GetDataGuardAssociationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder dataGuardAssociationId(String dataGuardAssociationId) {
            this.dataGuardAssociationId = dataGuardAssociationId;
            return this;
        }

        public GetDataGuardAssociationRequest buildWithoutInvocationCallback() {
            return new GetDataGuardAssociationRequest(this.databaseId, this.dataGuardAssociationId);
        }

        public String toString() {
            return "GetDataGuardAssociationRequest.Builder(databaseId=" + this.databaseId + ", dataGuardAssociationId=" + this.dataGuardAssociationId + ")";
        }
    }
}

