/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.identity.model.BulkDeleteResourcesDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class BulkDeleteResourcesRequest
extends BmcRequest<BulkDeleteResourcesDetails> {
    private String compartmentId;
    private BulkDeleteResourcesDetails bulkDeleteResourcesDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public BulkDeleteResourcesDetails getBody$() {
        return this.bulkDeleteResourcesDetails;
    }

    @ConstructorProperties(value={"compartmentId", "bulkDeleteResourcesDetails", "opcRequestId", "opcRetryToken"})
    BulkDeleteResourcesRequest(String compartmentId, BulkDeleteResourcesDetails bulkDeleteResourcesDetails, String opcRequestId, String opcRetryToken) {
        this.compartmentId = compartmentId;
        this.bulkDeleteResourcesDetails = bulkDeleteResourcesDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).bulkDeleteResourcesDetails(this.bulkDeleteResourcesDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public String toString() {
        return "BulkDeleteResourcesRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", bulkDeleteResourcesDetails=" + this.getBulkDeleteResourcesDetails() + ", opcRequestId=" + this.getOpcRequestId() + ", opcRetryToken=" + this.getOpcRetryToken() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BulkDeleteResourcesRequest)) {
            return false;
        }
        BulkDeleteResourcesRequest other = (BulkDeleteResourcesRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        BulkDeleteResourcesDetails this$bulkDeleteResourcesDetails = this.getBulkDeleteResourcesDetails();
        BulkDeleteResourcesDetails other$bulkDeleteResourcesDetails = other.getBulkDeleteResourcesDetails();
        if (this$bulkDeleteResourcesDetails == null ? other$bulkDeleteResourcesDetails != null : !((Object)this$bulkDeleteResourcesDetails).equals(other$bulkDeleteResourcesDetails)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        String this$opcRetryToken = this.getOpcRetryToken();
        String other$opcRetryToken = other.getOpcRetryToken();
        return !(this$opcRetryToken == null ? other$opcRetryToken != null : !this$opcRetryToken.equals(other$opcRetryToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BulkDeleteResourcesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        BulkDeleteResourcesDetails $bulkDeleteResourcesDetails = this.getBulkDeleteResourcesDetails();
        result = result * 59 + ($bulkDeleteResourcesDetails == null ? 43 : ((Object)$bulkDeleteResourcesDetails).hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        String $opcRetryToken = this.getOpcRetryToken();
        result = result * 59 + ($opcRetryToken == null ? 43 : $opcRetryToken.hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public BulkDeleteResourcesDetails getBulkDeleteResourcesDetails() {
        return this.bulkDeleteResourcesDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<BulkDeleteResourcesRequest, BulkDeleteResourcesDetails> {
        private String compartmentId;
        private BulkDeleteResourcesDetails bulkDeleteResourcesDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BulkDeleteResourcesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.bulkDeleteResourcesDetails(o.getBulkDeleteResourcesDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BulkDeleteResourcesRequest build() {
            BulkDeleteResourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(BulkDeleteResourcesDetails body) {
            this.bulkDeleteResourcesDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder bulkDeleteResourcesDetails(BulkDeleteResourcesDetails bulkDeleteResourcesDetails) {
            this.bulkDeleteResourcesDetails = bulkDeleteResourcesDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public BulkDeleteResourcesRequest buildWithoutInvocationCallback() {
            return new BulkDeleteResourcesRequest(this.compartmentId, this.bulkDeleteResourcesDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "BulkDeleteResourcesRequest.Builder(compartmentId=" + this.compartmentId + ", bulkDeleteResourcesDetails=" + this.bulkDeleteResourcesDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

