/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteDomainRequest
extends BmcRequest<Void> {
    private String domainId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"domainId", "ifMatch", "opcRequestId"})
    DeleteDomainRequest(String domainId, String ifMatch, String opcRequestId) {
        this.domainId = domainId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().domainId(this.domainId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "DeleteDomainRequest(super=" + super.toString() + ", domainId=" + this.getDomainId() + ", ifMatch=" + this.getIfMatch() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteDomainRequest)) {
            return false;
        }
        DeleteDomainRequest other = (DeleteDomainRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$domainId = this.getDomainId();
        String other$domainId = other.getDomainId();
        if (this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        if (this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteDomainRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $domainId = this.getDomainId();
        result = result * 59 + ($domainId == null ? 43 : $domainId.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDomainRequest, Void> {
        private String domainId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDomainRequest o) {
            this.domainId(o.getDomainId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDomainRequest build() {
            DeleteDomainRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteDomainRequest buildWithoutInvocationCallback() {
            return new DeleteDomainRequest(this.domainId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteDomainRequest.Builder(domainId=" + this.domainId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

