/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.openide.util.ChangeSupport;

public class LocalServer
implements Comparable<LocalServer> {
    public static final LocalServer PENDING_LOCAL_SERVER = new LocalServer(PhpEnvironment.PENDING_DOCUMENT_ROOT.getDocumentRoot());
    private final String virtualHost;
    private final String url;
    private final String documentRoot;
    private final boolean editable;
    private String hint = " ";
    private String srcRoot;

    public static LocalServer getEmpty() {
        return new LocalServer("", "");
    }

    public LocalServer(LocalServer localServer) {
        this(localServer.virtualHost, localServer.documentRoot, localServer.srcRoot, localServer.editable);
    }

    public LocalServer(String srcRoot) {
        this(null, null, srcRoot);
    }

    public LocalServer(String documentRoot, String srcRoot) {
        this(null, documentRoot, srcRoot);
    }

    public LocalServer(String virtualHost, String documentRoot, String srcRoot) {
        this(virtualHost, documentRoot, srcRoot, true);
    }

    public LocalServer(String virtualHost, String documentRoot, String srcRoot, boolean editable) {
        this(virtualHost, null, documentRoot, srcRoot, editable);
    }

    public LocalServer(String virtualHost, String url, String documentRoot, String srcRoot, boolean editable) {
        this.virtualHost = virtualHost;
        this.url = url;
        this.documentRoot = documentRoot;
        this.srcRoot = srcRoot;
        this.editable = editable;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDocumentRoot() {
        return this.documentRoot;
    }

    public String getSrcRoot() {
        return this.srcRoot;
    }

    public void setSrcRoot(String srcRoot) {
        if (!this.editable) {
            throw new IllegalStateException("srcRoot cannot be changed because instance is not editable");
        }
        this.srcRoot = srcRoot;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isPending() {
        return this == PENDING_LOCAL_SERVER;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(150);
        sb.append(this.getClass().getName());
        sb.append("[virtualHost: ");
        sb.append(this.virtualHost);
        sb.append(", url: ");
        sb.append(this.url);
        sb.append(", documentRoot: ");
        sb.append(this.documentRoot);
        sb.append(", srcRoot: ");
        sb.append(this.srcRoot);
        sb.append(", hint: ");
        sb.append(this.hint);
        sb.append(", editable: ");
        sb.append(this.editable);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int compareTo(LocalServer ls) {
        if (!this.editable) {
            return -1;
        }
        return this.srcRoot.compareTo(ls.getSrcRoot());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalServer other = (LocalServer)obj;
        if (this.virtualHost == null ? other.virtualHost != null : !this.virtualHost.equals(other.virtualHost)) {
            return false;
        }
        if (this.documentRoot == null ? other.documentRoot != null : !this.documentRoot.equals(other.documentRoot)) {
            return false;
        }
        if (this.editable != other.editable) {
            return false;
        }
        return !(this.srcRoot == null ? other.srcRoot != null : !this.srcRoot.equals(other.srcRoot));
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.virtualHost != null ? this.virtualHost.hashCode() : 0);
        hash = 97 * hash + (this.documentRoot != null ? this.documentRoot.hashCode() : 0);
        hash = 97 * hash + (this.editable ? 1 : 0);
        hash = 97 * hash + (this.srcRoot != null ? this.srcRoot.hashCode() : 0);
        return hash;
    }

    public static class ComboBoxModel
    extends AbstractListModel<LocalServer>
    implements MutableComboBoxModel<LocalServer> {
        private static final long serialVersionUID = 4857683465761112L;
        private final List<LocalServer> data;
        private LocalServer selected = null;

        public ComboBoxModel(LocalServer ... defaultLocalServers) {
            if (defaultLocalServers == null || defaultLocalServers.length == 0) {
                defaultLocalServers = new LocalServer[]{LocalServer.getEmpty()};
            }
            this.data = new ArrayList<LocalServer>(2 * defaultLocalServers.length);
            this.data.addAll(Arrays.asList(defaultLocalServers));
            this.selected = this.data.get(0);
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public LocalServer getElementAt(int index) {
            return this.data.get(index);
        }

        @Override
        public void addElement(LocalServer localServer) {
            if (!this.data.add(localServer)) {
                return;
            }
            Collections.sort(this.data);
            int idx = this.indexOf(localServer);
            this.fireIntervalAdded(this, idx, idx);
        }

        @Override
        public void insertElementAt(LocalServer localServer, int index) {
            this.data.add(index, localServer);
            this.fireIntervalAdded(this, index, index);
        }

        public int indexOf(LocalServer configuration) {
            return this.data.indexOf(configuration);
        }

        @Override
        public void removeElement(Object object) {
            assert (object instanceof LocalServer);
            LocalServer localServer = (LocalServer)object;
            int idx = this.indexOf(localServer);
            if (idx == -1) {
                return;
            }
            boolean result = this.data.remove(localServer);
            assert (result);
            this.fireIntervalRemoved(this, idx, idx);
        }

        @Override
        public void removeElementAt(int index) {
            if (this.getElementAt(index) == this.selected) {
                if (index == 0) {
                    this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
                } else {
                    this.setSelectedItem(this.getElementAt(index - 1));
                }
            }
            this.data.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }

        @Override
        public void setSelectedItem(Object object) {
            if (this.selected != null && !this.selected.equals(object) || this.selected == null && object != null) {
                assert (object == null || object instanceof LocalServer) : "Trying to set object of type: " + object.getClass().getName();
                this.selected = (LocalServer)object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        public List<LocalServer> getElements() {
            return Collections.unmodifiableList(this.data);
        }

        public void setElements(List<LocalServer> localServers) {
            int size = this.data.size();
            this.data.clear();
            if (size > 0) {
                this.fireIntervalRemoved(this, 0, size - 1);
            }
            if (localServers.size() > 0) {
                this.data.addAll(localServers);
                Collections.sort(this.data);
                this.fireIntervalAdded(this, 0, this.data.size() - 1);
            }
        }
    }

    public static class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<LocalServer>,
    UIResource {
        private static final long serialVersionUID = 146876454678878410L;

        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends LocalServer> list, LocalServer value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null) {
                String srcRoot = value.getSrcRoot();
                this.setText(srcRoot.length() == 0 ? " " : srcRoot);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    public static class ComboBoxEditor
    implements javax.swing.ComboBoxEditor,
    UIResource,
    DocumentListener {
        private static final long serialVersionUID = -4527321803090719483L;
        private final JTextField component;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private LocalServer activeItem = null;

        public ComboBoxEditor(JTextField editor) {
            this.component = editor;
            this.component.getDocument().addDocumentListener(this);
        }

        @Override
        public Component getEditorComponent() {
            return this.component;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject == null) {
                return;
            }
            assert (anObject instanceof LocalServer);
            this.activeItem = (LocalServer)anObject;
            this.component.setText(this.activeItem.getSrcRoot());
        }

        @Override
        public Object getItem() {
            return new LocalServer(this.activeItem);
        }

        @Override
        public void selectAll() {
            this.component.selectAll();
            this.component.requestFocus();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.component.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.component.removeActionListener(l);
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            if (this.activeItem == null) {
                return;
            }
            boolean enabled = false;
            if (this.activeItem.isEditable()) {
                enabled = true;
                this.activeItem.setSrcRoot(this.component.getText().trim());
            }
            this.component.setEnabled(enabled);
            this.changeSupport.fireChange();
        }
    }
}

