/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.action;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.visual.widget.Widget;

public interface WidgetAction {
    public State mouseClicked(Widget var1, WidgetMouseEvent var2);

    public State mousePressed(Widget var1, WidgetMouseEvent var2);

    public State mouseReleased(Widget var1, WidgetMouseEvent var2);

    public State mouseEntered(Widget var1, WidgetMouseEvent var2);

    public State mouseExited(Widget var1, WidgetMouseEvent var2);

    public State mouseDragged(Widget var1, WidgetMouseEvent var2);

    public State mouseMoved(Widget var1, WidgetMouseEvent var2);

    public State mouseWheelMoved(Widget var1, WidgetMouseWheelEvent var2);

    public State keyTyped(Widget var1, WidgetKeyEvent var2);

    public State keyPressed(Widget var1, WidgetKeyEvent var2);

    public State keyReleased(Widget var1, WidgetKeyEvent var2);

    public State focusGained(Widget var1, WidgetFocusEvent var2);

    public State focusLost(Widget var1, WidgetFocusEvent var2);

    public State dragEnter(Widget var1, WidgetDropTargetDragEvent var2);

    public State dragOver(Widget var1, WidgetDropTargetDragEvent var2);

    public State dropActionChanged(Widget var1, WidgetDropTargetDragEvent var2);

    public State dragExit(Widget var1, WidgetDropTargetEvent var2);

    public State drop(Widget var1, WidgetDropTargetDropEvent var2);

    public static final class WidgetDropTargetEvent
    implements WidgetEvent {
        private long id;
        private DropTargetEvent event;

        public WidgetDropTargetEvent(long id, DropTargetEvent event) {
            this.id = id;
            this.event = event;
        }

        @Override
        public long getEventID() {
            return this.id;
        }

        public DropTargetContext getDropTargetContext() {
            return this.event.getDropTargetContext();
        }
    }

    public static final class WidgetDropTargetDropEvent
    implements WidgetLocationEvent {
        private long id;
        private DropTargetDropEvent event;
        private int x;
        private int y;

        public WidgetDropTargetDropEvent(long id, DropTargetDropEvent event) {
            this.id = id;
            this.event = event;
            Point location = event.getLocation();
            this.x = location.x;
            this.y = location.y;
        }

        @Override
        public long getEventID() {
            return this.id;
        }

        @Override
        public Point getPoint() {
            return new Point(this.x, this.y);
        }

        @Override
        public void setPoint(Point point) {
            this.x = point.x;
            this.y = point.y;
        }

        @Override
        public void translatePoint(int x, int y) {
            this.x += x;
            this.y += y;
        }

        public DataFlavor[] getCurrentDataFlavors() {
            return this.event.getCurrentDataFlavors();
        }

        public List<DataFlavor> getCurrentDataFlavorsAsList() {
            return this.event.getCurrentDataFlavorsAsList();
        }

        public boolean isDataFlavorSupported(DataFlavor df) {
            return this.event.isDataFlavorSupported(df);
        }

        public int getSourceActions() {
            return this.event.getSourceActions();
        }

        public int getDropAction() {
            return this.event.getDropAction();
        }

        public Transferable getTransferable() {
            return this.event.getTransferable();
        }

        public boolean isLocalTransfer() {
            return this.event.isLocalTransfer();
        }

        public DropTargetContext getDropTargetContext() {
            return this.event.getDropTargetContext();
        }

        public void acceptDrop(int dragOperation) {
            this.event.acceptDrop(dragOperation);
        }

        public void rejectDrop() {
            this.event.rejectDrop();
        }
    }

    public static final class WidgetDropTargetDragEvent
    implements WidgetLocationEvent {
        private long id;
        private DropTargetDragEvent event;
        private int x;
        private int y;

        public WidgetDropTargetDragEvent(long id, DropTargetDragEvent event) {
            this.id = id;
            this.event = event;
            Point location = event.getLocation();
            this.x = location.x;
            this.y = location.y;
        }

        @Override
        public long getEventID() {
            return this.id;
        }

        @Override
        public Point getPoint() {
            return new Point(this.x, this.y);
        }

        @Override
        public void setPoint(Point point) {
            this.x = point.x;
            this.y = point.y;
        }

        @Override
        public void translatePoint(int x, int y) {
            this.x += x;
            this.y += y;
        }

        public DataFlavor[] getCurrentDataFlavors() {
            return this.event.getCurrentDataFlavors();
        }

        public List<DataFlavor> getCurrentDataFlavorsAsList() {
            return this.event.getCurrentDataFlavorsAsList();
        }

        public boolean isDataFlavorSupported(DataFlavor df) {
            return this.event.isDataFlavorSupported(df);
        }

        public int getSourceActions() {
            return this.event.getSourceActions();
        }

        public int getDropAction() {
            return this.event.getDropAction();
        }

        public Transferable getTransferable() {
            return this.event.getTransferable();
        }

        public DropTargetContext getDropTargetContext() {
            return this.event.getDropTargetContext();
        }

        public void acceptDrag(int dragOperation) {
            this.event.acceptDrag(dragOperation);
        }

        public void rejectDrag() {
            this.event.rejectDrag();
        }
    }

    public static final class WidgetFocusEvent
    implements WidgetEvent {
        private long id;
        private FocusEvent event;

        public WidgetFocusEvent(long id, FocusEvent event) {
            this.id = id;
            this.event = event;
        }

        @Override
        public long getEventID() {
            return this.id;
        }

        public Object getOppositeComponent() {
            return this.event.getOppositeComponent();
        }

        public String paramString() {
            return this.event.paramString();
        }

        public boolean isTemporary() {
            return this.event.isTemporary();
        }
    }

    public static final class WidgetKeyEvent
    implements WidgetEvent {
        private long id;
        private KeyEvent event;

        public WidgetKeyEvent(long id, KeyEvent event) {
            this.id = id;
            this.event = event;
        }

        @Override
        public long getEventID() {
            return this.id;
        }

        public int getKeyCode() {
            return this.event.getKeyCode();
        }

        public char getKeyChar() {
            return this.event.getKeyChar();
        }

        public int getKeyLocation() {
            return this.event.getKeyLocation();
        }

        public boolean isActionKey() {
            return this.event.isActionKey();
        }

        public boolean isShiftDown() {
            return this.event.isShiftDown();
        }

        public boolean isControlDown() {
            return this.event.isControlDown();
        }

        public boolean isMetaDown() {
            return this.event.isMetaDown();
        }

        public boolean isAltDown() {
            return this.event.isAltDown();
        }

        public boolean isAltGraphDown() {
            return this.event.isAltGraphDown();
        }

        public long getWhen() {
            return this.event.getWhen();
        }

        public int getModifiers() {
            return this.event.getModifiers();
        }

        public int getModifiersEx() {
            return this.event.getModifiersEx();
        }
    }

    public static final class WidgetMouseWheelEvent
    implements WidgetLocationEvent {
        private long id;
        private MouseWheelEvent event;
        private int x;
        private int y;

        public WidgetMouseWheelEvent(long id, MouseWheelEvent event) {
            this.id = id;
            this.event = event;
            this.x = event.getX();
            this.y = event.getY();
        }

        @Override
        public long getEventID() {
            return this.id;
        }

        @Override
        public Point getPoint() {
            return new Point(this.x, this.y);
        }

        @Override
        public void setPoint(Point point) {
            this.x = point.x;
            this.y = point.y;
        }

        @Override
        public void translatePoint(int x, int y) {
            this.x += x;
            this.y += y;
        }

        public int getClickCount() {
            return this.event.getClickCount();
        }

        public int getButton() {
            return this.event.getButton();
        }

        public boolean isPopupTrigger() {
            return this.event.isPopupTrigger();
        }

        public boolean isShiftDown() {
            return this.event.isShiftDown();
        }

        public boolean isControlDown() {
            return this.event.isControlDown();
        }

        public boolean isMetaDown() {
            return this.event.isMetaDown();
        }

        public boolean isAltDown() {
            return this.event.isAltDown();
        }

        public boolean isAltGraphDown() {
            return this.event.isAltGraphDown();
        }

        public long getWhen() {
            return this.event.getWhen();
        }

        public int getModifiers() {
            return this.event.getModifiers();
        }

        public int getModifiersEx() {
            return this.event.getModifiersEx();
        }

        public int getScrollType() {
            return this.event.getScrollType();
        }

        public int getScrollAmount() {
            return this.event.getScrollAmount();
        }

        public int getWheelRotation() {
            return this.event.getWheelRotation();
        }

        public int getUnitsToScroll() {
            return this.event.getUnitsToScroll();
        }
    }

    public static final class WidgetMouseEvent
    implements WidgetLocationEvent {
        private long id;
        private MouseEvent event;
        private int x;
        private int y;

        public WidgetMouseEvent(long id, MouseEvent event) {
            this.id = id;
            this.event = event;
            this.x = event.getX();
            this.y = event.getY();
        }

        @Override
        public long getEventID() {
            return this.id;
        }

        @Override
        public Point getPoint() {
            return new Point(this.x, this.y);
        }

        @Override
        public void setPoint(Point point) {
            this.x = point.x;
            this.y = point.y;
        }

        @Override
        public void translatePoint(int x, int y) {
            this.x += x;
            this.y += y;
        }

        public int getClickCount() {
            return this.event.getClickCount();
        }

        public int getButton() {
            return this.event.getButton();
        }

        public boolean isPopupTrigger() {
            return this.event.isPopupTrigger();
        }

        public boolean isShiftDown() {
            return this.event.isShiftDown();
        }

        public boolean isControlDown() {
            return this.event.isControlDown();
        }

        public boolean isMetaDown() {
            return this.event.isMetaDown();
        }

        public boolean isAltDown() {
            return this.event.isAltDown();
        }

        public boolean isAltGraphDown() {
            return this.event.isAltGraphDown();
        }

        public long getWhen() {
            return this.event.getWhen();
        }

        public int getModifiers() {
            return this.event.getModifiers();
        }

        public int getModifiersEx() {
            return this.event.getModifiersEx();
        }
    }

    public static interface WidgetLocationEvent
    extends WidgetEvent {
        public Point getPoint();

        public void setPoint(Point var1);

        public void translatePoint(int var1, int var2);
    }

    public static interface WidgetEvent {
        public long getEventID();
    }

    public static final class Chain
    implements WidgetAction {
        private List<WidgetAction> actions = new ArrayList<WidgetAction>();
        private List<WidgetAction> actionsUm = Collections.unmodifiableList(this.actions);

        public List<WidgetAction> getActions() {
            return this.actionsUm;
        }

        public void addAction(WidgetAction action) {
            assert (action != null);
            this.actions.add(action);
        }

        public void addAction(int index, WidgetAction action) {
            assert (action != null);
            this.actions.add(index, action);
        }

        public void removeAction(WidgetAction action) {
            this.actions.remove(action);
        }

        public void removeAction(int index) {
            this.actions.remove(index);
        }

        @Override
        public State mouseClicked(Widget widget, WidgetMouseEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.mouseClicked(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State mousePressed(Widget widget, WidgetMouseEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.mousePressed(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State mouseReleased(Widget widget, WidgetMouseEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.mouseReleased(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State mouseEntered(Widget widget, WidgetMouseEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.mouseEntered(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State mouseExited(Widget widget, WidgetMouseEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.mouseExited(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State mouseDragged(Widget widget, WidgetMouseEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.mouseDragged(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State mouseMoved(Widget widget, WidgetMouseEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.mouseMoved(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State mouseWheelMoved(Widget widget, WidgetMouseWheelEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.mouseWheelMoved(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State keyTyped(Widget widget, WidgetKeyEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.keyTyped(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State keyPressed(Widget widget, WidgetKeyEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.keyPressed(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State keyReleased(Widget widget, WidgetKeyEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.keyReleased(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State focusGained(Widget widget, WidgetFocusEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.focusGained(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State focusLost(Widget widget, WidgetFocusEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.focusLost(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State dragEnter(Widget widget, WidgetDropTargetDragEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.dragEnter(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State dragOver(Widget widget, WidgetDropTargetDragEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.dragOver(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State dropActionChanged(Widget widget, WidgetDropTargetDragEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.dropActionChanged(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State dragExit(Widget widget, WidgetDropTargetEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.dragExit(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }

        @Override
        public State drop(Widget widget, WidgetDropTargetDropEvent event) {
            WidgetAction[] actionsArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State chainState = State.REJECTED;
            for (WidgetAction action : actionsArray) {
                State state = action.drop(widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                if (!state.isLockedInChain()) continue;
                chainState = State.CONSUMED;
            }
            return chainState;
        }
    }

    public static abstract class LockedAdapter
    implements WidgetAction {
        protected abstract boolean isLocked();

        @Override
        public State mouseClicked(Widget widget, WidgetMouseEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State mousePressed(Widget widget, WidgetMouseEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State mouseReleased(Widget widget, WidgetMouseEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State mouseEntered(Widget widget, WidgetMouseEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State mouseExited(Widget widget, WidgetMouseEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State mouseDragged(Widget widget, WidgetMouseEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State mouseMoved(Widget widget, WidgetMouseEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State mouseWheelMoved(Widget widget, WidgetMouseWheelEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State keyTyped(Widget widget, WidgetKeyEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State keyPressed(Widget widget, WidgetKeyEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State keyReleased(Widget widget, WidgetKeyEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State focusGained(Widget widget, WidgetFocusEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State focusLost(Widget widget, WidgetFocusEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State dragEnter(Widget widget, WidgetDropTargetDragEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State dragOver(Widget widget, WidgetDropTargetDragEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State dropActionChanged(Widget widget, WidgetDropTargetDragEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State dragExit(Widget widget, WidgetDropTargetEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        @Override
        public State drop(Widget widget, WidgetDropTargetDropEvent event) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }
    }

    public static class Adapter
    implements WidgetAction {
        @Override
        public State mouseClicked(Widget widget, WidgetMouseEvent event) {
            return State.REJECTED;
        }

        @Override
        public State mousePressed(Widget widget, WidgetMouseEvent event) {
            return State.REJECTED;
        }

        @Override
        public State mouseReleased(Widget widget, WidgetMouseEvent event) {
            return State.REJECTED;
        }

        @Override
        public State mouseEntered(Widget widget, WidgetMouseEvent event) {
            return State.REJECTED;
        }

        @Override
        public State mouseExited(Widget widget, WidgetMouseEvent event) {
            return State.REJECTED;
        }

        @Override
        public State mouseDragged(Widget widget, WidgetMouseEvent event) {
            return State.REJECTED;
        }

        @Override
        public State mouseMoved(Widget widget, WidgetMouseEvent event) {
            return State.REJECTED;
        }

        @Override
        public State mouseWheelMoved(Widget widget, WidgetMouseWheelEvent event) {
            return State.REJECTED;
        }

        @Override
        public State keyTyped(Widget widget, WidgetKeyEvent event) {
            return State.REJECTED;
        }

        @Override
        public State keyPressed(Widget widget, WidgetKeyEvent event) {
            return State.REJECTED;
        }

        @Override
        public State keyReleased(Widget widget, WidgetKeyEvent event) {
            return State.REJECTED;
        }

        @Override
        public State focusGained(Widget widget, WidgetFocusEvent event) {
            return State.REJECTED;
        }

        @Override
        public State focusLost(Widget widget, WidgetFocusEvent event) {
            return State.REJECTED;
        }

        @Override
        public State dragEnter(Widget widget, WidgetDropTargetDragEvent event) {
            return State.REJECTED;
        }

        @Override
        public State dragOver(Widget widget, WidgetDropTargetDragEvent event) {
            return State.REJECTED;
        }

        @Override
        public State dropActionChanged(Widget widget, WidgetDropTargetDragEvent event) {
            return State.REJECTED;
        }

        @Override
        public State dragExit(Widget widget, WidgetDropTargetEvent event) {
            return State.REJECTED;
        }

        @Override
        public State drop(Widget widget, WidgetDropTargetDropEvent event) {
            return State.REJECTED;
        }
    }

    public static abstract class State {
        public static final State REJECTED = new State(){

            @Override
            public boolean isLockedInChain() {
                return false;
            }

            @Override
            public boolean isConsumed() {
                return false;
            }

            @Override
            public Widget getLockedWidget() {
                return null;
            }

            @Override
            public WidgetAction getLockedAction() {
                return null;
            }
        };
        public static final State CONSUMED = new State(){

            @Override
            public boolean isLockedInChain() {
                return false;
            }

            @Override
            public boolean isConsumed() {
                return true;
            }

            @Override
            public Widget getLockedWidget() {
                return null;
            }

            @Override
            public WidgetAction getLockedAction() {
                return null;
            }
        };
        public static final State CHAIN_ONLY = new State(){

            @Override
            public boolean isLockedInChain() {
                return true;
            }

            @Override
            public boolean isConsumed() {
                return false;
            }

            @Override
            public Widget getLockedWidget() {
                return null;
            }

            @Override
            public WidgetAction getLockedAction() {
                return null;
            }
        };

        public static State createLocked(final Widget lockedWidget, final WidgetAction lockedAction) {
            assert (lockedWidget != null);
            assert (lockedAction != null);
            return new State(){

                @Override
                public boolean isLockedInChain() {
                    return false;
                }

                @Override
                public boolean isConsumed() {
                    return true;
                }

                @Override
                public Widget getLockedWidget() {
                    return lockedWidget;
                }

                @Override
                public WidgetAction getLockedAction() {
                    return lockedAction;
                }
            };
        }

        private State() {
        }

        public abstract boolean isLockedInChain();

        public abstract boolean isConsumed();

        public abstract Widget getLockedWidget();

        public abstract WidgetAction getLockedAction();
    }
}

