/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.spi;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.modules.projectimport.eclipse.core.ClassPathContainerResolver;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.spi.DotClassPathEntry;
import org.netbeans.modules.projectimport.eclipse.core.spi.Facets;
import org.netbeans.modules.projectimport.eclipse.core.spi.LaunchConfiguration;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public final class ProjectImportModel {
    private static final Logger LOG = Logger.getLogger(ProjectImportModel.class.getName());
    private EclipseProject project;
    private File projectLocation;
    private JavaPlatform platform;
    private List<Project> alreadyImportedProjects;
    private List<WizardDescriptor.Panel<WizardDescriptor>> extraWizardPanels;
    private final Map<File, Boolean> looksLikeTests = new HashMap<File, Boolean>();

    public ProjectImportModel(EclipseProject project, File projectLocation, JavaPlatform platform, List<Project> alreadyImportedProjects) {
        this(project, projectLocation, platform, alreadyImportedProjects, null);
    }

    public ProjectImportModel(EclipseProject project, File projectLocation, JavaPlatform platform, List<Project> alreadyImportedProjects, List<WizardDescriptor.Panel<WizardDescriptor>> extraWizardPanels) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.project = project;
        assert (projectLocation == null || projectLocation.equals(FileUtil.normalizeFile((File)projectLocation)));
        this.projectLocation = projectLocation;
        this.platform = platform;
        this.alreadyImportedProjects = alreadyImportedProjects;
        this.extraWizardPanels = extraWizardPanels;
    }

    public Facets getFacets() {
        return this.project.getFacets();
    }

    public String getProjectName() {
        return this.project.getName();
    }

    public File getEclipseProjectFolder() {
        return this.project.getDirectory();
    }

    public File getEclipseWorkspaceFolder() {
        Workspace workspace = this.project.getWorkspace();
        return workspace != null ? workspace.getDirectory() : null;
    }

    public File getNetBeansProjectLocation() {
        return this.projectLocation;
    }

    public Set<String> getEclipseNatures() {
        return this.project.getNatures();
    }

    public List<DotClassPathEntry> getEclipseClassPathEntries() {
        return this.project.getClassPathEntries();
    }

    public List<DotClassPathEntry> getEclipseSourceRoots() {
        return this.filterSourceRootsForTests(false);
    }

    public File[] getEclipseSourceRootsAsFileArray() {
        return ProjectImportModel.convertToFileArray(this.getEclipseSourceRoots());
    }

    public List<DotClassPathEntry> getEclipseTestSourceRoots() {
        return this.filterSourceRootsForTests(true);
    }

    public File[] getEclipseTestSourceRootsAsFileArray() {
        return ProjectImportModel.convertToFileArray(this.getEclipseTestSourceRoots());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DotClassPathEntry> filterSourceRootsForTests(boolean test) {
        List<DotClassPathEntry> all = this.project.getSourceRoots();
        if (!this.hasJUnitOnClassPath() || all.size() <= 1) {
            if (test) {
                return Collections.emptyList();
            }
            return all;
        }
        ArrayList<DotClassPathEntry> result = new ArrayList<DotClassPathEntry>(all.size());
        for (DotClassPathEntry entry : all) {
            Boolean isTest;
            File r = new File(entry.getAbsolutePath());
            Map<File, Boolean> map = this.looksLikeTests;
            synchronized (map) {
                isTest = this.looksLikeTests.get(r);
                if (isTest == null) {
                    isTest = this.hasTests(r);
                    this.looksLikeTests.put(r, isTest);
                }
            }
            if (!(!test ^ isTest)) continue;
            result.add(entry);
        }
        return result;
    }

    private boolean hasJUnitOnClassPath() {
        for (DotClassPathEntry entry : this.getEclipseClassPathEntries()) {
            if (!ClassPathContainerResolver.isJUnit(entry)) continue;
            return true;
        }
        return false;
    }

    private boolean hasTests(File fileOrDir) {
        if (fileOrDir.isDirectory()) {
            File[] kids = fileOrDir.listFiles();
            if (kids != null) {
                for (File kid : kids) {
                    if (!this.hasTests(kid)) continue;
                    return true;
                }
            }
            return false;
        }
        return this.isJUnitFile(fileOrDir);
    }

    private boolean isJUnitFile(File f) {
        if (!(f.getName().endsWith("Test.java") || f.getName().endsWith("Case.java") || f.getName().endsWith("Suite.java"))) {
            return false;
        }
        FileObject fo = FileUtil.toFileObject((File)f);
        try {
            return this.readJUnitFileHeader(fo);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readJUnitFileHeader(FileObject fo) throws IOException {
        try (InputStream is = fo.getInputStream();){
            String line;
            BufferedReader input = new BufferedReader(new InputStreamReader(is, this.getEncoding()));
            for (int maxLines = 100; null != (line = input.readLine()) && maxLines > 0; --maxLines) {
                if (!line.contains("junit.framework.Test") && !line.contains("org.junit.Test") && !line.contains("junit.framework.*") && !line.contains("org.junit.*")) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public JavaPlatform getJavaPlatform() {
        return this.platform;
    }

    String getEclipseVersion() {
        return null;
    }

    public DotClassPathEntry getOutput() {
        return this.project.getOutput();
    }

    public List<Project> getAlreadyImportedProjects() {
        return Collections.unmodifiableList(this.alreadyImportedProjects);
    }

    private static File[] convertToFileArray(List<DotClassPathEntry> entries) {
        ArrayList<File> res = new ArrayList<File>();
        for (DotClassPathEntry entry : entries) {
            res.add(new File(entry.getAbsolutePath()));
        }
        return res.toArray(new File[res.size()]);
    }

    public String getSourceLevel() {
        Properties p = this.getPreferences("org.eclipse.jdt.core");
        String compliance = p.getProperty("org.eclipse.jdt.core.compiler.compliance", "1.5");
        return p.getProperty("org.eclipse.jdt.core.compiler.source", compliance);
    }

    public String getTargetLevel() {
        Properties p = this.getPreferences("org.eclipse.jdt.core");
        String compliance = p.getProperty("org.eclipse.jdt.core.compiler.compliance", "1.5");
        return p.getProperty("org.eclipse.jdt.core.compiler.codegen.targetPlatform", compliance);
    }

    public boolean isDebug() {
        Properties p = this.getPreferences("org.eclipse.jdt.core");
        for (String kind : new String[]{"lineNumber", "localVariable", "sourceFile"}) {
            if (!"generate".equals(p.getProperty("org.eclipse.jdt.core.compiler.debug." + kind))) continue;
            return true;
        }
        return false;
    }

    public boolean isDeprecation() {
        Properties p = this.getPreferences("org.eclipse.jdt.core");
        return ProjectImportModel.warningOrError(p.getProperty("org.eclipse.jdt.core.compiler.problem.deprecation"));
    }

    public String getCompilerArgs() {
        Properties p = this.getPreferences("org.eclipse.jdt.core");
        StringBuilder b = new StringBuilder();
        ProjectImportModel.maybeAddWarning(b, p, "org.eclipse.jdt.core.compiler.problem.fallthroughCase", "-Xlint:fallthrough");
        ProjectImportModel.maybeAddWarning(b, p, "org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", "-Xlint:finally");
        ProjectImportModel.maybeAddWarning(b, p, "org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "-Xlint:serial");
        ProjectImportModel.maybeAddWarning(b, p, "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "-Xlint:unchecked");
        return b.toString();
    }

    private static boolean warningOrError(String val) {
        return "warning".equals(val) || "error".equals(val);
    }

    private static void maybeAddWarning(StringBuilder b, Properties p, String eclipseKey, String javacFlag) {
        if (ProjectImportModel.warningOrError(p.getProperty(eclipseKey))) {
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append(javacFlag);
        }
    }

    public String getEncoding() {
        Properties p = this.getPreferences("org.eclipse.core.resources");
        String enc = p.getProperty("encoding/<project>");
        if (enc != null) {
            return enc;
        }
        enc = p.getProperty("encoding");
        if (enc != null) {
            return enc;
        }
        return "UTF-8";
    }

    private Properties getPreferences(String plugin) {
        Properties p = new Properties();
        String settings = ".settings/" + plugin + ".prefs";
        EclipseUtils.tryLoad(p, this.getEclipseWorkspaceFolder(), ".metadata/.plugins/org.eclipse.core.runtime/" + settings);
        EclipseUtils.tryLoad(p, this.getEclipseProjectFolder(), settings);
        return p;
    }

    public Collection<LaunchConfiguration> getLaunchConfigurations() {
        Workspace workspace = this.project.getWorkspace();
        if (workspace == null) {
            return Collections.emptySet();
        }
        ArrayList<LaunchConfiguration> configs = new ArrayList<LaunchConfiguration>();
        for (LaunchConfiguration config : workspace.getLaunchConfigurations()) {
            if (!this.getProjectName().equals(config.getProjectName())) continue;
            configs.add(config);
        }
        return configs;
    }

    public List<WizardDescriptor.Panel<WizardDescriptor>> getExtraWizardPanels() {
        return this.extraWizardPanels;
    }
}

