/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeimage.api.debug;

import java.io.File;
import java.util.List;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.openide.util.Lookup;

public final class StartDebugParameters {
    private final List<String> command;
    private final File workingDirectory;
    private final String debugger;
    private final String displayName;
    private final ExecutionDescriptor executionDescriptor;
    private final Lookup contextLookup;

    private StartDebugParameters(List<String> command, File workingDirectory, String debugger, String displayName, ExecutionDescriptor executionDescriptor, Lookup contextLookup) {
        this.command = command;
        this.workingDirectory = workingDirectory;
        this.debugger = debugger;
        this.displayName = displayName;
        this.executionDescriptor = executionDescriptor;
        this.contextLookup = contextLookup;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getDebugger() {
        return this.debugger;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ExecutionDescriptor getExecutionDescriptor() {
        return this.executionDescriptor;
    }

    public Lookup getContextLookup() {
        return this.contextLookup;
    }

    public static Builder newBuilder(List<String> command) {
        return new Builder(command);
    }

    public static final class Builder {
        private final List<String> command;
        private File workingDirectory;
        private String debugger;
        private String displayName;
        private ExecutionDescriptor executionDescriptor;
        private Lookup contextLookup;

        Builder(List<String> command) {
            this.command = command;
        }

        public Builder workingDirectory(File workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder debugger(String debugger) {
            this.debugger = debugger;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder executionDescriptor(ExecutionDescriptor executionDescriptor) {
            this.executionDescriptor = executionDescriptor;
            return this;
        }

        public Builder lookup(Lookup contextLookup) {
            this.contextLookup = contextLookup;
            return this;
        }

        public StartDebugParameters build() {
            return new StartDebugParameters(this.command, this.workingDirectory, this.debugger, this.displayName, this.executionDescriptor, this.contextLookup);
        }
    }
}

