/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.OQLSupport;
import org.netbeans.modules.profiler.heapwalk.ui.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

public class OQLQueryCustomizer {
    private static HelpCtx HELP_CTX_SAVE_QUERY = new HelpCtx("OQLQueryCustomizer.SaveQuery.HelpCtx");
    private static HelpCtx HELP_CTX_QUERY_PROPS = new HelpCtx("OQLQueryCustomizer.QueryProps.HelpCtx");
    private static Icon ICON_UP = Icons.getIcon((String)"GeneralIcons.Up");
    private static Icon ICON_DOWN = Icons.getIcon((String)"GeneralIcons.Down");

    public static boolean saveQuery(String query, OQLSupport.OQLTreeModel treeModel, JTree tree) {
        JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)Bundle.OQLQueryCustomizer_OkButtonText());
        CustomizerPanel customizer = new CustomizerPanel(okButton, treeModel);
        DialogDescriptor dd = new DialogDescriptor((Object)customizer, Bundle.OQLQueryCustomizer_SaveQueryCaption(), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, HELP_CTX_SAVE_QUERY, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == okButton) {
            OQLSupport.OQLQueryNode node;
            if (customizer.isNewQuery()) {
                OQLSupport.Query q = new OQLSupport.Query(query, customizer.getQueryName(), customizer.getQueryDescription());
                node = new OQLSupport.OQLQueryNode(q);
                treeModel.customCategory().add(node);
                treeModel.nodeStructureChanged(treeModel.customCategory());
            } else {
                node = (OQLSupport.OQLQueryNode)customizer.getSelectedValue();
                ((OQLSupport.Query)node.getUserObject()).setScript(query);
                treeModel.nodeChanged(node);
            }
            tree.setSelectionPath(new TreePath(treeModel.getPathToRoot(node)));
            return true;
        }
        return false;
    }

    public static boolean editNode(final OQLSupport.OQLNode node, final OQLSupport.OQLTreeModel treeModel, final JTree tree) {
        Object[] objectArray;
        JButton closeButton;
        boolean readOnly = node.isReadOnly();
        final OQLSupport.OQLNode parent = (OQLSupport.OQLNode)node.getParent();
        int originalIndex = parent.getIndex(node);
        JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)Bundle.OQLQueryCustomizer_OkButtonText());
        final JButton[] upDownButtons = new JButton[2];
        upDownButtons[0] = new JButton(ICON_UP){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                int index = parent.getIndex(node) - 1;
                treeModel.removeNodeFromParent(node);
                treeModel.insertNodeInto(node, parent, index);
                tree.setSelectionPath(new TreePath(treeModel.getPathToRoot(node)));
                OQLQueryCustomizer.updateButtons(upDownButtons, node);
            }
        };
        upDownButtons[0].setToolTipText(Bundle.OQLQueryCustomizer_UpButtonToolTip());
        upDownButtons[0].getAccessibleContext().setAccessibleName(Bundle.OQLQueryCustomizer_UpButtonAccessName());
        upDownButtons[1] = new JButton(ICON_DOWN){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                int index = parent.getIndex(node) + 1;
                treeModel.removeNodeFromParent(node);
                treeModel.insertNodeInto(node, parent, index);
                tree.setSelectionPath(new TreePath(treeModel.getPathToRoot(node)));
                OQLQueryCustomizer.updateButtons(upDownButtons, node);
            }
        };
        upDownButtons[1].setToolTipText(Bundle.OQLQueryCustomizer_DownButtonToolTip());
        upDownButtons[1].getAccessibleContext().setAccessibleName(Bundle.OQLQueryCustomizer_DownButtonAccessName());
        CustomizerPanel customizer = new CustomizerPanel(okButton, node.toString(), node.getDescription(), readOnly);
        customizer.getInputMap(2).put(KeyStroke.getKeyStroke(38, 8), "MOVE_UP");
        customizer.getActionMap().put("MOVE_UP", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (upDownButtons[0].isEnabled()) {
                    upDownButtons[0].doClick();
                }
            }
        });
        customizer.getInputMap(2).put(KeyStroke.getKeyStroke(40, 8), "MOVE_DOWN");
        customizer.getActionMap().put("MOVE_DOWN", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (upDownButtons[1].isEnabled()) {
                    upDownButtons[1].doClick();
                }
            }
        });
        JButton jButton = closeButton = readOnly ? new JButton() : null;
        if (closeButton != null) {
            Mnemonics.setLocalizedText((AbstractButton)closeButton, (String)Bundle.OQLQueryCustomizer_CloseButtonText());
        }
        if (readOnly) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = closeButton;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = okButton;
            objectArray = objectArray3;
            objectArray3[1] = DialogDescriptor.CANCEL_OPTION;
        }
        Object[] options = objectArray;
        JButton defaultButton = readOnly ? closeButton : okButton;
        DialogDescriptor dd = new DialogDescriptor((Object)customizer, Bundle.OQLQueryCustomizer_QueryPropertiesCaption(node.getCaption()), true, options, (Object)defaultButton, 0, HELP_CTX_QUERY_PROPS, null);
        dd.setAdditionalOptions(new Object[]{upDownButtons[0], upDownButtons[1]});
        OQLQueryCustomizer.updateButtons(upDownButtons, node);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == okButton) {
            OQLSupport.Query query = (OQLSupport.Query)node.getUserObject();
            query.setName(customizer.getQueryName());
            query.setDescription(customizer.getQueryDescription());
            treeModel.nodeChanged(node);
            return true;
        }
        int index = parent.getIndex(node);
        if (index != originalIndex) {
            treeModel.removeNodeFromParent(node);
            treeModel.insertNodeInto(node, parent, originalIndex);
            tree.setSelectionPath(new TreePath(treeModel.getPathToRoot(node)));
        }
        return false;
    }

    private static void updateButtons(JButton[] upDownButtons, OQLSupport.OQLNode node) {
        if (node.isReadOnly()) {
            upDownButtons[0].setEnabled(false);
            upDownButtons[1].setEnabled(false);
        } else {
            upDownButtons[0].setEnabled(node.getPreviousSibling() != null);
            upDownButtons[1].setEnabled(node.getNextSibling() != null);
        }
    }

    private static class CustomizerPanel
    extends JPanel {
        private JComponent submitComponent;
        private Object lastSelectedValue;
        private JRadioButton newRadio;
        private JSeparator newSeparator;
        private JLabel nameLabel;
        private JTextField nameField;
        private JLabel descriptionLabel;
        private JTextArea descriptionArea;
        private JRadioButton existingRadio;
        private JSeparator existingSeparator;
        private JLabel existingLabel;
        private JList existingList;

        public CustomizerPanel(JComponent submitComponent, OQLSupport.OQLTreeModel treeModel) {
            this.submitComponent = submitComponent;
            this.initComponents(treeModel, false);
            this.updateComponents();
        }

        public CustomizerPanel(JComponent submitComponent, String name, String description, boolean readOnly) {
            this.submitComponent = submitComponent;
            this.initComponents(null, readOnly);
            this.nameField.setText(name);
            this.descriptionArea.setText(description == null ? "" : description);
            try {
                this.descriptionArea.setCaretPosition(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updateComponents();
        }

        public boolean isNewQuery() {
            return this.newRadio == null || this.newRadio.isSelected();
        }

        public String getQueryName() {
            return this.nameField.getText().trim();
        }

        public String getQueryDescription() {
            String description = this.descriptionArea.getText().trim();
            return description.length() > 0 ? description : null;
        }

        public Object getSelectedValue() {
            return this.existingList.getSelectedValue();
        }

        private void updateComponents() {
            if (this.newRadio != null) {
                boolean createNew = this.newRadio.isSelected();
                this.nameLabel.setEnabled(createNew);
                this.nameField.setEnabled(createNew);
                this.descriptionLabel.setEnabled(createNew);
                this.descriptionArea.setEnabled(createNew);
                this.existingLabel.setEnabled(!createNew);
                if (createNew && this.existingList.isEnabled()) {
                    this.lastSelectedValue = this.existingList.getSelectedValue();
                    this.existingList.setEnabled(false);
                    this.existingList.clearSelection();
                } else if (!createNew && !this.existingList.isEnabled()) {
                    this.existingList.setEnabled(true);
                    if (this.lastSelectedValue == null) {
                        this.lastSelectedValue = this.existingList.getModel().getElementAt(0);
                    }
                    this.existingList.setSelectedValue(this.lastSelectedValue, false);
                }
            }
            if (this.existingRadio != null && this.existingRadio.isSelected()) {
                this.submitComponent.setEnabled(this.existingList.getSelectedValue() != null);
            } else {
                this.submitComponent.setEnabled(this.nameField.getText().trim().length() > 0);
            }
        }

        private void initComponents(OQLSupport.OQLTreeModel treeModel, boolean readOnly) {
            GridBagConstraints c;
            final boolean allowExisting = treeModel != null && treeModel.hasCustomQueries();
            this.setLayout(new GridBagLayout());
            if (allowExisting) {
                JPanel headerContainer1 = new JPanel(new GridBagLayout());
                this.newRadio = new JRadioButton(){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        this.updateComponents();
                    }
                };
                Mnemonics.setLocalizedText((AbstractButton)this.newRadio, (String)Bundle.OQLQueryCustomizer_NewQueryRadioText());
                this.newRadio.setSelected(true);
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 0;
                c.anchor = 17;
                c.fill = 0;
                c.insets = new Insets(0, 0, 0, 0);
                headerContainer1.add((Component)this.newRadio, c);
                this.newSeparator = new JSeparator(0){

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }
                };
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 0;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridwidth = 0;
                c.anchor = 17;
                c.fill = 2;
                c.insets = new Insets(0, 0, 0, 0);
                headerContainer1.add((Component)this.newSeparator, c);
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 0;
                c.gridwidth = 0;
                c.anchor = 17;
                c.fill = 2;
                c.insets = new Insets(8, 8, 0, 8);
                this.add((Component)headerContainer1, c);
            }
            this.nameLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)Bundle.OQLQueryCustomizer_NameLabelText());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(allowExisting ? 8 : 16, allowExisting ? 40 : 16, 8, 8);
            this.add((Component)this.nameLabel, c);
            this.nameField = new JTextField();
            this.nameLabel.setLabelFor(this.nameField);
            this.nameField.setText(Bundle.OQLQueryCustomizer_DefaultQueryName());
            this.nameField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateComponents();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateComponents();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateComponents();
                }
            });
            this.nameField.setEditable(!readOnly);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.weightx = 1.0;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(allowExisting ? 8 : 16, 0, 8, 16);
            this.add((Component)this.nameField, c);
            this.descriptionLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)Bundle.OQLQueryCustomizer_DescriptionLabelText());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(8, allowExisting ? 40 : 16, 8, 8);
            this.add((Component)this.descriptionLabel, c);
            this.descriptionArea = new JTextArea();
            this.descriptionLabel.setLabelFor(this.descriptionArea);
            this.descriptionArea.setLineWrap(true);
            this.descriptionArea.setWrapStyleWord(true);
            this.descriptionArea.setFont(this.descriptionLabel.getFont());
            this.descriptionArea.setRows(3);
            JScrollPane descriptionAreaScroll = new JScrollPane(this.descriptionArea, 20, 30){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(250, super.getPreferredSize().height);
                }

                @Override
                public Dimension getMinimumSize() {
                    return allowExisting ? this.getPreferredSize() : super.getMinimumSize();
                }
            };
            this.descriptionArea.setEditable(!readOnly);
            if (readOnly) {
                this.descriptionArea.setBackground(this.nameField.getBackground());
            }
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 3;
            if (!allowExisting) {
                c.weighty = 1.0;
            }
            c.gridwidth = 0;
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(0, 0, allowExisting ? 8 : 16, 16);
            this.add((Component)descriptionAreaScroll, c);
            if (allowExisting) {
                JPanel headerContainer2 = new JPanel(new GridBagLayout());
                this.existingRadio = new JRadioButton(){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        this.updateComponents();
                    }
                };
                Mnemonics.setLocalizedText((AbstractButton)this.existingRadio, (String)Bundle.OQLQueryCustomizer_ExistingQueryRadioText());
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 4;
                c.anchor = 17;
                c.fill = 0;
                c.insets = new Insets(0, 0, 0, 0);
                headerContainer2.add((Component)this.existingRadio, c);
                this.existingSeparator = new JSeparator(0){

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }
                };
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 4;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridwidth = 0;
                c.anchor = 17;
                c.fill = 2;
                c.insets = new Insets(0, 0, 0, 0);
                headerContainer2.add((Component)this.existingSeparator, c);
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 4;
                c.gridwidth = 0;
                c.anchor = 17;
                c.fill = 2;
                c.insets = new Insets(8, 8, 0, 8);
                this.add((Component)headerContainer2, c);
                this.existingLabel = new JLabel();
                Mnemonics.setLocalizedText((JLabel)this.existingLabel, (String)Bundle.OQLQueryCustomizer_UpdateQueryLabelText());
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 5;
                c.gridwidth = 0;
                c.anchor = 17;
                c.fill = 0;
                c.insets = new Insets(8, 40, 8, 8);
                this.add((Component)this.existingLabel, c);
                Vector<TreeNode> v = new Vector<TreeNode>();
                Enumeration<TreeNode> e = treeModel.customCategory().children();
                while (e.hasMoreElements()) {
                    v.add(e.nextElement());
                }
                this.existingList = new JList(v);
                this.existingLabel.setLabelFor(this.existingList);
                this.existingList.setVisibleRowCount(3);
                this.existingList.setSelectionMode(0);
                this.existingList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        this.updateComponents();
                    }
                });
                JScrollPane existingListScroll = new JScrollPane(this.existingList, 20, 30);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 6;
                c.weighty = 1.0;
                c.gridwidth = 0;
                c.anchor = 18;
                c.fill = 1;
                c.insets = new Insets(0, 0, 16, 16);
                this.add((Component)existingListScroll, c);
                ButtonGroup radios = new ButtonGroup();
                radios.add(this.newRadio);
                radios.add(this.existingRadio);
            }
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                nameField.requestFocus();
                                nameField.selectAll();
                            }
                        });
                    }
                }
            });
        }
    }
}

