/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.history;

import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.history.HistoryActionSupport;
import org.netbeans.modules.versioning.spi.VCSHistoryProvider;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;

public abstract class HistoryAction
extends NodeAction {
    private Lookup context;
    private final HistoryActionSupport<VCSHistoryProvider.HistoryEntry> support = new HistoryActionSupport<VCSHistoryProvider.HistoryEntry>(this.getCallback());
    private HistoryActionSupport.Callback<VCSHistoryProvider.HistoryEntry> callback;
    private final String name;
    private final boolean multipleHistory;

    public HistoryAction() {
        this(null, true);
    }

    public HistoryAction(String name) {
        this(name, true);
    }

    public HistoryAction(String name, boolean multipleHistory) {
        this.name = name;
        this.multipleHistory = multipleHistory;
    }

    protected abstract void perform(VCSHistoryProvider.HistoryEntry var1, Set<File> var2);

    public String getName() {
        assert (this.name != null);
        return this.name;
    }

    protected boolean isMultipleHistory() {
        return this.multipleHistory;
    }

    protected String getRevisionShort() {
        return this.support.getRevisionShort();
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        this.context = actionContext;
        return super.createContextAwareInstance(actionContext);
    }

    private Lookup getContext() {
        return this.context;
    }

    protected void performAction(Node[] activatedNodes) {
        this.support.performAction(activatedNodes);
    }

    protected boolean enable(Node[] activatedNodes) {
        return this.support.hasEntryAndFiles(activatedNodes);
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    private HistoryActionSupport.Callback<VCSHistoryProvider.HistoryEntry> getCallback() {
        if (this.callback == null) {
            this.callback = new HistoryActionSupport.Callback<VCSHistoryProvider.HistoryEntry>(){

                @Override
                public void call(VCSHistoryProvider.HistoryEntry entry, Set<VCSFileProxy> files) {
                    HashSet<File> s = new HashSet<File>();
                    for (VCSFileProxy file : files) {
                        File f = file.toFile();
                        if (f == null) continue;
                        s.add(f);
                    }
                    HistoryAction.this.perform(entry, s);
                }

                @Override
                public HistoryActionSupport.HistoryEntryWrapper<VCSHistoryProvider.HistoryEntry> lookupEntry(Node node) {
                    VCSHistoryProvider.HistoryEntry he = (VCSHistoryProvider.HistoryEntry)node.getLookup().lookup(VCSHistoryProvider.HistoryEntry.class);
                    return he != null ? new HistoryEntryImpl(he) : null;
                }

                @Override
                public Lookup getContext() {
                    return HistoryAction.this.getContext();
                }

                @Override
                public boolean isMultipleHistory() {
                    return HistoryAction.this.isMultipleHistory();
                }
            };
        }
        return this.callback;
    }

    private class HistoryEntryImpl
    implements HistoryActionSupport.HistoryEntryWrapper<VCSHistoryProvider.HistoryEntry> {
        private final VCSHistoryProvider.HistoryEntry he;

        public HistoryEntryImpl(VCSHistoryProvider.HistoryEntry he) {
            this.he = he;
        }

        @Override
        public VCSHistoryProvider.HistoryEntry getHistoryEntry() {
            return this.he;
        }

        @Override
        public String getRevisionShort() {
            return this.he.getRevisionShort();
        }

        @Override
        public Date getDateTime() {
            return this.he.getDateTime();
        }

        @Override
        public String getRevision() {
            return this.he.getRevision();
        }
    }
}

