/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import io.foojay.api.discoclient.pkg.MajorVersion;
import io.foojay.api.discoclient.pkg.ReleaseStatus;
import io.foojay.api.discoclient.util.Helper;
import io.foojay.api.discoclient.util.OutputFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionNumber
implements Comparable<VersionNumber> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionNumber.class);
    public static final Pattern VERSION_NO_PATTERN = Pattern.compile("([1-9]\\d*)((u(\\d+))|(\\.?(\\d+)?\\.?(\\d+)?\\.?(\\d+)?\\.?(\\d+)?\\.(\\d+)))?((_|b)(\\d+))?((-|\\+|\\.)([a-zA-Z0-9\\-\\+]+)(\\.[0-9]+)?)?");
    public static final Pattern EA_PATTERN = Pattern.compile("(ea|EA)((\\.|\\+|\\-)([0-9]+))?");
    public static final Pattern EA_BUILD_NUMBER_PATTERN = Pattern.compile("(\\.?)([0-9]+)");
    public static final Pattern BUILD_NUMBER_PATTERN = Pattern.compile("\\+?(b|B)([0-9]+)");
    public static final Pattern LEADING_INT_PATTERN = Pattern.compile("^[0-9]*");
    @NotNull
    @Positive
    private OptionalInt feature;
    @Positive
    private OptionalInt interim;
    @Positive
    private OptionalInt update;
    @Positive
    private OptionalInt patch;
    @Positive
    private OptionalInt fifth;
    @Positive
    private OptionalInt sixth;
    @Positive
    private OptionalInt build;
    @Positive
    private OptionalInt preBuild;
    private Optional<ReleaseStatus> releaseStatus;

    public VersionNumber() {
        this(OptionalInt.empty(), OptionalInt.empty(), OptionalInt.empty(), OptionalInt.empty(), OptionalInt.empty(), OptionalInt.empty(), OptionalInt.empty(), Optional.empty(), OptionalInt.empty());
    }

    public VersionNumber(@NotNull VersionNumber versionNumber) {
        this(versionNumber.getFeature(), versionNumber.getInterim(), versionNumber.getUpdate(), versionNumber.getPatch(), versionNumber.getFifth(), versionNumber.getSixth(), versionNumber.getBuild(), versionNumber.getReleaseStatus(), versionNumber.getPreBuild());
    }

    public VersionNumber(@NotNull @Positive Integer feature) {
        this(feature, 0, 0, 0, 0, 0, null, null, null);
    }

    public VersionNumber(@NotNull @Positive Integer feature, @Positive Integer interim) {
        this(feature, interim, 0, 0, 0, 0, null, null, null);
    }

    public VersionNumber(@NotNull @Positive Integer feature, @Positive Integer interim, @Positive Integer update) {
        this(feature, interim, update, 0, 0, 0, null, null, null);
    }

    public VersionNumber(@NotNull @Positive Integer feature, @Positive Integer interim, @Positive Integer update, @Positive Integer patch) throws IllegalArgumentException {
        this(feature, interim, update, patch, 0, 0, null, null, null);
    }

    public VersionNumber(@NotNull @Positive Integer feature, @Positive Integer interim, @Positive Integer update, @Positive Integer patch, @Positive Integer fifth, @Positive Integer sixth) {
        this(feature, interim, update, patch, fifth, sixth, null, null, null);
    }

    public VersionNumber(@NotNull @Positive Integer feature, @Positive Integer interim, @Positive Integer update, @Positive Integer patch, @Positive Integer fifth, @Positive Integer sixth, Integer build, ReleaseStatus releaseStatus, Integer preBuild) throws IllegalArgumentException {
        if (null == feature) {
            throw new IllegalArgumentException("Feature version cannot be null");
        }
        if (0 >= feature) {
            throw new IllegalArgumentException("Feature version cannot be smaller than 0");
        }
        if (null != interim && 0 > interim) {
            throw new IllegalArgumentException("Interim version cannot be smaller than 0");
        }
        if (null != update && 0 > update) {
            throw new IllegalArgumentException("Update version cannot be smaller than 0");
        }
        if (null != patch && 0 > patch) {
            throw new IllegalArgumentException("Patch version cannot be smaller than 0");
        }
        if (null != fifth && 0 > fifth) {
            throw new IllegalArgumentException("Fifth number cannot be smaller than 0");
        }
        if (null != sixth && 0 > sixth) {
            throw new IllegalArgumentException("Sixth number cannot be smaller than 0");
        }
        if (null != build && 0 > build) {
            throw new IllegalArgumentException("Build number cannot be smaller than 0");
        }
        if (null != preBuild && 0 > preBuild) {
            throw new IllegalArgumentException("PreBuild number cannot be smaller than 0");
        }
        this.feature = OptionalInt.of(feature);
        this.interim = null == interim ? OptionalInt.of(0) : OptionalInt.of(interim);
        this.update = null == update ? OptionalInt.of(0) : OptionalInt.of(update);
        this.patch = null == patch ? OptionalInt.of(0) : OptionalInt.of(patch);
        this.fifth = null == fifth ? OptionalInt.of(0) : OptionalInt.of(fifth);
        this.sixth = null == sixth ? OptionalInt.of(0) : OptionalInt.of(sixth);
        this.build = null == build ? OptionalInt.empty() : OptionalInt.of(build);
        this.releaseStatus = null == releaseStatus ? Optional.empty() : Optional.of(releaseStatus);
        this.preBuild = null == preBuild ? OptionalInt.empty() : OptionalInt.of(preBuild);
    }

    public VersionNumber(OptionalInt feature, OptionalInt interim, OptionalInt update, OptionalInt patch) {
        this(feature, interim, update, patch, OptionalInt.of(0), OptionalInt.of(0), OptionalInt.empty(), Optional.empty(), OptionalInt.empty());
    }

    public VersionNumber(OptionalInt feature, OptionalInt interim, OptionalInt update, OptionalInt patch, OptionalInt fifth, OptionalInt sixth) {
        this(feature, interim, update, patch, fifth, sixth, OptionalInt.empty(), Optional.empty(), OptionalInt.empty());
    }

    public VersionNumber(OptionalInt feature, OptionalInt interim, OptionalInt update, OptionalInt patch, OptionalInt fifth, OptionalInt sixth, OptionalInt build, Optional<ReleaseStatus> releaseStatus, OptionalInt preBuild) {
        if (null == feature) {
            throw new IllegalArgumentException("Feature version cannot be null");
        }
        if (null != feature && feature.isPresent() && 0 >= feature.getAsInt()) {
            throw new IllegalArgumentException("Feature version cannot be smaller than 0");
        }
        if (null != interim && interim.isPresent() && 0 > interim.getAsInt()) {
            throw new IllegalArgumentException("Interim version cannot be smaller than 0");
        }
        if (null != update && update.isPresent() && 0 > update.getAsInt()) {
            throw new IllegalArgumentException("Update version cannot be smaller than 0");
        }
        if (null != patch && patch.isPresent() && 0 > patch.getAsInt()) {
            throw new IllegalArgumentException("Patch version cannot be smaller than 0");
        }
        if (null != fifth && fifth.isPresent() && 0 > fifth.getAsInt()) {
            throw new IllegalArgumentException("Fifth number cannot be smaller than 0");
        }
        if (null != sixth && sixth.isPresent() && 0 > sixth.getAsInt()) {
            throw new IllegalArgumentException("Sixth number cannot be smaller than 0");
        }
        if (null != build && build.isPresent() && 0 > build.getAsInt()) {
            throw new IllegalArgumentException("Build number cannot be smaller than 0");
        }
        if (null != preBuild && preBuild.isPresent() && 0 > preBuild.getAsInt()) {
            throw new IllegalArgumentException("PreBuild number cannot be smaller than 0");
        }
        this.feature = null == feature ? OptionalInt.empty() : feature;
        this.interim = null == interim ? OptionalInt.of(0) : interim;
        this.update = null == update ? OptionalInt.of(0) : update;
        this.patch = null == patch ? OptionalInt.of(0) : patch;
        this.fifth = null == fifth ? OptionalInt.of(0) : fifth;
        this.sixth = null == sixth ? OptionalInt.of(0) : sixth;
        this.build = null == build ? OptionalInt.empty() : build;
        this.releaseStatus = null == releaseStatus ? Optional.empty() : releaseStatus;
        this.preBuild = null == preBuild ? OptionalInt.empty() : preBuild;
    }

    public OptionalInt getFeature() {
        return this.feature;
    }

    public void setFeature(Integer feature) throws IllegalArgumentException {
        if (null == feature) {
            throw new IllegalArgumentException("Feature version cannot be null");
        }
        if (0 >= feature) {
            throw new IllegalArgumentException("Feature version cannot be smaller than 0");
        }
        this.feature = OptionalInt.of(feature);
    }

    public OptionalInt getInterim() {
        return this.interim;
    }

    public void setInterim(Integer interim) throws IllegalArgumentException {
        if (null != interim && 0 > interim) {
            throw new IllegalArgumentException("Interim version cannot be smaller than 0");
        }
        this.interim = null == interim ? OptionalInt.empty() : OptionalInt.of(interim);
    }

    public OptionalInt getUpdate() {
        return this.update;
    }

    public void setUpdate(Integer update) throws IllegalArgumentException {
        if (null != update && 0 > update) {
            throw new IllegalArgumentException("Update version cannot be smaller than 0");
        }
        this.update = null == update ? OptionalInt.empty() : OptionalInt.of(update);
    }

    public OptionalInt getPatch() {
        return this.patch;
    }

    public void setPatch(Integer patch) throws IllegalArgumentException {
        if (null != patch && 0 > patch) {
            throw new IllegalArgumentException("Patch version cannot be smaller than 0");
        }
        this.patch = null == patch ? OptionalInt.empty() : OptionalInt.of(patch);
    }

    public OptionalInt getFifth() {
        return this.fifth;
    }

    public void setFifth(Integer fifth) throws IllegalArgumentException {
        if (null != fifth && 0 > fifth) {
            throw new IllegalArgumentException("Fifth number cannot be smaller than 0");
        }
        this.fifth = null == fifth ? OptionalInt.empty() : OptionalInt.of(fifth);
    }

    public OptionalInt getSixth() {
        return this.sixth;
    }

    public void setSixth(Integer sixth) throws IllegalArgumentException {
        if (null != sixth && 0 > sixth) {
            throw new IllegalArgumentException("Sixth number cannot be smaller than 0");
        }
        this.sixth = null == sixth ? OptionalInt.empty() : OptionalInt.of(sixth);
    }

    public OptionalInt getBuild() {
        return this.build;
    }

    public void setBuild(Integer build) throws IllegalArgumentException {
        if (null != build && 0 > build) {
            throw new IllegalArgumentException("Build number cannot be smaller than 0");
        }
        this.build = null == build ? OptionalInt.empty() : OptionalInt.of(build);
    }

    public Optional<ReleaseStatus> getReleaseStatus() {
        return this.releaseStatus;
    }

    public void setReleaseStatus(ReleaseStatus releaseStatus) {
        if (null == releaseStatus) {
            throw new IllegalArgumentException("Release status cannot be null");
        }
        this.releaseStatus = Optional.of(releaseStatus);
    }

    public OptionalInt getPreBuild() {
        return this.preBuild;
    }

    public void setPreBuild(Integer preBuild) throws IllegalArgumentException {
        if (null != preBuild && 0 > preBuild) {
            throw new IllegalArgumentException("PreBuild number cannot be smaller than 0");
        }
        this.preBuild = null == preBuild ? OptionalInt.empty() : OptionalInt.of(preBuild);
    }

    public MajorVersion getMajorVersion() {
        return new MajorVersion(this.feature.isPresent() ? this.feature.getAsInt() : 0);
    }

    public String getNormalizedVersionNumber() {
        StringBuilder versionBuilder = new StringBuilder();
        if (!this.feature.isPresent()) {
            throw new IllegalArgumentException("Feature version number cannot be null");
        }
        versionBuilder.append(this.feature.getAsInt());
        versionBuilder.append(".").append(this.interim.isPresent() ? Integer.valueOf(this.interim.getAsInt()) : "0");
        versionBuilder.append(".").append(this.update.isPresent() ? Integer.valueOf(this.update.getAsInt()) : "0");
        versionBuilder.append(".").append(this.patch.isPresent() ? Integer.valueOf(this.patch.getAsInt()) : "0");
        versionBuilder.append(".").append(this.fifth.isPresent() ? Integer.valueOf(this.fifth.getAsInt()) : "0");
        versionBuilder.append(".").append(this.sixth.isPresent() ? Integer.valueOf(this.sixth.getAsInt()) : "0");
        return versionBuilder.toString();
    }

    public static VersionNumber fromText(String text) throws IllegalArgumentException {
        return VersionNumber.fromText(text, 0);
    }

    public static VersionNumber fromText(String text, int resultToMatch) throws IllegalArgumentException {
        List results;
        if (null == text || text.isEmpty()) {
            LOGGER.warn("No version number can be parsed because given text is null or empty.");
            return new VersionNumber();
        }
        String version = text.startsWith("1.") ? text.replace("1.", "") : text;
        try (Scanner s = new Scanner(version);){
            results = Helper.findAll(s, VERSION_NO_PATTERN).collect(Collectors.toList());
        }
        int noOfResults = results.size();
        int resultToTake = noOfResults > resultToMatch ? resultToMatch : 0;
        ArrayList<VersionNumber> numbersFound = new ArrayList<VersionNumber>();
        if (noOfResults > 0) {
            MatchResult buildNumberResult;
            List buildNumberResults;
            Throwable throwable;
            Scanner s;
            MatchResult result = (MatchResult)results.get(resultToTake);
            VersionNumber versionNumber = new VersionNumber(Integer.valueOf(result.group(1)));
            if (null != result.group(1) && null != result.group(2) && null != result.group(5) && null != result.group(6) && null != result.group(7) && null != result.group(9) && null != result.group(10) && null != result.group(11) && null != result.group(12) && null != result.group(13) && null != result.group(14) && null != result.group(15)) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6), version));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7), version));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(9), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(5) && null != result.group(6) && null != result.group(7) && null != result.group(10) && null != result.group(11) && null != result.group(12) && null != result.group(13) && null != result.group(14) && null != result.group(15) && null != result.group(16)) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6), version));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7), version));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(10), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(5) && null != result.group(6) && null != result.group(7) && null != result.group(8) && null != result.group(9) && null != result.group(10) && null != result.group(14) && null != result.group(15) && null != result.group(16)) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6), version));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7), version));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(8), version));
                versionNumber.setFifth(VersionNumber.getPositiveIntFromText(result.group(9), version));
                versionNumber.setSixth(VersionNumber.getPositiveIntFromText(result.group(10), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(5) && null != result.group(6) && null != result.group(7) && null != result.group(8) && null != result.group(10) && null != result.group(14) && null != result.group(15) && null != result.group(16)) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6), version));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7), version));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(8), version));
                versionNumber.setFifth(VersionNumber.getPositiveIntFromText(result.group(10), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(5) && null != result.group(10) && null != result.group(11) && null != result.group(12) && null != result.group(13) && null != result.group(14) && null != result.group(15) && null != result.group(16)) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(10), version));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(13), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(5) && null != result.group(6) && null != result.group(7) && null != result.group(10) && null != result.group(14) && null != result.group(15) && null != result.group(16)) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6), version));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7), version));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(10), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(5) && null != result.group(6) && null != result.group(10) && null != result.group(14) && null != result.group(15) && null != result.group(16)) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6), version));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(10), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(5) && null != result.group(6) && null != result.group(7) && null != result.group(8) && null != result.group(9) && null != result.group(10)) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6), version));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7), version));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(8), version));
                versionNumber.setFifth(VersionNumber.getPositiveIntFromText(result.group(9), version));
                versionNumber.setSixth(VersionNumber.getPositiveIntFromText(result.group(10), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(5) && null != result.group(6) && null != result.group(7) && null != result.group(8) && null != result.group(10)) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6), version));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7), version));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(8), version));
                versionNumber.setFifth(VersionNumber.getPositiveIntFromText(result.group(10), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(3) && null != result.group(4) && null != result.group(14) && null != result.group(15) && null != result.group(16)) {
                versionNumber.setInterim(0);
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(4), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(3) && null != result.group(4) && null != result.group(11) && null != result.group(12) && null != result.group(13)) {
                versionNumber.setInterim(0);
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(4), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(5) && null != result.group(6) && null != result.group(10) && null != result.group(14) && null != result.group(15) && null != result.group(16)) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6), version));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(10), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(5) && null != result.group(10) && null != result.group(11) && null != result.group(12) && null != result.group(13)) {
                versionNumber.setInterim(0);
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(13), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(5) && null != result.group(6) && null != result.group(7) && null != result.group(10)) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6), version));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7), version));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(10), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(5) && null != result.group(6) && null != result.group(10)) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6), version));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(10), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(5) && null != result.group(6) && null != result.group(10)) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6), version));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(10), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(3) && null != result.group(4)) {
                versionNumber.setInterim(0);
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(4), version));
            } else if (null != result.group(1) && null != result.group(2) && null != result.group(5) && null != result.group(10)) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(10), version));
            } else if (null == result.group(1) || null == result.group(14) || null == result.group(15) || null != result.group(16)) {
                // empty if block
            }
            if (null != result.group(16)) {
                MatchResult eaResult;
                List eaResults;
                s = new Scanner(result.group(16));
                throwable = null;
                try {
                    eaResults = Helper.findAll(s, EA_PATTERN).collect(Collectors.toList());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (s != null) {
                        if (throwable != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            s.close();
                        }
                    }
                }
                if (eaResults.size() > 0 && null != (eaResult = (MatchResult)eaResults.get(0)).group(1)) {
                    versionNumber.setReleaseStatus(ReleaseStatus.EA);
                    if (null == eaResult.group(4)) {
                        if (null != result.group(17)) {
                            List eaBuildNumberResults;
                            try (Scanner s2 = new Scanner(result.group(17));){
                                eaBuildNumberResults = Helper.findAll(s2, EA_BUILD_NUMBER_PATTERN).collect(Collectors.toList());
                            }
                            if (eaBuildNumberResults.size() > 0) {
                                MatchResult eaBuildNumberResult = (MatchResult)eaBuildNumberResults.get(0);
                                versionNumber.setPreBuild(Integer.parseInt(eaBuildNumberResult.group(2)));
                            }
                        }
                    } else {
                        versionNumber.setPreBuild(Integer.parseInt(eaResult.group(4)));
                    }
                }
            }
            s = new Scanner(version);
            throwable = null;
            try {
                buildNumberResults = Helper.findAll(s, BUILD_NUMBER_PATTERN).collect(Collectors.toList());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (s != null) {
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        s.close();
                    }
                }
            }
            if (buildNumberResults.size() > 0 && null != (buildNumberResult = (MatchResult)buildNumberResults.get(0)).group(2)) {
                versionNumber.setBuild(Integer.parseInt(buildNumberResult.group(2)));
            }
            if (!versionNumber.getInterim().isPresent() || !versionNumber.getInterim().isPresent()) {
                versionNumber.setInterim(0);
            }
            if (!versionNumber.getUpdate().isPresent() || !versionNumber.getUpdate().isPresent()) {
                versionNumber.setUpdate(0);
            }
            if (!versionNumber.getPatch().isPresent() || !versionNumber.getPatch().isPresent()) {
                versionNumber.setPatch(0);
            }
            if (!versionNumber.getFifth().isPresent() || !versionNumber.getFifth().isPresent()) {
                versionNumber.setFifth(0);
            }
            if (!versionNumber.getSixth().isPresent() || !versionNumber.getSixth().isPresent()) {
                versionNumber.setSixth(0);
            }
            numbersFound.add(versionNumber);
        }
        if (numbersFound.isEmpty()) {
            LOGGER.error("No suitable version number found in String: {}", (Object)text);
            return new VersionNumber();
        }
        return numbersFound.stream().max(Comparator.comparingInt(VersionNumber::numbersAvailable)).get();
    }

    public int numbersAvailable() {
        return 1 + (this.interim.isPresent() ? 1 : 0) + (this.update.isPresent() ? 1 : 0) + (this.patch.isPresent() ? 1 : 0) + (this.fifth.isPresent() ? 1 : 0) + (this.sixth.isPresent() ? 1 : 0);
    }

    private static Integer getPositiveIntFromText(String text, String fullTextToParse) {
        if (Helper.isPositiveInteger(text)) {
            return Integer.valueOf(text);
        }
        return -1;
    }

    private static Integer getLeadingIntFromText(String text, String fullTextToParse) {
        if (null == text || text.isEmpty()) {
            return -1;
        }
        Matcher matcher = LEADING_INT_PATTERN.matcher(text);
        if (matcher.find()) {
            return matcher.group(0).isEmpty() ? -1 : Integer.valueOf(matcher.group(0));
        }
        LOGGER.debug("Given text {} did not start with integer. Full text to parse was: {}", (Object)text, (Object)fullTextToParse);
        return -1;
    }

    public int compareForFilterTo(VersionNumber otherVersionNumber) {
        int comparisonResult = 0;
        if (!this.feature.isPresent() || !otherVersionNumber.getFeature().isPresent()) {
            return comparisonResult;
        }
        String[] version1Splits = this.toString().split("\\.");
        String[] version2Splits = otherVersionNumber.toString().split("\\.");
        int maxLengthOfVersionSplits = Math.min(version1Splits.length, version2Splits.length);
        for (int i = 0; i < maxLengthOfVersionSplits; ++i) {
            Integer v2;
            Integer v1 = i < version1Splits.length ? Integer.parseInt(version1Splits[i]) : 0;
            int compare = v1.compareTo(v2 = Integer.valueOf(i < version2Splits.length ? Integer.parseInt(version2Splits[i]) : 0));
            if (compare == 0) continue;
            comparisonResult = compare;
            break;
        }
        return comparisonResult;
    }

    public int hashCode() {
        return Objects.hash(this.feature.getAsInt(), this.interim.orElse(0), this.update.orElse(0), this.patch.orElse(0));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VersionNumber)) {
            return false;
        }
        VersionNumber other = (VersionNumber)obj;
        boolean isEqual = this.feature.getAsInt() == other.getFeature().getAsInt() ? (this.interim.isPresent() ? (other.getInterim().isPresent() ? (this.interim.getAsInt() == other.getInterim().getAsInt() ? (this.update.isPresent() ? (other.getUpdate().isPresent() ? (this.update.getAsInt() == other.getUpdate().getAsInt() ? (this.patch.isPresent() ? (other.getPatch().isPresent() ? (this.patch.getAsInt() == other.getPatch().getAsInt() ? (this.fifth.isPresent() ? (other.getFifth().isPresent() ? (this.fifth.getAsInt() == other.getFifth().getAsInt() ? (this.sixth.isPresent() ? (other.getSixth().isPresent() ? this.sixth.getAsInt() == other.getSixth().getAsInt() : false) : true) : false) : false) : true) : false) : false) : true) : false) : false) : true) : false) : false) : true) : false;
        if (isEqual && this.releaseStatus.isPresent() && ReleaseStatus.EA == this.releaseStatus.get() && this.preBuild.isPresent() && other.getReleaseStatus().isPresent() && ReleaseStatus.EA == other.getReleaseStatus().get() && other.getPreBuild().isPresent()) {
            isEqual = this.getPreBuild().getAsInt() == other.getPreBuild().getAsInt();
        }
        return isEqual;
    }

    public String toStringInclBuild(boolean javaFormat) {
        return this.toString(OutputFormat.REDUCED, javaFormat, true);
    }

    public String toString(OutputFormat outputFormat, boolean javaFormat, boolean includeReleaseStatusAndPreBuild) {
        String pre;
        String build;
        String string = build = this.build.isPresent() ? "+b" + this.build.getAsInt() : "";
        String string2 = this.releaseStatus.isPresent() ? (ReleaseStatus.EA == this.releaseStatus.get() ? "-ea" : "") : (pre = "");
        String preBuild = this.releaseStatus.isPresent() && ReleaseStatus.EA == this.releaseStatus.get() && this.preBuild.isPresent() ? (this.preBuild.getAsInt() > 0 ? "." + this.preBuild.getAsInt() : "") : "";
        StringBuilder versionBuilder = new StringBuilder();
        switch (outputFormat) {
            case REDUCED: 
            case REDUCED_COMPRESSED: {
                if (this.feature.isPresent()) {
                    versionBuilder.append(this.feature.getAsInt());
                }
                if (this.sixth.isPresent() && this.sixth.getAsInt() != 0) {
                    if (this.interim.isPresent()) {
                        versionBuilder.append(".").append(this.interim.getAsInt());
                    }
                    if (this.update.isPresent()) {
                        versionBuilder.append(".").append(this.update.getAsInt());
                    }
                    if (this.patch.isPresent()) {
                        versionBuilder.append(".").append(this.patch.getAsInt());
                    }
                    if (!javaFormat) {
                        if (this.fifth.isPresent()) {
                            versionBuilder.append(".").append(this.fifth.getAsInt());
                        }
                        if (this.sixth.isPresent()) {
                            versionBuilder.append(".").append(this.sixth.getAsInt());
                        }
                    }
                    if (includeReleaseStatusAndPreBuild) {
                        versionBuilder.append(pre).append(preBuild).append(build);
                    }
                    return versionBuilder.toString();
                }
                if (this.fifth.isPresent() && this.fifth.getAsInt() != 0) {
                    if (this.interim.isPresent()) {
                        versionBuilder.append(".").append(this.interim.getAsInt());
                    }
                    if (this.update.isPresent()) {
                        versionBuilder.append(".").append(this.update.getAsInt());
                    }
                    if (this.patch.isPresent()) {
                        versionBuilder.append(".").append(this.patch.getAsInt());
                    }
                    if (!javaFormat && this.fifth.isPresent()) {
                        versionBuilder.append(".").append(this.fifth.getAsInt());
                    }
                    if (includeReleaseStatusAndPreBuild) {
                        versionBuilder.append(pre).append(preBuild).append(build);
                    }
                    return versionBuilder.toString();
                }
                if (this.patch.isPresent() && this.patch.getAsInt() != 0) {
                    if (this.interim.isPresent()) {
                        versionBuilder.append(".").append(this.interim.getAsInt());
                    }
                    if (this.update.isPresent()) {
                        versionBuilder.append(".").append(this.update.getAsInt());
                    }
                    if (this.patch.isPresent()) {
                        versionBuilder.append(".").append(this.patch.getAsInt());
                    }
                    if (includeReleaseStatusAndPreBuild) {
                        versionBuilder.append(pre).append(preBuild).append(build);
                    }
                    return versionBuilder.toString();
                }
                if (this.update.isPresent() && this.update.getAsInt() != 0) {
                    if (this.interim.isPresent()) {
                        versionBuilder.append(".").append(this.interim.getAsInt());
                    }
                    if (this.update.isPresent()) {
                        versionBuilder.append(".").append(this.update.getAsInt());
                    }
                    if (includeReleaseStatusAndPreBuild) {
                        versionBuilder.append(pre).append(preBuild).append(build);
                    }
                    return versionBuilder.toString();
                }
                if (this.interim.isPresent() && this.interim.getAsInt() != 0) {
                    if (this.interim.isPresent()) {
                        versionBuilder.append(".").append(this.interim.getAsInt());
                    }
                    if (includeReleaseStatusAndPreBuild) {
                        versionBuilder.append(pre).append(preBuild).append(build);
                    }
                    return versionBuilder.toString();
                }
                if (includeReleaseStatusAndPreBuild) {
                    versionBuilder.append(pre).append(preBuild).append(build);
                }
                return versionBuilder.toString();
            }
        }
        if (this.feature.isPresent()) {
            versionBuilder.append(this.feature.getAsInt());
        }
        if (this.interim.isPresent()) {
            versionBuilder.append(".").append(this.interim.getAsInt());
        }
        if (this.update.isPresent()) {
            versionBuilder.append(".").append(this.update.getAsInt());
        }
        if (this.patch.isPresent()) {
            versionBuilder.append(".").append(this.patch.getAsInt());
        }
        if (!javaFormat) {
            if (this.fifth.isPresent()) {
                versionBuilder.append(".").append(this.fifth.getAsInt());
            }
            if (this.sixth.isPresent()) {
                versionBuilder.append(".").append(this.sixth.getAsInt());
            }
        }
        if (includeReleaseStatusAndPreBuild) {
            versionBuilder.append(pre).append(preBuild).append(build);
        }
        return versionBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL, true, true);
    }

    @Override
    public int compareTo(VersionNumber otherVersionNumber) {
        boolean equal = false;
        int smallerThan = -1;
        boolean largerThan = true;
        int ret = this.feature.isPresent() && otherVersionNumber.getFeature().isPresent() ? (this.feature.getAsInt() > otherVersionNumber.getFeature().getAsInt() ? 1 : (this.feature.getAsInt() < otherVersionNumber.getFeature().getAsInt() ? -1 : (this.interim.isPresent() && otherVersionNumber.getInterim().isPresent() ? (this.interim.getAsInt() > otherVersionNumber.getInterim().getAsInt() ? 1 : (this.interim.getAsInt() < otherVersionNumber.getInterim().getAsInt() ? -1 : (this.update.isPresent() && otherVersionNumber.getUpdate().isPresent() ? (this.update.getAsInt() > otherVersionNumber.getUpdate().getAsInt() ? 1 : (this.update.getAsInt() < otherVersionNumber.getUpdate().getAsInt() ? -1 : (this.patch.isPresent() && otherVersionNumber.getPatch().isPresent() ? (this.patch.getAsInt() > otherVersionNumber.getPatch().getAsInt() ? 1 : (this.patch.getAsInt() < otherVersionNumber.getPatch().getAsInt() ? -1 : (this.fifth.isPresent() && otherVersionNumber.getFifth().isPresent() ? (this.fifth.getAsInt() > otherVersionNumber.getFifth().getAsInt() ? 1 : (this.fifth.getAsInt() < otherVersionNumber.getFifth().getAsInt() ? -1 : (this.sixth.isPresent() && otherVersionNumber.getSixth().isPresent() ? (this.sixth.getAsInt() > otherVersionNumber.getSixth().getAsInt() ? 1 : (this.sixth.getAsInt() < otherVersionNumber.getSixth().getAsInt() ? -1 : 0)) : (this.sixth.isPresent() && !otherVersionNumber.getSixth().isPresent() ? 1 : (!this.sixth.isPresent() && otherVersionNumber.getSixth().isPresent() ? -1 : 0))))) : (this.fifth.isPresent() && !otherVersionNumber.getFifth().isPresent() ? 1 : (!this.fifth.isPresent() && otherVersionNumber.getFifth().isPresent() ? -1 : 0))))) : (this.patch.isPresent() && !otherVersionNumber.getPatch().isPresent() ? 1 : (!this.patch.isPresent() && otherVersionNumber.getPatch().isPresent() ? -1 : 0))))) : (this.update.isPresent() && !otherVersionNumber.getUpdate().isPresent() ? 1 : (!this.update.isPresent() && otherVersionNumber.getUpdate().isPresent() ? -1 : 0))))) : (this.interim.isPresent() && !otherVersionNumber.getInterim().isPresent() ? 1 : (!this.interim.isPresent() && otherVersionNumber.getInterim().isPresent() ? -1 : 0))))) : (this.feature.isPresent() && !otherVersionNumber.getFeature().isPresent() ? 1 : (!this.feature.isPresent() && !otherVersionNumber.getFeature().isPresent() ? -1 : 0));
        if (ret == 0) {
            int otherPreBuildNumber;
            int preBuildNumber;
            ret = this.releaseStatus.isPresent() && ReleaseStatus.EA == this.releaseStatus.get() && this.preBuild.isPresent() && otherVersionNumber.getReleaseStatus().isPresent() && ReleaseStatus.EA == otherVersionNumber.getReleaseStatus().get() && otherVersionNumber.getPreBuild().isPresent() ? ((preBuildNumber = this.getPreBuild().getAsInt()) > (otherPreBuildNumber = otherVersionNumber.getPreBuild().getAsInt()) ? 1 : (preBuildNumber < otherPreBuildNumber ? -1 : 0)) : (this.releaseStatus.isPresent() && ReleaseStatus.EA == this.releaseStatus.get() && this.preBuild.isPresent() && otherVersionNumber.getReleaseStatus().isPresent() && ReleaseStatus.EA == otherVersionNumber.getReleaseStatus().get() && !otherVersionNumber.getPreBuild().isPresent() ? 1 : (this.releaseStatus.isPresent() && ReleaseStatus.EA == this.releaseStatus.get() && !this.preBuild.isPresent() && otherVersionNumber.getReleaseStatus().isPresent() && ReleaseStatus.EA == otherVersionNumber.getReleaseStatus().get() && otherVersionNumber.getPreBuild().isPresent() ? -1 : 0));
        }
        return ret;
    }
}

