/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.j2se;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectGenerator;
import org.netbeans.modules.projectimport.eclipse.core.spi.LaunchConfiguration;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectFactorySupport;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectImportModel;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeFactory;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeUpdater;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class J2SEProjectFactory
implements ProjectTypeUpdater {
    private static final String JAVA_NATURE = "org.eclipse.jdt.core.javanature";
    private static final Icon J2SE_PROJECT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/j2seproject/ui/resources/j2seProject.png", (boolean)false);
    private static final String MANIFEST_FILE = "manifest.mf";

    public boolean canHandle(ProjectTypeFactory.ProjectDescriptor descriptor) {
        return descriptor.getNatures().contains(JAVA_NATURE);
    }

    public Project createProject(ProjectImportModel model, List<String> importProblems) throws IOException {
        File nbProjectDir = model.getNetBeansProjectLocation();
        if (ProjectFactorySupport.areSourceRootsOwned((ProjectImportModel)model, (File)nbProjectDir, importProblems)) {
            return null;
        }
        String buildScript = null;
        if (new File(nbProjectDir, "build.xml").exists()) {
            buildScript = "nb-build.xml";
        }
        AntProjectHelper helper = J2SEProjectGenerator.createProject((File)nbProjectDir, (String)model.getProjectName(), (File[])model.getEclipseSourceRootsAsFileArray(), (File[])model.getEclipseTestSourceRootsAsFileArray(), null, null, (String)buildScript);
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        boolean changed = false;
        if (new File(nbProjectDir, "dist").exists()) {
            ep.setProperty("dist.dir", "nbdist");
            changed = true;
        }
        if (new File(nbProjectDir, "build").exists()) {
            ep.setProperty("build.dir", "nbbuild");
            changed = true;
        }
        if (changed) {
            helper.putProperties("nbproject/project.properties", ep);
        }
        J2SEProject nbProject = (J2SEProject)ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)nbProjectDir)));
        ProjectFactorySupport.updateSourceRootLabels((List)model.getEclipseSourceRoots(), (SourceRoots)nbProject.getSourceRoots());
        ProjectFactorySupport.updateSourceRootLabels((List)model.getEclipseTestSourceRoots(), (SourceRoots)nbProject.getTestSourceRoots());
        ProjectFactorySupport.setupSourceExcludes((AntProjectHelper)helper, (ProjectImportModel)model, importProblems);
        this.setupCompilerProperties(helper, model);
        ProjectFactorySupport.updateProjectClassPath((AntProjectHelper)helper, (ReferenceHelper)nbProject.getReferenceHelper(), (ProjectImportModel)model, importProblems);
        if (model.getJavaPlatform() != null) {
            this.setExplicitJavaPlatform(helper, model);
        }
        this.addLaunchConfigurations(nbProject, model.getLaunchConfigurations());
        ProjectManager.getDefault().saveProject((Project)nbProject);
        return nbProject;
    }

    private void setExplicitJavaPlatform(AntProjectHelper helper, ProjectImportModel model) {
        Element pcd = helper.getPrimaryConfigurationData(true);
        NodeList sourceRootNodes = pcd.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
        assert (sourceRootNodes.getLength() == 1) : "Broken project.xml file";
        Element el = pcd.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/j2se-project/3", "explicit-platform");
        el.setAttribute("explicit-source-supported", "true");
        pcd.insertBefore(el, sourceRootNodes.item(0));
        helper.putPrimaryConfigurationData(pcd, true);
        EditableProperties prop = helper.getProperties("nbproject/project.properties");
        String ver = model.getJavaPlatform().getSpecification().getVersion().toString();
        String normalizedName = (String)model.getJavaPlatform().getProperties().get("platform.ant.name");
        prop.setProperty("platform.active", normalizedName);
        helper.putProperties("nbproject/project.properties", prop);
    }

    public String calculateKey(ProjectImportModel model) {
        return ProjectFactorySupport.calculateKey((ProjectImportModel)model);
    }

    public String update(Project project, ProjectImportModel model, String oldKey, List<String> importProblems) throws IOException {
        if (!(project instanceof J2SEProject)) {
            throw new IOException("is not java project: " + project.getClass().getName());
        }
        String newKey = this.calculateKey(model);
        String actualKey = ProjectFactorySupport.synchronizeProjectClassPath((Project)project, (AntProjectHelper)((J2SEProject)project).getAntProjectHelper(), (ReferenceHelper)((J2SEProject)project).getReferenceHelper(), (ProjectImportModel)model, (String)oldKey, (String)newKey, importProblems);
        this.setupCompilerProperties(((J2SEProject)project).getAntProjectHelper(), model);
        ProjectManager.getDefault().saveProject(project);
        return actualKey;
    }

    public Icon getProjectTypeIcon() {
        return J2SE_PROJECT_ICON;
    }

    public String getProjectTypeName() {
        return NbBundle.getMessage(J2SEProjectFactory.class, (String)"LABEL_Java_Project");
    }

    public List<WizardDescriptor.Panel<WizardDescriptor>> getAdditionalImportWizardPanels() {
        return Collections.emptyList();
    }

    private void setupCompilerProperties(AntProjectHelper helper, ProjectImportModel model) {
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        ep.setProperty("javac.source", model.getSourceLevel());
        ep.setProperty("javac.target", model.getTargetLevel());
        ep.setProperty("javac.deprecation", Boolean.toString(model.isDeprecation()));
        ep.setProperty("javac.compilerargs", model.getCompilerArgs());
        ep.setProperty("source.encoding", model.getEncoding());
        helper.putProperties("nbproject/project.properties", ep);
        ep = helper.getProperties("nbproject/private/private.properties");
        ep.setProperty("javac.debug", Boolean.toString(model.isDebug()));
        helper.putProperties("nbproject/private/private.properties", ep);
    }

    public File getProjectFileLocation(ProjectTypeFactory.ProjectDescriptor descriptor, String token) {
        return null;
    }

    private void addLaunchConfigurations(J2SEProject nbProject, Collection<LaunchConfiguration> launchConfigurations) throws IOException {
        Iterator<LaunchConfiguration> it = launchConfigurations.iterator();
        while (it.hasNext()) {
            LaunchConfiguration config = it.next();
            if (config.getType().equals("org.eclipse.jdt.launching.localJavaApplication") && config.getMainType() != null) continue;
            it.remove();
        }
        AntProjectHelper aph = nbProject.getAntProjectHelper();
        if (!launchConfigurations.isEmpty()) {
            EditableProperties props = aph.getProperties("nbproject/project.properties");
            J2SEProjectFactory.createManifest(nbProject.getProjectDirectory(), MANIFEST_FILE);
            props.put("manifest.file", MANIFEST_FILE);
            aph.putProperties("nbproject/project.properties", props);
        }
        if (launchConfigurations.size() == 1) {
            LaunchConfiguration config = launchConfigurations.iterator().next();
            EditableProperties props = aph.getProperties("nbproject/project.properties");
            this.storeConfig(config, props);
            aph.putProperties("nbproject/project.properties", props);
        } else if (!launchConfigurations.isEmpty()) {
            for (LaunchConfiguration config : launchConfigurations) {
                String path = "nbproject/configs/" + config.getName() + ".properties";
                EditableProperties props = aph.getProperties(path);
                this.storeConfig(config, props);
                aph.putProperties(path, props);
            }
            String path = "nbproject/private/config.properties";
            EditableProperties props = aph.getProperties(path);
            props.setProperty("config", launchConfigurations.iterator().next().getName());
            aph.putProperties(path, props);
        }
    }

    private void storeConfig(LaunchConfiguration config, EditableProperties props) {
        props.setProperty("main.class", config.getMainType());
        if (config.getProgramArguments() != null) {
            props.setProperty("application.args", config.getProgramArguments());
        }
        if (config.getVmArguments() != null) {
            props.setProperty("run.jvmargs", config.getVmArguments());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createManifest(FileObject dir, String manifestFile) throws IOException {
        FileObject manifest = dir.createData(manifestFile);
        FileLock lock = manifest.lock();
        try (OutputStream os = manifest.getOutputStream(lock);){
            PrintWriter pw = new PrintWriter(os);
            pw.println("Manifest-Version: 1.0");
            pw.println("X-COMMENT: Main-Class will be added automatically by build");
            pw.println();
            pw.flush();
        }
        finally {
            lock.releaseLock();
        }
    }
}

