/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell.execution;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.jshell.execution.StreamingExecutionControl;
import jdk.jshell.spi.ExecutionControl;

public abstract class JdiExecutionControl
extends StreamingExecutionControl
implements ExecutionControl {
    private final Map<String, ReferenceType> toReferenceType = new HashMap<String, ReferenceType>();

    protected JdiExecutionControl(ObjectOutput out, ObjectInput in) {
        super(out, in);
    }

    protected abstract VirtualMachine vm() throws ExecutionControl.EngineTerminationException;

    @Override
    public void redefine(ExecutionControl.ClassBytecodes[] cbcs) throws ExecutionControl.ClassInstallException, ExecutionControl.EngineTerminationException {
        try {
            VirtualMachine vm = this.vm();
            Map<ReferenceType, byte[]> rmp = Stream.of(cbcs).collect(Collectors.toMap(cbc -> this.referenceType(vm, cbc.name()), cbc -> cbc.bytecodes()));
            this.vm().redefineClasses(rmp);
        }
        catch (ExecutionControl.EngineTerminationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExecutionControl.ClassInstallException("redefine: " + ex.getMessage(), new boolean[cbcs.length]);
        }
    }

    protected ReferenceType referenceType(VirtualMachine vm, String name) {
        return this.toReferenceType.computeIfAbsent(name, n -> JdiExecutionControl.nameToRef(vm, n));
    }

    private static ReferenceType nameToRef(VirtualMachine vm, String name) {
        List<ReferenceType> rtl = vm.classesByName(name);
        if (rtl.size() != 1) {
            return null;
        }
        return rtl.get(0);
    }
}

