/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.apache.xml.resolver.Catalog;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.catalog.lib.IteratorIterator;
import org.netbeans.modules.xml.catalog.settings.CatalogSettings;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CatalogEntityResolver
extends UserCatalog
implements EntityResolver,
URIResolver {
    public EntityResolver getEntityResolver() {
        return this;
    }

    public URIResolver getURIResolver() {
        return this;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String patchedSystemId;
        InputSource result = null;
        Iterator it = null;
        CatalogSettings mounted = CatalogSettings.getDefault();
        if (mounted != null) {
            Object next;
            it = mounted.getCatalogs(new Class[]{EntityResolver.class});
            while (it.hasNext() && (result = (next = (EntityResolver)it.next()).resolveEntity(publicId, systemId)) == null) {
            }
            if (result == null && publicId != null) {
                it = mounted.getCatalogs(new Class[]{CatalogReader.class});
                while (it.hasNext()) {
                    next = (CatalogReader)it.next();
                    String sid = next.getSystemID(publicId);
                    if (sid == null) continue;
                    result = new InputSource(sid);
                    break;
                }
            }
        }
        if (result == null && "-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN".equals(publicId)) {
            URL url = Catalog.class.getResource("etc/catalog.dtd");
            result = new InputSource(url.toExternalForm());
        }
        if (result != null && (patchedSystemId = result.getSystemId()) != null) {
            patchedSystemId = patchedSystemId.replaceAll("\\+", "%20");
            patchedSystemId = patchedSystemId.replaceAll("\\ ", "%20");
            result.setSystemId(patchedSystemId);
        }
        return result;
    }

    public Iterator getPublicIDs() {
        IteratorIterator ret = new IteratorIterator();
        CatalogSettings mounted = CatalogSettings.getDefault();
        Iterator it = mounted.getCatalogs(new Class[]{CatalogReader.class});
        while (it.hasNext()) {
            CatalogReader next = (CatalogReader)it.next();
            Iterator ids = next.getPublicIDs();
            if (ids == null) continue;
            ret.add(ids);
        }
        return ret;
    }

    @Override
    public Source resolve(String publicId, String systemId) throws TransformerException {
        SAXSource result = null;
        CatalogSettings mounted = CatalogSettings.getDefault();
        if (publicId != null) {
            Iterator it = mounted.getCatalogs(new Class[]{CatalogReader.class});
            while (it.hasNext()) {
                CatalogReader next = (CatalogReader)it.next();
                try {
                    String sid = null;
                    if (publicId.startsWith("urn:publicid:")) {
                        String urn = publicId.substring(13);
                        sid = next.resolvePublic(this.URNtoPublic(urn));
                    } else {
                        sid = next.resolveURI(publicId);
                    }
                    if (sid == null) continue;
                    SAXSource source = new SAXSource();
                    source.setSystemId(sid);
                    result = source;
                    break;
                }
                catch (Error error) {
                }
            }
        }
        return result;
    }

    private String URNtoPublic(String urn) {
        return urn.replace('+', ' ').replaceAll(":", "//").replaceAll(";", "::").replaceAll("%2B", "+").replaceAll("%3A", ":").replaceAll("%2F", "/").replaceAll("%3B", ";").replaceAll("%27", "'").replaceAll("%3F", "?").replaceAll("%23", "#").replaceAll("%25", "%");
    }
}

