/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.launch;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.jshell.execution.StreamingExecutionControl;
import jdk.jshell.execution.Util;
import jdk.jshell.spi.ExecutionControl;
import org.netbeans.lib.nbjshell.NbExecutionControl;
import org.netbeans.lib.nbjshell.NbExecutionControlBase;
import org.netbeans.lib.nbjshell.RemoteJShellService;
import org.netbeans.modules.jshell.launch.JShellConnection;
import org.netbeans.modules.jshell.launch.ShellAgent;
import org.netbeans.modules.jshell.launch.ShellLaunchEvent;
import org.netbeans.modules.jshell.launch.ShellLaunchListener;
import org.netbeans.modules.jshell.launch.ShellLaunchManager;

public class RunExecutionEnvironment
extends NbExecutionControlBase
implements RemoteJShellService,
ShellLaunchListener,
NbExecutionControl {
    private static final Logger LOG = Logger.getLogger(RunExecutionEnvironment.class.getName());
    private final ShellAgent agent;
    private volatile boolean closed;
    private JShellConnection shellConnection;
    private ObjectInput dis;
    private ObjectOutput dos;
    private String targetSpec;
    private boolean suppressClasspath;

    public RunExecutionEnvironment(ShellAgent agent, ObjectOutput out, ObjectInput in, String targetSpec, JShellConnection c) {
        super(out, in);
        this.dis = in;
        this.dos = out;
        this.agent = agent;
        this.targetSpec = targetSpec;
        this.shellConnection = c;
        ShellLaunchManager.getInstance().addLaunchListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JShellConnection getOpenedConnection() {
        RunExecutionEnvironment runExecutionEnvironment = this;
        synchronized (runExecutionEnvironment) {
            return this.shellConnection;
        }
    }

    @Override
    protected void shutdown() {
        this.requestShutdown();
        super.shutdown();
    }

    protected boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.requestShutdown();
    }

    @Override
    public void stop() {
        if (this.shellConnection == null) {
            return;
        }
        int id = this.shellConnection.getRemoteAgentId();
        HashMap<String, OutputStream> io = new HashMap<String, OutputStream>();
        LOG.log(Level.FINE, "Creating agent connection for STOP command");
        try (JShellConnection stopConnection = this.agent.createConnection();){
            StreamingExecutionControl stopStream = (StreamingExecutionControl)Util.remoteInputOutput(stopConnection.getAgentOutput(), stopConnection.getAgentInput(), io, Collections.emptyMap(), (cmdIn, cmdOut) -> new StreamingExecutionControl((ObjectOutput)cmdOut, (ObjectInput)cmdIn));
            Object o = stopStream.extensionCommand("nb_stop", id);
            LOG.log(Level.FINE, "Sending STOP command for agent ID: " + id);
            int n = o instanceof Integer ? (Integer)o : -1;
        }
        catch (ExecutionControl.InternalException | ExecutionControl.RunException ex) {
            LOG.log(Level.INFO, "Error invoking JShell agent", ex.toString());
        }
        catch (ExecutionControl.EngineTerminationException ex) {
            this.shutdown();
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, "STOP agent creation failed", ex);
        }
    }

    @Override
    public boolean requestShutdown() {
        this.agent.closeConnection(this.shellConnection);
        return false;
    }

    @Override
    public void addToClasspath(String path) throws ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        if (!this.suppressClasspath) {
            super.addToClasspath(path);
        }
    }

    @Override
    public synchronized void closeStreams() {
        if (this.shellConnection == null) {
            return;
        }
        try {
            OutputStream os = this.shellConnection.getAgentInput();
            os.close();
        }
        catch (IOException os) {
            // empty catch block
        }
        try {
            InputStream is = this.shellConnection.getAgentOutput();
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.requestShutdown();
    }

    @Override
    public void connectionInitiated(ShellLaunchEvent ev) {
    }

    @Override
    public void handshakeCompleted(ShellLaunchEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(ShellLaunchEvent ev) {
        RunExecutionEnvironment runExecutionEnvironment = this;
        synchronized (runExecutionEnvironment) {
            if (ev.getConnection() != this.shellConnection || this.closed) {
                return;
            }
            this.closed = true;
        }
        ShellLaunchManager.getInstance().removeLaunchListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void agentDestroyed(ShellLaunchEvent ev) {
        RunExecutionEnvironment runExecutionEnvironment = this;
        synchronized (runExecutionEnvironment) {
            if (ev.getAgent() != this.agent || this.closed) {
                return;
            }
            this.shellConnection = null;
            this.closed = true;
        }
        ShellLaunchManager.getInstance().removeLaunchListener(this);
    }

    @Override
    public String getTargetSpec() {
        return this.targetSpec;
    }

    @Override
    public void suppressClasspathChanges(boolean b) {
        this.suppressClasspath = b;
    }

    @Override
    public ExecutionControl.ExecutionControlException getBrokenException() {
        return null;
    }
}

