/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.parsing;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdk.jshell.ExpressionSnippet;
import jdk.jshell.ImportSnippet;
import jdk.jshell.JShell;
import jdk.jshell.MethodSnippet;
import jdk.jshell.Snippet;
import jdk.jshell.TypeDeclSnippet;
import jdk.jshell.VarSnippet;
import org.netbeans.lib.nbjshell.JShellAccessor;
import org.netbeans.lib.nbjshell.SnippetWrapping;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.jshell.model.Rng;
import org.netbeans.modules.jshell.model.SnippetHandle;
import org.netbeans.modules.jshell.parsing.ModelAccessor;
import org.netbeans.modules.jshell.parsing.ShellAccessBridge;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;

public final class SnippetRegistry {
    private static final Logger LOG = Logger.getLogger(SnippetRegistry.class.getName());
    private static final String JSHELL_TRANSIENT_SNIPPET_CLASS = "$JShell$DOESNOTMATTER";
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final JShell state;
    private final Map<Snippet, SnippetHandle> snippets = new LinkedHashMap<Snippet, SnippetHandle>();
    private final Map<Key, Collection<SnippetHandle>> snippetsLookup = new HashMap<Key, Collection<SnippetHandle>>();
    private final Map<ConsoleSection, List<SnippetHandle>> sectionHandles = new WeakHashMap<ConsoleSection, List<SnippetHandle>>();
    private final Map<ConsoleSection, List<SnippetHandle>> transientHandles = new WeakHashMap<ConsoleSection, List<SnippetHandle>>();
    private final AtomicInteger counter;
    private final Map<Reference<SnippetHandle>, FileObject> cleanupTransientFiles = new HashMap<Reference<SnippetHandle>, FileObject>();
    private final ShellAccessBridge shellExecutor;
    private SnippetRegistry currentDelegate;
    private FileObject transientSnippetsRoot;
    private FileObject persistentSnippetsRoot;
    private final Map<Snippet, Long> snippetTimeStamps = new WeakHashMap<Snippet, Long>();

    public SnippetRegistry(JShell state, ShellAccessBridge shellExecutor, FileObject persistentRoot, FileObject transientRoot, SnippetRegistry previousRegistry) {
        this.state = state;
        this.persistentSnippetsRoot = persistentRoot;
        this.transientSnippetsRoot = transientRoot;
        this.shellExecutor = shellExecutor;
        AtomicInteger atomicInteger = this.counter = previousRegistry == null ? new AtomicInteger(0) : previousRegistry.counter;
        if (previousRegistry != null) {
            this.copyFrom(previousRegistry);
        }
    }

    public JShell getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged() {
        ArrayList<ChangeListener> ll;
        SnippetRegistry snippetRegistry = this;
        synchronized (snippetRegistry) {
            if (this.listeners.isEmpty()) {
                return;
            }
            ll = new ArrayList<ChangeListener>(this.listeners);
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : ll) {
            l.stateChanged(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnippetHandle installSnippet(Snippet s, ConsoleSection section, int sectionOffset, boolean nontransient) {
        SnippetWrapping wrap = this.wrap(s);
        SnippetHandle handle = null;
        SnippetRegistry snippetRegistry = this;
        synchronized (snippetRegistry) {
            Collection<SnippetHandle> handles;
            Key sk = Key.create(s);
            if (section != null) {
                List<SnippetHandle> sectionSnippets = this.sectionHandles.get(section);
                sectionSnippets = sectionSnippets == null ? new ArrayList<SnippetHandle>(1) : new ArrayList<SnippetHandle>(sectionSnippets);
                Rng[] fragments = null;
                int l = sectionSnippets.size();
                int start = sectionOffset;
                int end = sectionOffset + wrap.getSource().length();
                int so = section.offsetFromContents(start);
                int eo = section.offsetFromContents(end);
                fragments = section.computeFragments(new Rng(so, eo));
                handle = ModelAccessor.INSTANCE.createHandle(this, section, fragments, wrap, false);
                LOG.log(Level.FINER, "Section: {0}, installed snippet {1}, classname {2}", new Object[]{section, s, handle.getClassName()});
                sectionSnippets.add(handle);
                this.sectionHandles.put(section, sectionSnippets);
            } else {
                handles = this.snippetsLookup.get(sk);
                if (handles != null) {
                    for (SnippetHandle toCompare : handles) {
                        if (toCompare.getSource().equals(wrap.getSource()) && (handle = this.replaceSnippetHandle(sk, wrap, toCompare, nontransient)) != null) break;
                    }
                }
                if (handle == null) {
                    handle = ModelAccessor.INSTANCE.createHandle(this, null, null, wrap, !nontransient);
                }
            }
            if (wrap.getSnippet() != null) {
                this.snippets.put(wrap.getSnippet(), handle);
                handles = this.snippetsLookup.get(sk);
                if (handles == null) {
                    handles = new ArrayList<SnippetHandle>();
                    this.snippetsLookup.put(sk, handles);
                }
                handles.add(handle);
            }
            this.clearTransientSnippets();
        }
        this.fireStateChanged();
        return handle;
    }

    private SnippetHandle replaceSnippetHandle(Key sk, SnippetWrapping wrap, SnippetHandle replaced, boolean nonTransient) {
        SnippetHandle handle = ModelAccessor.INSTANCE.createHandle(this, replaced.getSection(), replaced.getFragments(), wrap, !nonTransient);
        ConsoleSection section = replaced.getSection();
        if (section != null) {
            List<SnippetHandle> sectionSnippets = this.sectionHandles.get(section);
            if (sectionSnippets == null) {
                return null;
            }
            int index = sectionSnippets.indexOf(replaced);
            if (index == -1) {
                return null;
            }
            sectionSnippets = new ArrayList<SnippetHandle>(sectionSnippets);
            sectionSnippets.set(index, handle);
            this.sectionHandles.put(section, sectionSnippets);
        }
        this.snippetsLookup.get(sk).remove(replaced);
        this.snippets.remove(replaced.getSnippet());
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFrom(SnippetRegistry other) {
        SnippetRegistry snippetRegistry = other;
        synchronized (snippetRegistry) {
            this.snippetsLookup.putAll(other.snippetsLookup);
            this.snippets.putAll(other.snippets);
            this.sectionHandles.putAll(other.sectionHandles);
            other.currentDelegate = this;
        }
    }

    private SnippetWrapping wrap(final Snippet s) {
        try {
            return this.shellExecutor.execute(new Callable<SnippetWrapping>(){

                @Override
                public SnippetWrapping call() throws Exception {
                    return JShellAccessor.snippetWrap(SnippetRegistry.this.state, s);
                }
            });
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private SnippetWrapping wrap(final String input) {
        try {
            return this.shellExecutor.execute(new Callable<SnippetWrapping>(){

                @Override
                public SnippetWrapping call() throws Exception {
                    return JShellAccessor.wrapInput(SnippetRegistry.this.state, input);
                }
            });
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private synchronized void clearTransientSnippets() {
        this.transientHandles.clear();
    }

    public synchronized SnippetHandle getHandle(Snippet snip) {
        return this.snippets.get(snip);
    }

    public synchronized Collection<Snippet> getSnippets() {
        return new ArrayList<Snippet>(this.snippets.keySet());
    }

    public synchronized List<SnippetHandle> getSectionSnippets(ConsoleSection s) {
        return this.getSectionSnippets(s, true);
    }

    synchronized List<SnippetHandle> getSectionSnippets(ConsoleSection s, boolean allowTransient) {
        List<SnippetHandle> snips;
        if (allowTransient && (snips = this.transientHandles.get(s)) != null) {
            return snips;
        }
        snips = this.sectionHandles.get(s);
        if (snips == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(snips);
    }

    public FileObject snippetFile(SnippetHandle snippet, int editedSnippetIndex) {
        if (this.currentDelegate != null) {
            return this.currentDelegate.snippetFile(snippet, editedSnippetIndex);
        }
        return this.createSnippetFile(snippet, null);
    }

    private String snippetFileName(SnippetHandle snippet) {
        String cn = snippet.getClassName();
        int dot = cn.lastIndexOf(46);
        if (dot != -1) {
            return cn.substring(dot + 1) + ".java";
        }
        return cn + ".java";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(Reference<SnippetHandle> ref) {
        FileObject f;
        SnippetRegistry snippetRegistry = this;
        synchronized (snippetRegistry) {
            f = this.cleanupTransientFiles.remove(ref);
            if (f == null) {
                return;
            }
        }
        try {
            f.delete();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachSeverity((Throwable)ex, (Level)Level.INFO));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject finalize(SnippetHandle h, FileObject f) {
        SnippetRegistry snippetRegistry = this;
        synchronized (snippetRegistry) {
            this.cleanupTransientFiles.put(new SWR(h), f);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject createSnippetFile(SnippetHandle info, String resName) {
        FileObject pkg;
        boolean transientFile = info.isTransient();
        try {
            pkg = FileUtil.createFolder((FileObject)(transientFile ? this.transientSnippetsRoot : this.persistentSnippetsRoot), (String)"REPL");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        String fn = resName != null ? resName : this.snippetFileName(info);
        String contents = info.getWrappedCode();
        if (contents == null) {
            return null;
        }
        Snippet snip = info.getSnippet();
        Long l = null;
        if (snip != null) {
            SnippetRegistry snippetRegistry = this;
            synchronized (snippetRegistry) {
                l = this.snippetTimeStamps.get(snip);
            }
        }
        int retries = 0;
        IOException lastException = null;
        while (retries++ < 10) {
            SnippetRegistry snippetRegistry;
            block31: {
                FileObject fob = pkg.getFileObject(fn);
                if (fob != null) {
                    if (l != null && l.longValue() == fob.lastModified().getTime()) {
                        return fob;
                    }
                    try {
                        fob.delete();
                    }
                    catch (IOException ex1) {
                        lastException = ex1;
                    }
                }
                OutputStream ostm = pkg.createAndOpen(fn);
                try {
                    try (OutputStreamWriter ows = new OutputStreamWriter(ostm, "UTF-8");){
                        ows.append(contents);
                        ows.flush();
                    }
                    FileObject ret = pkg.getFileObject(fn);
                    if (snip != null) {
                        snippetRegistry = this;
                        synchronized (snippetRegistry) {
                            this.snippetTimeStamps.put(snip, ret.lastModified().getTime());
                        }
                    }
                    ModelAccessor.INSTANCE.setFile(info, ret);
                    snippetRegistry = this.finalize(info, ret);
                    if (ostm == null) break block31;
                }
                catch (Throwable throwable) {
                    try {
                        if (ostm != null) {
                            try {
                                ostm.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        lastException = ex;
                    }
                }
                ostm.close();
            }
            return snippetRegistry;
        }
        if (lastException != null) {
            Exceptions.printStackTrace(lastException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SnippetHandle> createSnippets(ConsoleSection section, CharSequence snapshot, boolean extendToEnd) {
        List<SnippetHandle> snips;
        SnippetRegistry snippetRegistry = this;
        synchronized (snippetRegistry) {
            snips = this.sectionHandles.get(section);
            if (snips == null) {
                snips = this.transientHandles.get(section);
                if (snips != null) {
                    return snips;
                }
                snips = Collections.emptyList();
            }
        }
        Rng[] ranges = section.getAllSnippetBounds();
        if (ranges.length == snips.size()) {
            return snips;
        }
        ArrayList<SnippetHandle> result = new ArrayList<SnippetHandle>();
        int index = 0;
        for (int i = 0; i < ranges.length; ++i) {
            SnippetWrapping shellWrapping;
            String text;
            Rng[] fragments;
            Rng curRange = ranges[i];
            int end = curRange.end;
            if (extendToEnd && i == ranges.length - 1) {
                end = snapshot.length();
                curRange = new Rng(curRange.start, end);
            }
            if (index < snips.size()) {
                SnippetHandle h = snips.get(index);
                fragments = h.getFragments();
                if (fragments[0].start == curRange.start) {
                    result.add(h);
                    ++index;
                    continue;
                }
            }
            try {
                text = section.getRangeContents(snapshot, curRange);
            }
            catch (StringIndexOutOfBoundsException ex) {
                ex.printStackTrace();
                return Collections.emptyList();
            }
            if (text == null || (shellWrapping = this.wrap(text)) == null) continue;
            TransientWrapping transWrapping = new TransientWrapping(shellWrapping, result);
            int so = section.offsetFromContents(curRange.start - section.getPartBegin());
            int eo = section.offsetFromContents(end - section.getPartBegin());
            fragments = section.computeFragments(new Rng(so, eo));
            result.add(ModelAccessor.INSTANCE.createHandle(this, section, fragments, transWrapping, true));
        }
        SnippetRegistry snippetRegistry2 = this;
        synchronized (snippetRegistry2) {
            List<SnippetHandle> check = this.sectionHandles.get(section);
            if (check == null || check == snips) {
                this.transientHandles.put(section, result);
            }
        }
        return result;
    }

    private String generateClassName() {
        int pad;
        int id = this.counter.incrementAndGet();
        StringBuilder sb = new StringBuilder();
        sb.append(JSHELL_TRANSIENT_SNIPPET_CLASS.substring(0, 8));
        String stringId = Integer.toString(id, 36);
        for (int i = pad = JSHELL_TRANSIENT_SNIPPET_CLASS.length() - (sb.length() + stringId.length()); i > 0; --i) {
            sb.append("_");
        }
        sb.append(stringId);
        return sb.toString();
    }

    public static class Key {
        private final String keyValue;

        private Key(String value) {
            this.keyValue = value;
        }

        public static Key create(Snippet snip) {
            switch (snip.kind()) {
                case IMPORT: {
                    ImportSnippet imp = (ImportSnippet)snip;
                    return new Key("I_" + imp.fullname() + (imp.isStatic() ? "*" : ""));
                }
                case TYPE_DECL: {
                    TypeDeclSnippet tdecl = (TypeDeclSnippet)snip;
                    return new Key("T_" + tdecl.name());
                }
                case METHOD: {
                    MethodSnippet method = (MethodSnippet)snip;
                    return new Key("M_" + method.name() + ":" + method.signature());
                }
                case VAR: {
                    VarSnippet var = (VarSnippet)snip;
                    return new Key("V_" + var.name() + ":" + var.typeName());
                }
                case EXPRESSION: {
                    ExpressionSnippet expr = (ExpressionSnippet)snip;
                    return new Key("E_" + expr.name() + ":" + expr.typeName());
                }
                case STATEMENT: 
                case ERRONEOUS: {
                    return new Key("C_" + snip.source());
                }
            }
            throw new AssertionError((Object)snip.kind().name());
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + Objects.hashCode(this.keyValue);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals(this.keyValue, other.keyValue);
        }

        public String toString() {
            return this.keyValue;
        }
    }

    public class TransientWrapping
    implements SnippetWrapping {
        private final SnippetWrapping original;
        private final List<SnippetHandle> precedings;
        private String cachedCode;
        private int importsLen;
        private String className;

        public TransientWrapping(SnippetWrapping original, List<SnippetHandle> precedings) {
            this.original = original;
            this.precedings = new ArrayList<SnippetHandle>(precedings);
            this.className = SnippetRegistry.this.generateClassName();
        }

        @Override
        public Snippet.Kind getSnippetKind() {
            return this.original.getSnippetKind();
        }

        @Override
        public Snippet.Status getStatus() {
            return this.original.getStatus();
        }

        @Override
        public Snippet getSnippet() {
            return this.original.getSnippet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getCode() {
            TransientWrapping transientWrapping = this;
            synchronized (transientWrapping) {
                if (this.cachedCode != null) {
                    return this.cachedCode;
                }
            }
            StringBuilder addImports = new StringBuilder();
            for (SnippetHandle h : this.precedings) {
                switch (h.getKind()) {
                    case IMPORT: {
                        addImports.append(h.getSource().trim());
                        break;
                    }
                }
            }
            TransientWrapping transientWrapping2 = this;
            synchronized (transientWrapping2) {
                String c = this.original.getCode();
                int indexOfClass = c.indexOf("class $JShell$DOESNOTMATTER");
                if (indexOfClass != -1) {
                    this.cachedCode = (c.substring(0, indexOfClass) + addImports.toString() + c.substring(indexOfClass)).replace(SnippetRegistry.JSHELL_TRANSIENT_SNIPPET_CLASS, this.className);
                    this.importsLen = addImports.length();
                } else {
                    this.cachedCode = c;
                }
            }
            return this.cachedCode;
        }

        @Override
        public String getSource() {
            return this.original.getSource();
        }

        @Override
        public int getWrappedPosition(int pos) {
            this.getCode();
            int orig = this.original.getWrappedPosition(pos);
            return orig + this.importsLen;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return "Transient(" + this.original + ")";
        }
    }

    class SWR
    extends WeakReference<SnippetHandle>
    implements Runnable {
        public SWR(SnippetHandle referent) {
            super(referent, BaseUtilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            SnippetRegistry.this.delete(this);
        }
    }
}

