/**
 * An HTMLCollection is a list of nodes. An individual node may be accessed by either ordinal index or the node's name or id attributes.Note: Collections in the HTML DOM are assumed to be live meaning that they are automatically updated when the underlying document is changed.
 */
var HTMLCollection = {
}
/**
 * This method retrieves a node specified by ordinal index. Nodes are numbered in tree order (depth-first traversal order).
 * @syntax hTMLCollection.item(index)
 * @param {Number} index The index of the node to be fetched. The index origin is 0.
 * @returns {Node} The Node at the corresponding position upon success. A value of null is returned if the index is out of range.
 */
HTMLCollection.prototype.item = function(index) {};

/**
 * This attribute specifies the length or size of the list.
 * @syntax hTMLCollection.length
 * @returns {Number} 
 */
HTMLCollection.prototype.length = new Number();

/**
 * This method retrieves a Node using a name. With [HTML 4.01] documents, it first searches for a Node with a matching id attribute. If it doesn't find one, it then searches for a Node with a matching name attribute, but only on those elements that are allowed a name attribute. With [XHTML 1.0] documents, this method only searches for Nodes with a matching id attribute. This method is case insensitive in HTML documents
 * @syntax hTMLCollection.namedItem(name)
 * @param {String} name The name of the Node to be fetched.
 * @returns {Node} The Node with a name or id attribute whose value corresponds to the specified string. Upon failure (e.g., no node with this name exists), returns null.
 */
HTMLCollection.prototype.namedItem = function(name) {};

/**
 * Represents the HTMLCollection prototype object.
 * @syntax HTMLCollection.prototype
 * @static
 */
HTMLCollection.prototype;

