/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ToolTipManager;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.BaseList;
import net.sourceforge.squirrel_sql.client.gui.db.DriverListCellRenderer;
import net.sourceforge.squirrel_sql.client.gui.db.DriversListModel;
import net.sourceforge.squirrel_sql.client.gui.db.IDriversList;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DriversList
extends BaseList
implements IDriversList {
    private static final String PREF_KEY_SELECTED_DRIVER_INDEX = "Squirrel.selDriverIndex";
    private IApplication _app;
    private DriversListModel _model;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DriversList.class);

    public DriversList(IApplication app) throws IllegalArgumentException {
        super(new DriversListModel(app), app);
        this._app = app;
        this._model = (DriversListModel)this.getList().getModel();
        this.getList().setLayout(new BorderLayout());
        SquirrelResources res = this._app.getResources();
        this.getList().setCellRenderer(new DriverListCellRenderer((Icon)res.getIcon("list.driver.found"), res.getIcon("list.driver.notfound")));
        this.propertiesChanged(null);
        this._app.getSquirrelPreferences().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt != null ? evt.getPropertyName() : null;
                DriversList.this.propertiesChanged(propName);
            }
        });
    }

    public void addNotify() {
        this.getList().addNotify();
        ToolTipManager.sharedInstance().registerComponent(this.getList());
    }

    public void removeNotify() {
        this.getList().removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this.getList());
    }

    public DriversListModel getTypedModel() {
        return this._model;
    }

    @Override
    public ISQLDriver getSelectedDriver() {
        return (ISQLDriver)this.getList().getSelectedValue();
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        String tip = null;
        int idx = this.getList().locationToIndex(evt.getPoint());
        tip = idx != -1 ? ((ISQLDriver)this.getList().getModel().getElementAt(idx)).getName() : this.getToolTipText();
        return tip;
    }

    public String getToolTipText() {
        return s_stringMgr.getString("DriversList.tooltiptext");
    }

    private void propertiesChanged(String propName) {
        if (propName == null || propName.equals("showLoadedDriversOnly")) {
            boolean show = this._app.getSquirrelPreferences().getShowLoadedDriversOnly();
            this._model.setShowLoadedDriversOnly(show);
        }
    }

    @Override
    public String getSelIndexPrefKey() {
        return PREF_KEY_SELECTED_DRIVER_INDEX;
    }

    public void requestFocus() {
        this.getList().requestFocus();
    }
}

