/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate;

import java.io.IOException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePlugin;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateConfiguration;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.IntraVmConnectionFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ServerMain;

public class HibernateConnectionFactory {
    private static ILogger s_log = LoggerController.createLogger(HibernateConnectionFactory.class);

    public static HibernateConnection createHibernateConnection(HibernateConfiguration cfg, HibernatePlugin plugin) throws Exception {
        if (cfg.isUseProcess()) {
            ServerMain serverMain = HibernateConnectionFactory.createProcessAndDoLookup(cfg, plugin);
            return new HibernateConnection(serverMain.createHibernateServerConnection(cfg), cfg.isUseProcess(), serverMain, cfg.isEndProcessOnDisconnect());
        }
        IntraVmConnectionFactory intraVmConnectionFactory = new IntraVmConnectionFactory();
        return new HibernateConnection(intraVmConnectionFactory.createHibernateConnection(cfg, false), false, null, cfg.isEndProcessOnDisconnect());
    }

    private static ServerMain createProcessAndDoLookup(HibernateConfiguration cfg, HibernatePlugin plugin) {
        try {
            ServerMain stub;
            IMessageHandler mh = plugin.getApplication().getMessageHandler();
            if (cfg.isEndProcessOnDisconnect()) {
                mh.showMessage("Launching Hibernate process ...");
                try {
                    HibernateConnectionFactory.launchProcess(cfg);
                }
                catch (Throwable e) {
                    s_log.error((Object)"Error launching process. Maybe port is in use. Tryin to connect and kill existing process:", e);
                    try {
                        stub = HibernateConnectionFactory.attachToProcess(cfg, mh, true);
                        if (null != stub) {
                            stub.exit();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    HibernateConnectionFactory.launchProcess(cfg);
                }
                stub = HibernateConnectionFactory.attachToProcess(cfg, mh, false);
            } else {
                stub = HibernateConnectionFactory.attachToProcess(cfg, mh, false);
                if (null == stub) {
                    mh.showMessage("Attaching to existing Hibernate process failed. Now will launch new process ...");
                    HibernateConnectionFactory.launchProcess(cfg);
                    stub = HibernateConnectionFactory.attachToProcess(cfg, mh, false);
                }
            }
            if (null == stub) {
                throw new IllegalStateException("Could not attach to Hibernate process");
            }
            mh.showMessage("Successfully attached to Hibernate process. Now creating Hibernate session.");
            return stub;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void launchProcess(HibernateConfiguration cfg) throws IOException {
        String command = cfg.getCommand().trim();
        Runtime.getRuntime().exec(HibernateConnectionFactory.toCommandArray(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServerMain attachToProcess(HibernateConfiguration cfg, IMessageHandler mh, boolean silent) {
        Object sync;
        ServerMain stub = null;
        Throwable reThrow = null;
        Object object = sync = new Object();
        synchronized (object) {
            for (int i = 0; i < 10; ++i) {
                try {
                    sync.wait(150L);
                    Registry registry = LocateRegistry.getRegistry("localhost", cfg.getProcessPort());
                    stub = (ServerMain)registry.lookup(ServerMain.class.getName());
                    break;
                }
                catch (Throwable t) {
                    reThrow = t;
                    continue;
                }
            }
        }
        if (!silent && null == stub) {
            mh.showErrorMessage("Failed to attach to Hibernate process: " + reThrow);
            s_log.debug((Object)("Failed to attach to Hibernate process: " + reThrow), reThrow);
        }
        return stub;
    }

    private static String[] toCommandArray(String cmd) {
        String arrItem;
        ArrayList<String> ret = new ArrayList<String>();
        boolean inQuotes = false;
        int startPos = 0;
        for (int i = 0; i < cmd.length(); ++i) {
            char c = cmd.charAt(i);
            if ('\"' == c) {
                boolean bl = inQuotes = !inQuotes;
            }
            if (inQuotes || !Character.isWhitespace(c)) continue;
            String arrItem2 = cmd.substring(startPos, i).trim();
            if (0 < arrItem2.length()) {
                ret.add(HibernateConnectionFactory.removeLeadingAndTrailingQuotes(arrItem2));
            }
            startPos = i;
        }
        if (startPos < cmd.length() - 1 && 0 < (arrItem = cmd.substring(startPos, cmd.length()).trim()).length()) {
            ret.add(HibernateConnectionFactory.removeLeadingAndTrailingQuotes(arrItem));
        }
        return ret.toArray(new String[ret.size()]);
    }

    private static String removeLeadingAndTrailingQuotes(String s) {
        String ret = s;
        if (ret.startsWith("\"")) {
            ret = ret.substring(1);
        }
        if (ret.endsWith("\"")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }
}

