/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class WebLookAndFeelUtils {
    private static final String LAF_CLASS_NAME = "com.alee.laf.WebLookAndFeel";
    private static final String BUTTON_UI_CLASS_NAME = "com.alee.laf.button.WebButtonUI";
    private static final String STYLE_CONSTANTS_CLASS = "com.alee.laf.StyleConstants";

    public static void fixToolbarButtons(JToolBar toolBar) {
        try {
            for (int i = 0; i < toolBar.getComponentCount(); ++i) {
                Component comp = toolBar.getComponent(i);
                System.out.println("--- " + comp);
                if (!(comp instanceof JButton)) continue;
                JButton button = (JButton)comp;
                WebLookAndFeelUtils.fixToolbarButtonImpl(button);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final void fixToolbarButtonImpl(JButton button) throws Exception {
        ButtonUI ui = button.getUI();
        if (ui.getClass().getName().equals(BUTTON_UI_CLASS_NAME)) {
            Class<?> clazz = ui.getClass();
            Class[] params = new Class[]{Boolean.TYPE};
            Method m = clazz.getDeclaredMethod("setRolloverDecoratedOnly", params);
            m.invoke((Object)ui, Boolean.TRUE);
            params = new Class[]{Integer.TYPE};
            m = clazz.getMethod("setRound", params);
            ClassLoader cl = clazz.getClassLoader();
            clazz = Class.forName(STYLE_CONSTANTS_CLASS, true, cl);
            Field smallRound = clazz.getField("smallRound");
            int value = smallRound.getInt(null);
            m.invoke((Object)ui, new Integer(value));
        }
    }

    public static final void installWebLookAndFeelProperties(ClassLoader cl) {
        String honorBorders = "WebLookAndFeel.honorUserBorders";
        System.setProperty(honorBorders, "true");
        try {
            Class<?> clazz = Class.forName(LAF_CLASS_NAME, true, cl);
            Class[] classes = new Class[]{Boolean.TYPE};
            Method m = clazz.getDeclaredMethod("setDecorateDialogs", classes);
            m.invoke(null, Boolean.TRUE);
            clazz = Class.forName(STYLE_CONSTANTS_CLASS, true, cl);
            Field topBGColor = clazz.getDeclaredField("topBgColor");
            Field bottomBGColor = clazz.getDeclaredField("bottomBgColor");
            topBGColor.set(null, new Color(0xFFEFEF));
            bottomBGColor.set(null, new Color(0xDFDFDF));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final boolean isWebLookAndFeel(String laf) {
        return laf.equals(LAF_CLASS_NAME);
    }

    public static final boolean isWebLookAndFeelInstalled() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        return WebLookAndFeelUtils.isWebLookAndFeel(laf.getClass().getName());
    }
}

