/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelationTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    private final ImageIcon icon = ImageProvider.get("data", "relation");

    public RelationTreeCellRenderer() {
        this.setOpaque(true);
    }

    protected void renderIcon() {
        this.setIcon(this.icon);
    }

    protected void renderValue(Relation relation) {
        this.setText(relation.getDisplayName(DefaultNameFormatter.getInstance()));
    }

    protected void renderBackground(boolean bl) {
        Color color = Color.WHITE;
        if (bl) {
            color = BGCOLOR_SELECTED;
        }
        this.setBackground(color);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (!jTree.isRootVisible() && jTree.getModel().getRoot() == object) {
            return this;
        }
        this.renderIcon();
        this.renderValue((Relation)object);
        this.renderBackground(bl);
        return this;
    }
}

