/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.handlers.http;

import org.apache.mina.proxy.ProxyAuthException;
import org.apache.mina.proxy.handlers.http.AbstractAuthLogicHandler;
import org.apache.mina.proxy.handlers.http.basic.HttpBasicAuthLogicHandler;
import org.apache.mina.proxy.handlers.http.basic.HttpNoAuthLogicHandler;
import org.apache.mina.proxy.handlers.http.digest.HttpDigestAuthLogicHandler;
import org.apache.mina.proxy.handlers.http.ntlm.HttpNTLMAuthLogicHandler;
import org.apache.mina.proxy.session.ProxyIoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpAuthenticationMethods
extends Enum<HttpAuthenticationMethods> {
    public static final /* enum */ HttpAuthenticationMethods NO_AUTH = new HttpAuthenticationMethods(1);
    public static final /* enum */ HttpAuthenticationMethods BASIC = new HttpAuthenticationMethods(2);
    public static final /* enum */ HttpAuthenticationMethods NTLM = new HttpAuthenticationMethods(3);
    public static final /* enum */ HttpAuthenticationMethods DIGEST = new HttpAuthenticationMethods(4);
    private final int id;
    private static final /* synthetic */ HttpAuthenticationMethods[] $VALUES;

    private HttpAuthenticationMethods(int n2) {
        this.id = n2;
    }

    public int getId() {
        return this.id;
    }

    public AbstractAuthLogicHandler getNewHandler(ProxyIoSession proxyIoSession) throws ProxyAuthException {
        return HttpAuthenticationMethods.getNewHandler(this.id, proxyIoSession);
    }

    public static AbstractAuthLogicHandler getNewHandler(int n, ProxyIoSession proxyIoSession) throws ProxyAuthException {
        if (n == HttpAuthenticationMethods.BASIC.id) {
            return new HttpBasicAuthLogicHandler(proxyIoSession);
        }
        if (n == HttpAuthenticationMethods.DIGEST.id) {
            return new HttpDigestAuthLogicHandler(proxyIoSession);
        }
        if (n == HttpAuthenticationMethods.NTLM.id) {
            return new HttpNTLMAuthLogicHandler(proxyIoSession);
        }
        if (n == HttpAuthenticationMethods.NO_AUTH.id) {
            return new HttpNoAuthLogicHandler(proxyIoSession);
        }
        return null;
    }

    static {
        $VALUES = new HttpAuthenticationMethods[]{NO_AUTH, BASIC, NTLM, DIGEST};
    }
}

