/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.handlers.http.basic;

import java.util.HashMap;
import java.util.List;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.proxy.ProxyAuthException;
import org.apache.mina.proxy.handlers.http.AbstractAuthLogicHandler;
import org.apache.mina.proxy.handlers.http.HttpProxyRequest;
import org.apache.mina.proxy.handlers.http.HttpProxyResponse;
import org.apache.mina.proxy.session.ProxyIoSession;
import org.apache.mina.proxy.utils.StringUtilities;
import org.apache.mina.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBasicAuthLogicHandler
extends AbstractAuthLogicHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpBasicAuthLogicHandler.class);

    public HttpBasicAuthLogicHandler(ProxyIoSession proxyIoSession) throws ProxyAuthException {
        super(proxyIoSession);
        ((HttpProxyRequest)this.request).checkRequiredProperties("USER", "PWD");
    }

    public void doHandshake(IoFilter.NextFilter nextFilter) throws ProxyAuthException {
        logger.debug(" doHandshake()");
        if (this.step > 0) {
            throw new ProxyAuthException("Authentication request already sent");
        }
        HttpProxyRequest httpProxyRequest = (HttpProxyRequest)this.request;
        HashMap<String, List<String>> hashMap = httpProxyRequest.getHeaders() != null ? httpProxyRequest.getHeaders() : new HashMap<String, List<String>>();
        String string = httpProxyRequest.getProperties().get("USER");
        String string2 = httpProxyRequest.getProperties().get("PWD");
        StringUtilities.addValueToHeader(hashMap, "Proxy-Authorization", "Basic " + HttpBasicAuthLogicHandler.createAuthorization(string, string2), true);
        HttpBasicAuthLogicHandler.addKeepAliveHeaders(hashMap);
        httpProxyRequest.setHeaders(hashMap);
        this.writeRequest(nextFilter, httpProxyRequest);
        ++this.step;
    }

    public static String createAuthorization(String string, String string2) {
        return new String(Base64.encodeBase64((string + ":" + string2).getBytes()));
    }

    public void handleResponse(HttpProxyResponse httpProxyResponse) throws ProxyAuthException {
        if (httpProxyResponse.getStatusCode() != 407) {
            throw new ProxyAuthException("Received error response code (" + httpProxyResponse.getStatusLine() + ").");
        }
    }
}

