/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.DelayedReadValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.FileTypeIconProvider;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.gui.dialogs.AppFrame;
import cz.vity.freerapid.gui.managers.FileHistoryItem;
import cz.vity.freerapid.gui.managers.FileHistoryManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.MenuManager;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.SwingXUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.binding.MyPreferencesAdapter;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.OSDesktop;
import cz.vity.freerapid.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.DefaultRowSorter;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class DownloadHistoryDialog
extends AppFrame
implements ClipboardOwner,
ListSelectionListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(DownloadHistoryDialog.class.getName());
    private static final String DATA_ADDED_PROPERTY = "dataAdded";
    private FileHistoryManager manager;
    private static final int COLUMN_DATE = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_DESCRIPTION = 2;
    private static final int COLUMN_SIZE = 3;
    private static final int COLUMN_URL = 4;
    private static final int COLUMN_CONNECTION = 5;
    private static final int COLUMN_AVG_SPEED = 6;
    private static final String SELECTED_ACTION_ENABLED_PROPERTY = "selectedEnabled";
    private boolean selectedEnabled;
    private static final String FILE_EXISTS_ENABLED_PROPERTY = "fileExistsEnabled";
    private boolean fileExistsEnabled;
    private final ManagerDirector director;
    private final String exampleSearchString;
    private JComboBox combobox;
    private JTextField fieldFilter;
    private JXTable table;
    private JButton clearHistoryBtn;
    private JButton okButton;

    public DownloadHistoryDialog(Frame owner, ManagerDirector director) throws HeadlessException {
        super(owner);
        this.director = director;
        this.manager = director.getFileHistoryManager();
        this.setName("DownloadHistoryDialog");
        this.exampleSearchString = this.getResourceMap().getString("exampleSearchString", new Object[0]);
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            this.doClose();
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.okButton;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.okButton;
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.setAction(this.okButton, "okBtnAction");
        this.setAction(this.clearHistoryBtn, "clearHistoryBtnAction");
        this.registerKeyboardAction("openFileAction");
        this.registerKeyboardAction("deleteFileAction");
        this.registerKeyboardAction("openDirectoryAction");
        this.registerKeyboardAction("openInBrowser");
        this.registerKeyboardAction("removeSelectedAction");
        this.registerKeyboardAction("copyContent");
        this.registerKeyboardAction("copyURL");
        this.updateActions();
        this.manager.addPropertyChangeListener(DATA_ADDED_PROPERTY, this);
        this.pack();
        DownloadHistoryDialog.locateOnOpticalScreenCenter(this);
    }

    private void initTable() {
        this.table.setName("historyTable");
        this.table.setModel(new CustomTableModel(new ArrayListModel<FileHistoryItem>(this.manager.getItems()), this.getList("columns", 7)));
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setEditable(false);
        this.table.setColumnControlVisible(true);
        this.table.setSortable(true);
        this.table.setColumnMargin(10);
        this.table.setRolloverEnabled(true);
        if (!AppPrefs.getProperty("historySlimLines", false)) {
            this.table.setRowHeight(36);
        }
        this.table.setShowGrid(true, false);
        this.table.setColumnSelectionAllowed(false);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.createDefaultColumnsFromModel();
        Swinger.updateColumn(this.table, "Date", 0, -1, 40, new DateCellRenderer(this.getResourceMap()));
        Swinger.updateColumn(this.table, "Name", 1, -1, 150, new FileNameCellRenderer(this.director.getFileTypeIconProvider()));
        Swinger.updateColumn(this.table, "Description", 2, -1, 170, new DescriptionCellRenderer());
        Swinger.updateColumn(this.table, "Size", 3, -1, 40, new SizeCellRenderer());
        Swinger.updateColumn(this.table, "URL", 4, -1, -1, SwingXUtils.getHyperLinkTableCellRenderer());
        TableColumnExt connection = (TableColumnExt)Swinger.updateColumn(this.table, "Connection", 5, -1, -1, new ConnectionCellRenderer());
        TableColumnExt avgSpeed = (TableColumnExt)Swinger.updateColumn(this.table, "AvgSpeed", 6, -1, -1, new AvgSpeedCellRenderer());
        avgSpeed.setVisible(false);
        connection.setVisible(false);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!DownloadHistoryDialog.this.table.hasFocus()) {
                    Swinger.inputFocus(DownloadHistoryDialog.this.table);
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    DownloadHistoryDialog.this.showPopMenu(e);
                } else if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() >= 2) {
                    DownloadHistoryDialog.this.openFileAction();
                }
            }
        });
        InputMap tableInputMap = this.table.getInputMap();
        ActionMap tableActionMap = this.table.getActionMap();
        ActionMap actionMap = this.getActionMap();
        tableInputMap.put(SwingUtils.getCtrlKeyStroke(67), "copy");
        tableActionMap.put("copy", actionMap.get("copyContent"));
        tableInputMap.put(SwingUtils.getShiftKeyStroke(127), "deleteFileAction");
        tableActionMap.put("deleteFileAction", actionMap.get("deleteFileAction"));
        tableInputMap.put(SwingUtils.getCtrlKeyStroke(10), "openDirectoryAction");
        tableActionMap.put("openDirectoryAction", actionMap.get("openDirectoryAction"));
        KeyStroke ctrlF = SwingUtils.getCtrlKeyStroke(70);
        tableInputMap.put(ctrlF, "getFocusFind");
        AbstractAction focusFilterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Swinger.inputFocus(DownloadHistoryDialog.this.fieldFilter);
            }
        };
        tableActionMap.put("getFocusFind", focusFilterAction);
        this.table.getParent().setPreferredSize(new Dimension(600, 400));
        tableInputMap.put(SwingUtils.getShiftKeyStroke(36), "selectFirstRowExtendSelection");
        tableInputMap.put(SwingUtils.getShiftKeyStroke(35), "selectLastRowExtendSelection");
        this.registerKeyboardAction(focusFilterAction, ctrlF);
    }

    @Action(enabledProperty="selectedEnabled")
    public void copyContent() {
        int[] rows = this.getSelectedRows();
        TableModel tableModel = this.table.getModel();
        int selCol = this.table.convertColumnIndexToModel(this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex());
        StringBuilder builder = new StringBuilder();
        for (int row : rows) {
            String value;
            if (selCol == 0) {
                Calendar instance = Calendar.getInstance();
                instance.setTimeInMillis((Long)tableModel.getValueAt(row, selCol));
                value = String.format("%1$tm %1$tB,%1$tY", instance);
            } else {
                value = tableModel.getValueAt(row, selCol).toString();
            }
            builder.append(value.replaceAll("%23", "#")).append('\n');
        }
        SwingUtils.copyToClipboard(builder.toString().trim(), this);
    }

    @Action
    public void copyURL() {
        List<FileHistoryItem> files = this.getSelectionToList(this.getSelectedRows());
        StringBuilder builder = new StringBuilder();
        for (FileHistoryItem file : files) {
            builder.append(file.getUrl().toExternalForm()).append('\n');
        }
        SwingUtils.copyToClipboard(builder.toString().trim(), this);
    }

    @Action(enabledProperty="fileExistsEnabled")
    public void openFileAction() {
        int[] indexes = this.getSelectedRows();
        List<FileHistoryItem> files = this.getSelectionToList(indexes);
        for (FileHistoryItem file : files) {
            OSDesktop.openFile(file.getOutputFile());
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void openInBrowser() {
        List<FileHistoryItem> files = this.getSelectionToList(this.getSelectedRows());
        for (FileHistoryItem file : files) {
            Browser.openBrowser(file.getUrl().toExternalForm().replaceAll("%23", "#"));
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void openDirectoryAction() {
        int[] indexes = this.getSelectedRows();
        List<FileHistoryItem> files = this.getSelectionToList(indexes);
        for (FileHistoryItem file : files) {
            OSDesktop.openDirectoryForFile(file.getOutputFile());
        }
    }

    @Action
    public void cancelBtnAction() {
        this.doClose();
    }

    @Override
    public void doClose() {
        this.manager.removePropertyChangeListener(DATA_ADDED_PROPERTY, this);
        if (AppPrefs.getProperty("containDownloadsFilter", this.exampleSearchString).equals(this.exampleSearchString)) {
            AppPrefs.storeProperty("containDownloadsFilter", "");
        }
        super.doClose();
    }

    private void buildGUI() {
        this.initTable();
        if ("Search...".equals(AppPrefs.getProperty("containDownloadsFilter", ""))) {
            AppPrefs.storeProperty("containDownloadsFilter", "");
        }
        if ("".equals(AppPrefs.getProperty("containDownloadsFilter", ""))) {
            AppPrefs.storeProperty("containDownloadsFilter", this.exampleSearchString);
        }
        MyPreferencesAdapter adapter = new MyPreferencesAdapter("containDownloadsFilter", "");
        DelayedReadValueModel delayedReadValueModel = new DelayedReadValueModel(adapter, 300, true);
        delayedReadValueModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DownloadHistoryDialog.this.updateFilters();
            }
        });
        this.fieldFilter.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (DownloadHistoryDialog.this.exampleSearchString.equals(DownloadHistoryDialog.this.fieldFilter.getText())) {
                    DownloadHistoryDialog.this.fieldFilter.setForeground(Color.BLACK);
                    DownloadHistoryDialog.this.fieldFilter.setText("");
                } else {
                    DownloadHistoryDialog.this.fieldFilter.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (DownloadHistoryDialog.this.fieldFilter.getText().isEmpty()) {
                    DownloadHistoryDialog.this.fieldFilter.setForeground(Color.GRAY);
                    DownloadHistoryDialog.this.fieldFilter.setText(DownloadHistoryDialog.this.exampleSearchString);
                }
            }
        });
        this.fieldFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (27 == keyCode) {
                    if (!"".equals(DownloadHistoryDialog.this.fieldFilter.getText())) {
                        DownloadHistoryDialog.this.fieldFilter.setText("");
                        e.consume();
                    }
                } else if (10 == keyCode || 40 == keyCode) {
                    if (DownloadHistoryDialog.this.getSelectedRows().length == 0 && DownloadHistoryDialog.this.table.getRowCount() > 0) {
                        DownloadHistoryDialog.this.table.setRowSelectionInterval(0, 0);
                    }
                    Swinger.inputFocus(DownloadHistoryDialog.this.table);
                    e.consume();
                }
            }
        });
        Bindings.bind(this.fieldFilter, (ValueModel)delayedReadValueModel);
        this.bindCombobox(this.combobox, "selectedDownloadsFilter", DownloadsFilters.ALL_DOWNLOADS.ordinal(), "datesFilter", 6);
        this.combobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadHistoryDialog.this.updateFilters();
            }
        });
        if (!this.exampleSearchString.equals(this.fieldFilter.getText())) {
            this.fieldFilter.setForeground(Color.BLACK);
        } else {
            this.fieldFilter.setForeground(Color.GRAY);
        }
        this.updateFilters();
        Swinger.inputFocus(this.table);
    }

    @Action
    public void okBtnAction() {
        this.doClose();
    }

    private int[] getSelectedRows() {
        return Swinger.getSelectedRows(this.table);
    }

    private void bindCombobox(JComboBox combobox, String key, Object defaultValue, String resourceKey, int valueCount) {
        String[] stringList = this.getList(resourceKey, valueCount);
        this.bindCombobox(combobox, key, defaultValue, stringList);
    }

    private void bindCombobox(JComboBox combobox, String key, Object defaultValue, String[] values) {
        if (values == null) {
            throw new IllegalArgumentException("List of combobox values cannot be null!!");
        }
        MyPreferencesAdapter adapter = new MyPreferencesAdapter(key, defaultValue);
        SelectionInList<String> inList = new SelectionInList<String>(values, (ValueModel)new ValueHolder(values[(Integer)adapter.getValue()]), (ValueModel)adapter);
        Bindings.bind(combobox, inList);
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        JPanel panel1 = new JPanel();
        this.combobox = new JComboBox();
        JLabel labelFilter = new JLabel();
        this.fieldFilter = new JTextField();
        JScrollPane scrollPane2 = new JScrollPane();
        this.table = new JXTable();
        JXButtonPanel buttonBar = new JXButtonPanel();
        this.clearHistoryBtn = new JButton();
        this.okButton = new JButton();
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(Borders.DIALOG);
        dialogPane.setLayout(new BorderLayout());
        panel1.setBorder(new TitledBorder(""));
        labelFilter.setName("labelFilter");
        labelFilter.setLabelFor(this.fieldFilter);
        PanelBuilder panel1Builder = new PanelBuilder(new FormLayout(new ColumnSpec[]{ColumnSpec.decode("max(pref;80dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(100)), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0)}, RowSpec.decodeSpecs("default")), panel1);
        panel1Builder.add((Component)this.combobox, cc.xy(1, 1));
        panel1Builder.add((Component)labelFilter, cc.xy(3, 1));
        panel1Builder.add((Component)this.fieldFilter, cc.xy(5, 1));
        scrollPane2.setViewportView(this.table);
        PanelBuilder contentPanelBuilder = new PanelBuilder(new FormLayout(ColumnSpec.decodeSpecs("default:grow"), new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 1.0)}), contentPanel);
        contentPanelBuilder.add((Component)panel1, cc.xy(1, 1));
        contentPanelBuilder.add((Component)scrollPane2, cc.xy(1, 3));
        dialogPane.add((Component)contentPanel, "Center");
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.clearHistoryBtn.setName("clearHistoryBtn");
        this.okButton.setName("okButton");
        PanelBuilder buttonBarBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.UNRELATED_GAP_COLSPEC, ColumnSpec.decode("max(pref;55dlu)")}, RowSpec.decodeSpecs("fill:pref")), buttonBar);
        buttonBarBuilder.add((Component)this.clearHistoryBtn, cc.xy(1, 1));
        buttonBarBuilder.add((Component)this.okButton, cc.xy(5, 1));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.updateActions();
    }

    private void updateActions() {
        int[] indexes = this.getSelectedRows();
        this.setSelectedEnabled(indexes.length > 0);
        boolean valid = true;
        List<FileHistoryItem> items = this.getSelectionToList(indexes);
        for (FileHistoryItem item : items) {
            if (item.getOutputFile().exists()) continue;
            valid = false;
            break;
        }
        this.setFileExistsEnabled(valid);
    }

    public boolean isSelectedEnabled() {
        return this.selectedEnabled;
    }

    public void setSelectedEnabled(boolean selectedEnabled) {
        boolean oldValue = this.selectedEnabled;
        this.selectedEnabled = selectedEnabled;
        this.firePropertyChange(SELECTED_ACTION_ENABLED_PROPERTY, oldValue, selectedEnabled);
    }

    public boolean isFileExistsEnabled() {
        return this.fileExistsEnabled;
    }

    public void setFileExistsEnabled(boolean fileExistsEnabled) {
        boolean oldValue = this.fileExistsEnabled;
        this.fileExistsEnabled = fileExistsEnabled;
        this.firePropertyChange(FILE_EXISTS_ENABLED_PROPERTY, oldValue, fileExistsEnabled);
    }

    @Action(enabledProperty="selectedEnabled")
    public void deleteFileAction() {
        int result;
        boolean showedDialog;
        int[] indexes = this.getSelectedRows();
        List<FileHistoryItem> files = this.getSelectionToList(indexes);
        String s = this.getFileList(files);
        boolean confirm = AppPrefs.getProperty("confirmFileDelete", true);
        if (s.isEmpty() || !confirm) {
            showedDialog = false;
            result = 0;
        } else {
            showedDialog = true;
            result = Swinger.getChoiceOKCancel("message.areyousuredelete", s);
        }
        if (result == 0) {
            for (FileHistoryItem file : files) {
                File outputFile = file.getOutputFile();
                if (outputFile == null) continue;
                FileUtils.deleteFileWithRecycleBin(outputFile);
            }
            this.removeSelected(indexes, showedDialog);
            this.selectFirstIfNoSelection();
        }
    }

    private String getFileList(List<FileHistoryItem> files) {
        ArrayList<FileHistoryItem> existingFiles = new ArrayList<FileHistoryItem>();
        for (FileHistoryItem file : files) {
            if (file.getOutputFile() == null || !file.getOutputFile().exists()) continue;
            existingFiles.add(file);
        }
        StringBuilder builder = new StringBuilder();
        int n = Math.min(existingFiles.size(), 20);
        for (int i = 0; i < n; ++i) {
            builder.append('\n').append(Utils.shortenFileName(((FileHistoryItem)existingFiles.get(i)).getOutputFile()));
        }
        if (existingFiles.size() > 20) {
            builder.append('\n').append(this.getResourceMap().getString("andOtherFiles", existingFiles.size() - 20));
        }
        return builder.toString();
    }

    private void removeSelected(int[] indexes, boolean quiet) {
        int result;
        boolean confirmRemove;
        if (!quiet && (confirmRemove = AppPrefs.getProperty("confirmRemove", true)) && (result = Swinger.getChoiceOKCancel("areYouSureYouWantToRemove", new Object[0])) != 0) {
            return;
        }
        final ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        this.removeSelected(indexes);
        selectionModel.setValueIsAdjusting(false);
        final int min = this.getArrayMin(indexes);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int count = DownloadHistoryDialog.this.table.getRowCount();
                if (DownloadHistoryDialog.this.table.getRowCount() > 0) {
                    int index = Math.min(count - 1, min);
                    index = DownloadHistoryDialog.this.table.convertRowIndexToView(index);
                    selectionModel.addSelectionInterval(index, index);
                    DownloadHistoryDialog.this.scrollToVisible(true);
                }
            }
        });
    }

    public List<FileHistoryItem> getSelectionToList(int[] selectedRows) {
        return this.selectionToList(selectedRows);
    }

    private List<FileHistoryItem> selectionToList(int[] indexes) {
        ArrayList<FileHistoryItem> list = new ArrayList<FileHistoryItem>();
        ArrayListModel<FileHistoryItem> items = this.getItems();
        for (int index : indexes) {
            list.add((FileHistoryItem)items.get(index));
        }
        return list;
    }

    private ArrayListModel<FileHistoryItem> getItems() {
        return ((CustomTableModel)this.table.getModel()).model;
    }

    public void removeSelected(int[] indexes) {
        ArrayListModel<FileHistoryItem> items = this.getItems();
        List<FileHistoryItem> toRemoveList = this.getSelectionToList(indexes);
        this.manager.removeItems(toRemoveList);
        items.removeAll(toRemoveList);
    }

    private void scrollToVisible(boolean up) {
        int[] rows = this.table.getSelectedRows();
        int length = rows.length;
        if (length > 0) {
            this.table.scrollRowToVisible(up ? rows[0] : rows[length - 1]);
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void removeSelectedAction() {
        int[] indexes = this.getSelectedRows();
        this.removeSelected(indexes, false);
    }

    private void selectFirstIfNoSelection() {
        int[] rows = this.getSelectedRows();
        if (rows.length == 0 && this.getVisibleRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private int getVisibleRowCount() {
        return this.table.getRowSorter().getViewRowCount();
    }

    private int getArrayMin(int[] indexes) {
        int min = Integer.MAX_VALUE;
        for (int i : indexes) {
            if (min <= i) continue;
            min = i;
        }
        return min;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        CustomTableModel model = (CustomTableModel)this.table.getModel();
        model.model.add((FileHistoryItem)evt.getNewValue());
    }

    private void showPopMenu(MouseEvent e) {
        int[] selectedRows = this.getSelectedRows();
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        int rowNumber = this.table.rowAtPoint(e.getPoint());
        if (rowNumber != -1) {
            if (selectedRows.length <= 0) {
                if (this.getVisibleRowCount() > 0) {
                    selectionModel.setSelectionInterval(rowNumber, rowNumber);
                }
            } else {
                Arrays.sort(selectedRows);
                if (Arrays.binarySearch(selectedRows, this.table.convertRowIndexToModel(rowNumber)) < 0) {
                    selectionModel.setValueIsAdjusting(true);
                    this.table.clearSelection();
                    selectionModel.setSelectionInterval(rowNumber, rowNumber);
                    selectionModel.setValueIsAdjusting(false);
                }
            }
        } else {
            this.table.clearSelection();
        }
        MenuManager menuManager = this.director.getMenuManager();
        JPopupMenu popup = new JPopupMenu();
        Object[] objects = new Object[]{"openFileAction", "deleteFileAction", "openDirectoryAction", "---", "copyContent", "---", "copyURL", "openInBrowser", "---", "removeSelectedAction"};
        menuManager.processMenu(popup, "popup", this.getActionMap(), objects);
        SwingUtils.showPopMenu(popup, e, this.table, this);
    }

    @Action
    public void clearHistoryBtnAction() {
        if (Swinger.getChoiceYesNo(this.getApp().getContext().getResourceMap().getString("confirmClearHistory", new Object[0])) == 0) {
            final ListSelectionModel selectionModel = this.table.getSelectionModel();
            this.manager.clearHistory(new Runnable(){

                @Override
                public void run() {
                    selectionModel.setValueIsAdjusting(true);
                    DownloadHistoryDialog.this.getItems().clear();
                    selectionModel.setValueIsAdjusting(false);
                }
            });
        }
    }

    private void updateFilters() {
        String filterText = this.fieldFilter.getText();
        if (this.exampleSearchString.equals(filterText)) {
            filterText = "";
        }
        int selectedIndex = this.combobox.getSelectedIndex();
        RowFilter rowFilter = null;
        DownloadsFilters filter = selectedIndex == -1 ? DownloadsFilters.ALL_DOWNLOADS : DownloadsFilters.values()[selectedIndex];
        if (filter != DownloadsFilters.ALL_DOWNLOADS) {
            rowFilter = new DateTimeFilter(filter);
        }
        if (!filterText.isEmpty()) {
            RowFilter textFilter = RowFilter.regexFilter("(?i)" + Pattern.quote(filterText), new int[0]);
            if (rowFilter != null) {
                ArrayList list = new ArrayList(2);
                list.add(rowFilter);
                list.add(textFilter);
                rowFilter = RowFilter.andFilter(list);
            } else {
                rowFilter = textFilter;
            }
        }
        ((DefaultRowSorter)this.table.getRowSorter()).setRowFilter(rowFilter);
    }

    private static enum DownloadsFilters {
        ALL_DOWNLOADS,
        TODAY,
        YESTERDAY,
        LAST_WEEK,
        LAST_MONTH,
        THIS_CALENDAR_MONTH;

    }

    private static class AvgSpeedCellRenderer
    extends DefaultTableCellRenderer {
        private AvgSpeedCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FileHistoryItem item = (FileHistoryItem)table.getValueAt(row, -1);
            float averageSpeed = item.getAverageSpeed();
            if (averageSpeed <= 0.0f) {
                value = "";
                this.setToolTipText(null);
            } else {
                value = ContentPanel.bytesToAnother((long)averageSpeed) + "/s";
                this.setToolTipText(value.toString());
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class ConnectionCellRenderer
    extends DefaultTableCellRenderer {
        private ConnectionCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FileHistoryItem item = (FileHistoryItem)table.getValueAt(row, -1);
            String connection = item.getConnection();
            if (connection == null) {
                value = "";
                this.setToolTipText(null);
            } else {
                value = connection;
                this.setToolTipText(connection);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class SizeCellRenderer
    extends DefaultTableCellRenderer {
        private SizeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FileHistoryItem item = (FileHistoryItem)table.getValueAt(row, -1);
            long fs = item.getFileSize();
            if (fs == -1L) {
                value = "";
                this.setToolTipText(null);
            } else {
                value = ContentPanel.bytesToAnother(fs);
                this.setToolTipText(NumberFormat.getIntegerInstance().format(fs) + " B");
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class DescriptionCellRenderer
    extends DefaultTableCellRenderer {
        private String tooltip = Swinger.getResourceMap().getString("tooltip", new Object[0]);

        private DescriptionCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = table.getValueAt(row, column);
            }
            if (value != null) {
                if (!((String)value).isEmpty()) {
                    this.setToolTipText(String.format(this.tooltip, value));
                    value = "<html>" + value + "</html>";
                } else {
                    this.setToolTipText(null);
                }
            } else {
                this.setToolTipText(null);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class FileNameCellRenderer
    extends DefaultTableCellRenderer {
        private final FileTypeIconProvider iconProvider;
        private final boolean bigIcon;

        public FileNameCellRenderer(FileTypeIconProvider iconProvider) {
            this.iconProvider = iconProvider;
            this.bigIcon = !AppPrefs.getProperty("historySlimLines", false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FileHistoryItem fileHistoryItem = (FileHistoryItem)table.getValueAt(row, -1);
            String fn = (String)value;
            String url = fileHistoryItem.getUrl().toExternalForm();
            value = fn != null && !fn.isEmpty() ? String.format("<html><b>%s</b></html>", fn) : url;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                this.setToolTipText(url);
                this.setIconTextGap(6);
                this.setIcon(this.iconProvider.getIconImageByFileType(fileHistoryItem.getFileType(), this.bigIcon));
            }
            return this;
        }
    }

    private static class DateCellRenderer
    extends DefaultTableCellRenderer {
        private String yesterday;

        private DateCellRenderer(ResourceMap map) {
            this.yesterday = map.getString("yesterday", new Object[0]);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = table.getValueAt(row, column);
            }
            value = this.millisToString((Long)value);
            this.setHorizontalAlignment(0);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        private String millisToString(long value) {
            Calendar valueDate = Calendar.getInstance();
            valueDate.setTimeInMillis(value);
            Calendar today = Calendar.getInstance();
            today.set(11, 0);
            today.set(12, 0);
            today.set(13, 1);
            if (valueDate.after(today)) {
                return String.format("%tH:%tM", value, value);
            }
            today.add(5, -1);
            if (valueDate.after(today)) {
                return this.yesterday;
            }
            today.add(5, -6);
            if (valueDate.after(today)) {
                return String.format("%tA", value);
            }
            return String.format("%1$tB %1$te", value);
        }
    }

    private static class DateTimeFilter
    extends RowFilter<Object, Object> {
        private final DownloadsFilters filter;

        private DateTimeFilter(DownloadsFilters filter) {
            this.filter = filter;
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            Long value = (Long)entry.getValue(0);
            if (value == null) {
                return false;
            }
            if (this.filter == DownloadsFilters.ALL_DOWNLOADS) {
                return true;
            }
            Calendar today = Calendar.getInstance();
            today.set(11, 0);
            today.set(12, 0);
            today.set(13, 1);
            Calendar valueDate = Calendar.getInstance();
            valueDate.setTimeInMillis(value);
            switch (this.filter) {
                case TODAY: {
                    if (!valueDate.after(today)) break;
                    return true;
                }
                case YESTERDAY: {
                    Calendar yesterday = Calendar.getInstance();
                    yesterday.add(5, -1);
                    yesterday.set(11, 0);
                    yesterday.set(12, 0);
                    yesterday.set(13, 1);
                    if (!valueDate.after(yesterday) || !valueDate.before(today)) break;
                    return true;
                }
                case LAST_WEEK: {
                    Calendar last7Days = Calendar.getInstance();
                    last7Days.set(11, 0);
                    last7Days.set(12, 0);
                    last7Days.set(13, 1);
                    last7Days.add(5, -7);
                    if (!valueDate.after(last7Days)) break;
                    return true;
                }
                case LAST_MONTH: {
                    Calendar last31Days = Calendar.getInstance();
                    last31Days.set(11, 0);
                    last31Days.set(12, 0);
                    last31Days.set(13, 1);
                    last31Days.add(5, -31);
                    if (!valueDate.after(last31Days)) break;
                    return true;
                }
                case THIS_CALENDAR_MONTH: {
                    today.set(5, 1);
                    today.set(11, 0);
                    today.set(12, 0);
                    today.set(13, 1);
                    if (!valueDate.after(today)) break;
                    return true;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return false;
        }
    }

    private static class CustomTableModel
    extends AbstractTableModel
    implements ListDataListener {
        private final ArrayListModel<FileHistoryItem> model;
        private final String[] columns;

        public CustomTableModel(ArrayListModel<FileHistoryItem> model, String[] columns) {
            this.model = model;
            this.columns = columns;
            model.addListDataListener(this);
        }

        @Override
        public int getRowCount() {
            return this.model.getSize();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column];
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FileHistoryItem fileHistoryItem = (FileHistoryItem)this.model.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return fileHistoryItem.getFinishedTime();
                }
                case 1: {
                    return fileHistoryItem.getFileName();
                }
                case 2: {
                    return fileHistoryItem.getDescription();
                }
                case 3: {
                    return fileHistoryItem.getFileSize();
                }
                case 4: {
                    return SwingXUtils.createLink(fileHistoryItem.getUrl());
                }
                case -1: {
                    return fileHistoryItem;
                }
            }
            assert (false);
            return fileHistoryItem;
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.fireTableRowsUpdated(e.getIndex0(), e.getIndex1());
        }
    }
}

