/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.userprefs;

import com.jgoodies.binding.beans.BeanAdapter;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.dialogs.userprefs.PluginDetailPanel;
import cz.vity.freerapid.gui.dialogs.userprefs.PluginMetaDataTableModel;
import cz.vity.freerapid.gui.dialogs.userprefs.UserPreferencesDialog;
import cz.vity.freerapid.gui.dialogs.userprefs.UserPreferencesTab;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.MenuManager;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.SwingXUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.components.FindTableAction;
import cz.vity.freerapid.swing.components.PopdownButton;
import cz.vity.freerapid.swing.models.SimplePreferencesComboModel;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.DefaultRowSorter;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.application.Action;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class PluginsTab
extends UserPreferencesTab
implements ClipboardOwner {
    private static final Logger logger = Logger.getLogger(PluginsTab.class.getName());
    private static final int MINIMUM_PRIORITY = 1;
    private static final int MAXIMUM_PRIORITY = 10000;
    private static final int MIN_FIRST_PLUGIN_COLUMN_WIDTH = 26;
    private static final String PLUGIN_OPTIONS_ENABLED_PROPERTY = "pluginOptionsEnabled";
    private boolean pluginOptionsEnabled;
    private boolean pluginTableWasChanged = false;
    private final ManagerDirector managerDirector;
    private JTabbedPane pluginTabbedPane;
    private PluginDetailPanel pluginDetailPanel;
    private JXTable pluginTable;
    private JButton btnPluginOptions;
    private PopdownButton popmenuButton;
    private JCheckBox check4PluginUpdatesAutomatically;
    private JComboBox comboHowToUpdate;
    private JCheckBox checkDownloadNotExistingPlugins;
    private JSpinner spinnerUpdateHour;
    private JComboBox comboPluginServers;
    private JButton btnResetDefaultPluginServer;

    PluginsTab(UserPreferencesDialog dialog, ManagerDirector managerDirector) {
        super(dialog);
        this.managerDirector = managerDirector;
        this.setPluginOptionsEnabled(false);
    }

    @Override
    public void init() {
        this.buildPopmenuButton(this.popmenuButton.getPopupMenu());
        ArrayListModel<PluginMetaData> plugins = new ArrayListModel<PluginMetaData>(this.managerDirector.getPluginsManager().getSupportedPlugins());
        this.pluginTable.setModel(new PluginMetaDataTableModel(plugins, this.dialog.getList("pluginTableColumns", 10)));
        if (!plugins.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginsTab.this.pluginTable.getSelectionModel().setSelectionInterval(0, 0);
                }
            });
        }
        this.bind(this.spinnerUpdateHour, "pluginUpdateCheckInterval", 24, 1, 1000, 1);
        this.bind(this.check4PluginUpdatesAutomatically, "check4PluginUpdatesAutomatically", (Object)true);
        this.bind(this.checkDownloadNotExistingPlugins, "downloadNotExistingPlugins", (Object)true);
        this.bindCombobox(this.comboHowToUpdate, "pluginUpdateMethod", 0, "comboHowToUpdate", 4);
        this.comboHowToUpdate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PluginsTab.this.dialog.getModel().setBuffering(true);
            }
        });
        final SimplePreferencesComboModel listComboModel = new SimplePreferencesComboModel(10, "pluginCheckUrlList", false);
        this.comboPluginServers.setModel(listComboModel);
        this.comboPluginServers.setSelectedItem(AppPrefs.getProperty("pluginCheckUrlSelected", "http://wordrider.net/freerapid/pluginsCheck.php"));
        final JTextField field = (JTextField)this.comboPluginServers.getEditor().getEditorComponent();
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PluginsTab.this.dialog.getModel().setBuffering(true);
            }
        });
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                String s = field.getText();
                if (s != null && !s.trim().isEmpty()) {
                    listComboModel.addElement(s);
                }
            }
        });
        this.setAction(this.btnPluginOptions, "btnPluginOptionsAction");
        this.setAction(this.btnResetDefaultPluginServer, "btnResetDefaultPluginServerAction");
        this.initPluginTable();
    }

    private void buildPopmenuButton(JPopupMenu popupMenu) {
        MenuManager menuManager = this.managerDirector.getMenuManager();
        JMenu updatesMenu = menuManager.createMenu("updatesMenu", this.actionMap, "selectAllUpdatesAction", "deSelectAllUpdatesAction");
        this.resourceMap.injectComponent(updatesMenu);
        JMenu activityMenu = menuManager.createMenu("activityMenu", this.actionMap, "selectAllActivityAction", "deSelectAllActivityAction");
        this.resourceMap.injectComponent(activityMenu);
        JMenu cmMenu = menuManager.createMenu("clipboardMonitoringMenu", this.actionMap, "selectAllCMAction", "deSelectAllCMAction");
        this.resourceMap.injectComponent(cmMenu);
        Object[] objects = new Object[]{"copyPluginListAction", "copyPluginListWithVersionAction", "copySupportedSitesListAction", "---", activityMenu, updatesMenu, cmMenu};
        menuManager.processMenu(popupMenu, "", this.actionMap, objects);
    }

    private void initPluginTable() {
        this.pluginTable.setName("pluginTable");
        this.pluginTable.setAutoCreateColumnsFromModel(false);
        this.pluginTable.setColumnControlVisible(true);
        this.pluginTable.setHorizontalScrollEnabled(true);
        this.pluginTable.setSortable(true);
        this.pluginTable.setSortsOnUpdates(true);
        this.pluginTable.setUpdateSelectionOnSort(true);
        this.pluginTable.setColumnMargin(10);
        this.pluginTable.setRolloverEnabled(true);
        this.pluginTable.setShowGrid(true, true);
        this.pluginTable.setEditable(true);
        ColorHighlighter first = new ColorHighlighter(new HighlightPredicate(){

            @Override
            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                return Boolean.FALSE.equals(adapter.getValue(0));
            }
        }, HighlighterFactory.GENERIC_GRAY, Color.BLACK);
        this.pluginTable.addHighlighter(first);
        this.pluginTable.setColumnSelectionAllowed(false);
        this.pluginTable.createDefaultColumnsFromModel();
        TableModel tableModel = this.pluginTable.getModel();
        final PluginMetaDataTableModel customTableModel = (PluginMetaDataTableModel)tableModel;
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                PluginsTab.this.dialog.getModel().setBuffering(true);
                if (e.getType() == 0) {
                    PluginsTab.this.pluginTableWasChanged = true;
                    if (e.getColumn() == 0) {
                        PluginMetaData data = customTableModel.getObject(e.getFirstRow());
                        PluginsTab.this.updatePremium(data);
                    }
                }
            }
        });
        final ListSelectionModel selectionModel = this.pluginTable.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int index = e.getLastIndex();
                if (index != -1) {
                    PluginsTab.this.pluginDetailPanel.setVisible(true);
                    PluginMetaData data = customTableModel.getObject(PluginsTab.this.pluginTable.convertRowIndexToModel(selectionModel.getMinSelectionIndex()));
                    BeanAdapter<PluginMetaData> beanModel = new BeanAdapter<PluginMetaData>(data, true);
                    beanModel.addBeanPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            int row = PluginsTab.this.pluginTable.convertRowIndexToModel(selectionModel.getMinSelectionIndex());
                            ((PluginMetaDataTableModel)PluginsTab.this.pluginTable.getModel()).fireTableRowsUpdated(row, row);
                        }
                    });
                    PluginsTab.this.bind(PluginsTab.this.pluginDetailPanel.getSpinnerPluginPriority(), 1, 1, 10000, 1, beanModel.getValueModel("pluginPriority"));
                    int max = data.getMaxParallelDownloads();
                    PluginsTab.this.bind(PluginsTab.this.pluginDetailPanel.getSpinnerMaxPluginConnections(), 1, 1, max, 1, beanModel.getValueModel("maxAllowedDownloads"));
                    PluginsTab.this.pluginDetailPanel.getSpinnerMaxPluginConnections().setEnabled(max > 1);
                    PluginsTab.this.bind(PluginsTab.this.pluginDetailPanel.getCheckboxClipboardMonitoring(), beanModel.getValueModel("clipboardMonitored"));
                    PluginsTab.this.bind(PluginsTab.this.pluginDetailPanel.getCheckboxPluginIsActive(), beanModel.getValueModel("enabled"));
                    PluginsTab.this.bind(PluginsTab.this.pluginDetailPanel.getCheckboxUpdatePlugins(), beanModel.getValueModel("updatesEnabled"));
                    PluginsTab.this.pluginDetailPanel.getAuthorLabel().setText(data.getVendor());
                    PluginsTab.this.pluginDetailPanel.getAuthorLabel().setToolTipText(data.getVendor());
                    PluginsTab.this.pluginDetailPanel.getVersionLabel().setText(data.getVersion());
                    PluginsTab.this.pluginDetailPanel.getServicesLabel().setText(data.getServices());
                    PluginsTab.this.pluginDetailPanel.getServicesLabel().setToolTipText(data.getServices());
                    PluginsTab.this.pluginDetailPanel.getTitleSeparator().setTitle(data.getId());
                    PluginsTab.this.setPluginOptionsEnabled(data.isOptionable());
                } else {
                    PluginsTab.this.setPluginOptionsEnabled(false);
                    PluginsTab.this.pluginDetailPanel.setVisible(false);
                }
            }
        });
        this.pluginDetailPanel.setVisible(false);
        this.pluginTable.setSortOrder(3, SortOrder.ASCENDING);
        this.pluginTable.setTerminateEditOnFocusLost(true);
        this.pluginTable.setAutoStartEditOnKeyStroke(true);
        TableColumn tableColumn = Swinger.updateColumn(this.pluginTable, "X", 0, 26, 26, null);
        tableColumn.setWidth(26);
        tableColumn.setMaxWidth(26);
        tableColumn = Swinger.updateColumn(this.pluginTable, "U", 1, 26, 26, null);
        tableColumn.setWidth(26);
        tableColumn.setMaxWidth(26);
        tableColumn = Swinger.updateColumn(this.pluginTable, "C", 2, 26, 26, null);
        tableColumn.setWidth(26);
        tableColumn.setMaxWidth(26);
        this.pluginTable.setRolloverEnabled(true);
        Swinger.updateColumn(this.pluginTable, "ID", 3, -1, 70, null);
        Swinger.updateColumn(this.pluginTable, "Version", 4, -1, 40, null);
        Swinger.updateColumn(this.pluginTable, "Services", 5, -1, 100, null);
        Swinger.updateColumn(this.pluginTable, "Author", 6, -1, -1, null);
        Swinger.updateColumn(this.pluginTable, "MaxDownloads", 7, -1, -1, new PluginConnectionAllowedRenderer());
        Swinger.updateColumn(this.pluginTable, "Priority", 8, -1, -1, null);
        Swinger.updateColumn(this.pluginTable, "WWW", 9, -1, -1, SwingXUtils.getHyperLinkTableCellRenderer());
        TableColumnModel tableColumnModel = this.pluginTable.getColumnModel();
        SpinnerEditor spinnerEditor = new SpinnerEditor();
        tableColumnModel.getColumn(7).setCellEditor(spinnerEditor);
        tableColumnModel.getColumn(8).setCellEditor(spinnerEditor);
        this.pluginTable.getColumnExt(9).setVisible(false);
        this.pluginTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!PluginsTab.this.pluginTable.hasFocus()) {
                    Swinger.inputFocus(PluginsTab.this.pluginTable);
                }
                if (e.getClickCount() >= 2 && SwingUtilities.isLeftMouseButton(e)) {
                    PluginsTab.this.btnPluginOptionsAction();
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    SwingUtils.showPopMenu(PluginsTab.this.popmenuButton.getPopupMenu(), e, PluginsTab.this.pluginTable, PluginsTab.this.dialog);
                }
            }
        });
        InputMap tableInputMap = this.pluginTable.getInputMap();
        ActionMap tableActionMap = this.pluginTable.getActionMap();
        tableInputMap.put(SwingUtils.getCtrlKeyStroke(67), "copy");
        tableActionMap.put("copy", this.actionMap.get("copyContent"));
        KeyStroke ctrlF = SwingUtils.getCtrlKeyStroke(70);
        tableInputMap.remove(ctrlF);
        this.pluginTable.getParent().setPreferredSize(new Dimension(230, 100));
        tableInputMap.put(SwingUtils.getShiftKeyStroke(36), "selectFirstRowExtendSelection");
        tableInputMap.put(SwingUtils.getShiftKeyStroke(35), "selectLastRowExtendSelection");
        this.setAction(this.pluginDetailPanel.getBtnPriorityDown(), "priorityDownAction");
        this.setAction(this.pluginDetailPanel.getBtnPriorityUp(), "priorityUpAction");
        new FindTableAction(this.resourceMap, 3){

            @Override
            protected Object getObject(int index, int column) {
                return PluginsTab.this.pluginTable.getModel().getValueAt(index, column);
            }
        }.install(this.pluginTable);
        ((DefaultRowSorter)this.pluginTable.getRowSorter()).setComparator(8, Collections.reverseOrder());
    }

    private void updatePremium(PluginMetaData data) {
        if (!data.isEnabled()) {
            return;
        }
        List<PluginMetaData> dataList = this.managerDirector.getPluginsManager().getSupportedPlugins();
        String s = data.getServices();
        for (PluginMetaData metaData : dataList) {
            if (!metaData.getServices().equals(s) || data.equals(metaData)) continue;
            metaData.setEnabled(false);
        }
    }

    public boolean isPluginOptionsEnabled() {
        return this.pluginOptionsEnabled;
    }

    public void setPluginOptionsEnabled(boolean pluginOptionsEnabled) {
        boolean oldValue = this.pluginOptionsEnabled;
        this.pluginOptionsEnabled = pluginOptionsEnabled;
        this.firePropertyChange(PLUGIN_OPTIONS_ENABLED_PROPERTY, oldValue, pluginOptionsEnabled);
    }

    @Action
    public void priorityUpAction() {
        int[] rows = Swinger.getSelectedRows(this.pluginTable);
        if (rows.length <= 0) {
            return;
        }
        this.pluginTable.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(8, SortOrder.ASCENDING)));
        PluginMetaData data = ((PluginMetaDataTableModel)this.pluginTable.getModel()).getMetaValueAt(rows[0]);
        List<PluginMetaData> dataList = this.getSortedPriorityPluginList();
        int i = dataList.indexOf(data);
        if (i == -1 || dataList.size() - 1 == i) {
            return;
        }
        PluginMetaData lowerPriorityPlugin = dataList.get(i + 1);
        data.setPluginPriority(Math.min(10000, lowerPriorityPlugin.getPluginPriority() + 1));
    }

    @Action
    public void priorityDownAction() {
        int[] rows = Swinger.getSelectedRows(this.pluginTable);
        if (rows.length <= 0) {
            return;
        }
        this.pluginTable.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(8, SortOrder.ASCENDING)));
        PluginMetaData data = ((PluginMetaDataTableModel)this.pluginTable.getModel()).getMetaValueAt(rows[0]);
        List<PluginMetaData> dataList = this.getSortedPriorityPluginList();
        int i = dataList.indexOf(data);
        if (i == -1 || i == 0) {
            return;
        }
        PluginMetaData higherPriorityPlugin = dataList.get(i - 1);
        data.setPluginPriority(Math.max(1, higherPriorityPlugin.getPluginPriority() - 1));
    }

    private List<PluginMetaData> getSortedPriorityPluginList() {
        List<PluginMetaData> datas = this.getSupportedPlugins();
        Collections.sort(datas, new PluginsManager.PriorityComparator());
        return datas;
    }

    @Action
    public void copyPluginListAction() {
        this.copyPluginList(false);
    }

    private void copyPluginList(boolean withVersion) {
        List<PluginMetaData> datas = this.getSortedPluginList();
        StringBuilder builder = new StringBuilder();
        String lineSeparator = Utils.getSystemLineSeparator();
        for (PluginMetaData data : datas) {
            builder.append(data.getId());
            if (withVersion) {
                builder.append(' ').append(data.getVersion());
            }
            builder.append(lineSeparator);
        }
        SwingUtils.copyToClipboard(builder.toString().trim(), this);
    }

    private List<PluginMetaData> getSortedPluginList() {
        List<PluginMetaData> datas = this.getSupportedPlugins();
        Collections.sort(datas);
        return datas;
    }

    private List<PluginMetaData> getSupportedPlugins() {
        return this.managerDirector.getPluginsManager().getSupportedPlugins();
    }

    @Action
    public void copyPluginListWithVersionAction() {
        this.copyPluginList(true);
    }

    @Action
    public void copySupportedSitesListAction() {
        List<PluginMetaData> dataList = this.getSortedPluginList();
        StringBuilder builder = new StringBuilder();
        String lineSeparator = Utils.getSystemLineSeparator();
        for (PluginMetaData data : dataList) {
            builder.append(data.getServices());
            builder.append(lineSeparator);
        }
        SwingUtils.copyToClipboard(builder.toString().trim(), this);
    }

    @Action
    public void copyContent() {
        int[] rows = Swinger.getSelectedRows(this.pluginTable);
        if (rows.length <= 0) {
            return;
        }
        int selCol = this.pluginTable.convertColumnIndexToModel(this.pluginTable.getColumnModel().getSelectionModel().getLeadSelectionIndex());
        if (selCol == 0 || selCol == 1) {
            return;
        }
        PluginMetaDataTableModel tableModel = (PluginMetaDataTableModel)this.pluginTable.getModel();
        Object value = tableModel.getValueAt(rows[0], selCol);
        if (value != null) {
            SwingUtils.copyToClipboard(value.toString(), this);
        }
    }

    @Action(enabledProperty="pluginOptionsEnabled")
    public void btnPluginOptionsAction() {
        int selectedRow = this.pluginTable.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        int i = this.pluginTable.convertRowIndexToModel(selectedRow);
        if (i == -1) {
            return;
        }
        PluginMetaData data = ((PluginMetaDataTableModel)this.pluginTable.getModel()).getObject(i);
        ShareDownloadService service = this.managerDirector.getPluginsManager().getPluginInstance(data.getId());
        try {
            service.showOptions();
            this.dialog.getModel().setBuffering(true);
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
        }
    }

    @Action
    public void btnResetDefaultPluginServerAction() {
        this.comboPluginServers.getModel().setSelectedItem("http://wordrider.net/freerapid/pluginsCheck.php");
    }

    @Action
    public void selectAllUpdatesAction() {
        this.checkOrUncheckPlugin(Boolean.TRUE, 1);
    }

    @Action
    public void deSelectAllUpdatesAction() {
        this.checkOrUncheckPlugin(Boolean.FALSE, 1);
    }

    @Action
    public void selectAllActivityAction() {
        this.checkOrUncheckPlugin(Boolean.TRUE, 0);
    }

    @Action
    public void deSelectAllActivityAction() {
        this.checkOrUncheckPlugin(Boolean.FALSE, 0);
    }

    @Action
    public void selectAllCMAction() {
        this.checkOrUncheckPlugin(Boolean.TRUE, 2);
    }

    @Action
    public void deSelectAllCMAction() {
        this.checkOrUncheckPlugin(Boolean.FALSE, 2);
    }

    private void checkOrUncheckPlugin(Object value, int columnIndex) {
        PluginMetaDataTableModel tableModel = (PluginMetaDataTableModel)this.pluginTable.getModel();
        int count = tableModel.getRowCount();
        for (int i = 0; i < count; ++i) {
            tableModel.setValueAt(value, i, columnIndex);
        }
    }

    @Override
    public boolean validated() {
        Object item = this.comboPluginServers.getSelectedItem();
        if (item != null && !item.toString().isEmpty()) {
            try {
                new URI(item.toString());
            }
            catch (URISyntaxException e) {
                this.pluginTabbedPane.setSelectedIndex(1);
                this.dialog.showCard(UserPreferencesDialog.Card.CARD6);
                Swinger.inputFocus(this.comboPluginServers);
                Swinger.showErrorMessage(this.resourceMap, "invalidURL", item.toString());
                return false;
            }
        }
        return true;
    }

    @Override
    public void apply() {
        AppPrefs.storeProperty("pluginCheckUrlSelected", this.comboPluginServers.getSelectedItem().toString());
        ((SimplePreferencesComboModel)this.comboPluginServers.getModel()).store();
        if (this.pluginTableWasChanged) {
            this.managerDirector.getPluginsManager().updatePluginSettings();
            this.dialog.setUpdateQueue();
        }
    }

    @Override
    public void build(CellConstraints cc) {
        JPanel pluginPanelSettings = new JPanel();
        JPanel pluginPanelUpdates = new JPanel();
        this.pluginTabbedPane = new JTabbedPane();
        JScrollPane scrollPane1 = new JScrollPane();
        JXButtonPanel pluginsButtonPanel = new JXButtonPanel();
        this.pluginTable = new JXTable();
        this.pluginTabbedPane.setName("pluginTabbedPane");
        this.pluginDetailPanel = new PluginDetailPanel();
        this.resourceMap.injectComponents(this.pluginDetailPanel);
        JLabel labelPluginInfo = new JLabel();
        labelPluginInfo.setName("labelPluginInfo");
        this.popmenuButton = ComponentFactory.getPopdownButton();
        this.popmenuButton.setName("popmenuButton");
        this.btnPluginOptions = new JButton();
        this.btnPluginOptions.setName("btnPluginOptions");
        this.check4PluginUpdatesAutomatically = new JCheckBox();
        this.check4PluginUpdatesAutomatically.setName("check4PluginUpdatesAutomatically");
        this.comboHowToUpdate = new JComboBox();
        JLabel labelAfterDetectUpdate = new JLabel();
        labelAfterDetectUpdate.setName("labelAfterDetectUpdate");
        labelAfterDetectUpdate.setLabelFor(this.comboHowToUpdate);
        this.checkDownloadNotExistingPlugins = new JCheckBox();
        this.checkDownloadNotExistingPlugins.setName("checkDownloadNotExistingPlugins");
        JLabel labelCheckForUpdateEvery = new JLabel();
        labelCheckForUpdateEvery.setName("labelCheckForUpdateEvery");
        this.spinnerUpdateHour = new JSpinner();
        JLabel labelHours = new JLabel();
        labelHours.setName("labelHours");
        this.comboPluginServers = new JComboBox();
        this.comboPluginServers.setEditable(true);
        JLabel labelUpdateFromServer = new JLabel();
        labelUpdateFromServer.setName("labelUpdateFromServer");
        labelUpdateFromServer.setLabelFor(this.comboPluginServers);
        this.btnResetDefaultPluginServer = new JButton();
        this.btnResetDefaultPluginServer.setName("btnResetDefaultPluginServer");
        JLabel labelManualCheck = new JLabel();
        labelManualCheck.setName("labelManualCheck");
        this.setBorder(Borders.TABBED_DIALOG);
        pluginPanelSettings.setBorder(new CompoundBorder(new EmptyBorder(4, 4, 4, 4), new EtchedBorder()));
        pluginPanelSettings.setLayout(new BorderLayout());
        scrollPane1.setViewportView(this.pluginTable);
        pluginPanelSettings.add((Component)scrollPane1, "Center");
        pluginPanelSettings.add((Component)this.pluginDetailPanel, "East");
        pluginsButtonPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        PanelBuilder pluginsButtonPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.UNRELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.UNRELATED_GAP_COLSPEC}, RowSpec.decodeSpecs("default")), pluginsButtonPanel);
        pluginsButtonPanelBuilder.add((Component)labelPluginInfo, cc.xy(3, 1));
        pluginsButtonPanelBuilder.add((Component)this.popmenuButton, cc.xy(5, 1));
        pluginsButtonPanelBuilder.add((Component)this.btnPluginOptions, cc.xy(7, 1));
        pluginPanelSettings.add((Component)pluginsButtonPanel, "South");
        this.pluginTabbedPane.addTab(this.resourceMap.getString("pluginPanelSettings.tab.title", new Object[0]), pluginPanelSettings);
        pluginPanelUpdates.setBorder(new CompoundBorder(new EmptyBorder(4, 4, 4, 4), new TitledBorder(this.resourceMap.getString("pluginPanelUpdates.border", new Object[0]))));
        PanelBuilder pluginPanelUpdatesBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.bounded(Sizes.MINIMUM, Sizes.dluX(30), Sizes.dluX(30))), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.bounded(Sizes.DEFAULT, Sizes.dluX(50), Sizes.dluX(75)), 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.UNRELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), pluginPanelUpdates);
        pluginPanelUpdatesBuilder.add((Component)this.check4PluginUpdatesAutomatically, cc.xywh(1, 1, 5, 1));
        pluginPanelUpdatesBuilder.add((Component)labelAfterDetectUpdate, cc.xywh(1, 3, 3, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        pluginPanelUpdatesBuilder.add((Component)this.comboHowToUpdate, cc.xywh(5, 3, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        pluginPanelUpdatesBuilder.add((Component)this.checkDownloadNotExistingPlugins, cc.xywh(1, 5, 5, 1));
        pluginPanelUpdatesBuilder.add((Component)labelCheckForUpdateEvery, cc.xywh(1, 7, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        pluginPanelUpdatesBuilder.add((Component)this.spinnerUpdateHour, cc.xy(3, 7));
        pluginPanelUpdatesBuilder.add((Component)labelHours, cc.xy(5, 7));
        pluginPanelUpdatesBuilder.add((Component)labelUpdateFromServer, cc.xywh(1, 9, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        pluginPanelUpdatesBuilder.add((Component)this.comboPluginServers, cc.xywh(3, 9, 3, 1));
        pluginPanelUpdatesBuilder.add((Component)this.btnResetDefaultPluginServer, cc.xy(7, 9));
        pluginPanelUpdatesBuilder.add((Component)labelManualCheck, cc.xywh(1, 13, 7, 1));
        this.pluginTabbedPane.addTab(this.resourceMap.getString("pluginPanelUpdates.tab.title", new Object[0]), pluginPanelUpdates);
        PanelBuilder thisBuilder = new PanelBuilder(new FormLayout(ColumnSpec.decodeSpecs("default:grow"), new RowSpec[]{new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode("5px")}), this);
        thisBuilder.add((Component)this.pluginTabbedPane, cc.xy(1, 1));
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private static class PluginConnectionAllowedRenderer
    extends DefaultTableCellRenderer {
        private PluginConnectionAllowedRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = table.getValueAt(row, column);
            }
            this.setHorizontalAlignment(4);
            PluginMetaData data = ((PluginMetaDataTableModel)table.getModel()).getMetaValueAt(row);
            if (data.getMaxAllowedDownloads() < data.getMaxParallelDownloads()) {
                this.setForeground(Color.GREEN);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class SpinnerEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JSpinner spinner = new JSpinner();

        public SpinnerEditor() {
            SpinnerNumberModel model = new SpinnerNumberModel();
            this.spinner.setModel(model);
            this.spinner.setEditor(new JSpinner.NumberEditor(this.spinner));
            model.setMinimum(Integer.valueOf(1));
            this.spinner.setFocusable(true);
            for (Component tmpComponent : this.spinner.getComponents()) {
                tmpComponent.setFocusable(true);
                tmpComponent.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent fe) {
                    }
                });
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            row = table.convertRowIndexToModel(row);
            assert (row >= 0);
            PluginMetaData data = ((PluginMetaDataTableModel)table.getModel()).getMetaValueAt(row);
            SpinnerNumberModel model = (SpinnerNumberModel)this.spinner.getModel();
            column = table.convertColumnIndexToModel(column);
            this.spinner.setEnabled(true);
            if (column == 7) {
                int maxParallel = data.getMaxParallelDownloads();
                if (maxParallel == 1) {
                    this.spinner.setEnabled(false);
                }
                model.setMaximum(Integer.valueOf(maxParallel));
            } else {
                model.setMaximum(Integer.valueOf(10000));
            }
            this.spinner.setValue(value);
            return this.spinner;
        }

        @Override
        public Object getCellEditorValue() {
            return this.spinner.getValue();
        }
    }
}

