/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

class DownloadService {
    private Collection<ConnectionSettings> downloading = new Vector<ConnectionSettings>();
    private Collection<DownloadFile> testing = new Vector<DownloadFile>();
    private Collection<ConnectionSettings> problems = new Vector<ConnectionSettings>();
    private String serviceName;
    private int maxDownloads;

    public DownloadService(PluginMetaData fileService, ShareDownloadService service) {
        this.setPluginMetaData(fileService);
    }

    public boolean canDownloadWith(ConnectionSettings connectionSettings) {
        if (this.problems.contains(connectionSettings)) {
            return false;
        }
        int foundCount = 0;
        for (ConnectionSettings settings : this.downloading) {
            if (!settings.equals(connectionSettings) || ++foundCount < this.maxDownloads) continue;
            return false;
        }
        return true;
    }

    public boolean canDownloadBeforeCheck(DownloadFile testFile, List<DownloadFile> list, boolean startFromTop) {
        if (this.testing.isEmpty()) {
            return true;
        }
        int index = list.indexOf(testFile);
        for (DownloadFile file : this.testing) {
            int i = list.indexOf(file);
            if (!(startFromTop ? i < index : i > index)) continue;
            return false;
        }
        return true;
    }

    public void addTestingFile(DownloadFile file) {
        this.testing.add(file);
    }

    public void finishedTestingFile(DownloadFile file) {
        this.testing.remove(file);
    }

    public void addDownloadingClient(HttpDownloadClient client) {
        this.downloading.add(client.getSettings());
    }

    public void addProblematicConnection(ConnectionSettings settings) {
        this.problems.add(settings);
    }

    public void removeProblematicConnection(ConnectionSettings settings) {
        this.problems.remove(settings);
    }

    public void finishedDownloading(HttpDownloadClient client) {
        this.downloading.remove(client.getSettings());
    }

    public int getProblematicConnectionsCount() {
        return this.problems.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadService that = (DownloadService)o;
        return this.serviceName.equals(that.serviceName);
    }

    public int hashCode() {
        return this.serviceName.hashCode();
    }

    public String toString() {
        return this.serviceName;
    }

    public void setPluginMetaData(PluginMetaData metaData) {
        this.serviceName = metaData.getServices();
        this.maxDownloads = metaData.getMaxAllowedDownloads();
    }
}

