/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;

public final class TextComponentContextMenuListener
implements AWTEventListener {
    @Override
    public void eventDispatched(AWTEvent event) {
        if (!(event instanceof MouseEvent)) {
            return;
        }
        MouseEvent me = (MouseEvent)event;
        if (!me.isPopupTrigger()) {
            return;
        }
        if (me.getComponent() == null) {
            return;
        }
        Component comp = SwingUtilities.getDeepestComponentAt(me.getComponent(), me.getX(), me.getY());
        if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            return;
        }
        if (!(comp instanceof JTextComponent)) {
            return;
        }
        JTextComponent tc = (JTextComponent)comp;
        tc.grabFocus();
        ApplicationContext context = Application.getInstance().getContext();
        ApplicationActionMap map = context.getActionMap();
        JPopupMenu menu = new JPopupMenu();
        menu.add(map.get("cut"));
        menu.add(map.get("copy"));
        menu.add(map.get("paste"));
        menu.add(map.get("delete"));
        menu.addSeparator();
        Action action = map.get("select-all");
        menu.add(action);
        Point pt = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), tc);
        menu.show(tc, pt.x, pt.y);
    }
}

