/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mint;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.mint.MintLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class MintBorders
extends BaseBorders {
    private static Border buttonBorder = null;
    private static Border rolloverToolButtonBorder = null;
    private static Border internalFrameBorder = null;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = this.isActive(component);
            boolean bl2 = this.isResizable(component);
            if (!bl2) {
                ColorUIResource colorUIResource = MintLookAndFeel.getFrameColor();
                ColorUIResource colorUIResource2 = MintLookAndFeel.getWindowInactiveBorderColor();
                if (bl) {
                    colorUIResource2 = MintLookAndFeel.getWindowBorderColor();
                }
                Color color = ColorHelper.brighter(colorUIResource, 40.0);
                ColorUIResource colorUIResource3 = colorUIResource;
                JTattooUtilities.draw3DBorder(graphics, color, colorUIResource3, n, n2, n3, n4);
                graphics.setColor(colorUIResource2);
                for (int i = 1; i < 5; ++i) {
                    graphics.drawRect(i, i, n3 - 2 * i - 1, n4 - 2 * i - 1);
                }
                return;
            }
            --n4;
            --n3;
            ColorUIResource colorUIResource = MintLookAndFeel.getWindowInactiveBorderColor();
            if (bl) {
                colorUIResource = MintLookAndFeel.getWindowBorderColor();
            }
            graphics.setColor(colorUIResource);
            graphics.drawLine(n, n2, n, n2 + n4);
            graphics.setColor(ColorHelper.brighter(colorUIResource, 60.0));
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 1);
            graphics.setColor(ColorHelper.brighter(colorUIResource, 40.0));
            graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + n4 - 2);
            graphics.setColor(ColorHelper.brighter(colorUIResource, 20.0));
            graphics.drawLine(n + 3, n2 + 3, n + 3, n2 + n4 - 3);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n + 4, n2 + 4, n + 4, n2 + n4 - 4);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
            graphics.setColor(ColorHelper.brighter(colorUIResource, 20.0));
            graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(ColorHelper.brighter(colorUIResource, 40.0));
            graphics.drawLine(n + n3 - 2, n2 + 2, n + n3 - 2, n2 + n4 - 2);
            graphics.setColor(ColorHelper.brighter(colorUIResource, 60.0));
            graphics.drawLine(n + n3 - 3, n2 + 3, n + n3 - 3, n2 + n4 - 3);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n + n3 - 4, n2 + 4, n + n3 - 4, n2 + n4 - 4);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n, n2, n + n3, n2);
            graphics.setColor(ColorHelper.brighter(colorUIResource, 60.0));
            graphics.drawLine(n + 1, n2 + 1, n + n3 - 1, n2 + 1);
            graphics.setColor(ColorHelper.brighter(colorUIResource, 40.0));
            graphics.drawLine(n + 2, n2 + 2, n + n3 - 2, n2 + 2);
            graphics.setColor(ColorHelper.brighter(colorUIResource, 20.0));
            graphics.drawLine(n + 3, n2 + 3, n + n3 - 3, n2 + 3);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n + 4, n2 + 4, n + n3 - 4, n2 + 4);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
            graphics.setColor(ColorHelper.brighter(colorUIResource, 20.0));
            graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(ColorHelper.brighter(colorUIResource, 40.0));
            graphics.drawLine(n + 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
            graphics.setColor(ColorHelper.brighter(colorUIResource, 60.0));
            graphics.drawLine(n + 3, n2 + n4 - 3, n + n3 - 3, n2 + n4 - 3);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n + 4, n2 + n4 - 4, n + n3 - 4, n2 + n4 - 4);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            Color color = ColorHelper.darker(AbstractLookAndFeel.getToolbarBackgroundColor(), 20.0);
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    graphics.setColor(color);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.15f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.black);
                    graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                    graphics2D.setComposite(composite);
                } else if (buttonModel.isRollover()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    graphics.setColor(color);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.white);
                    graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                    graphics2D.setComposite(composite);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = RolloverToolButtonBorder.insets.left;
            insets.top = RolloverToolButtonBorder.insets.top;
            insets.right = RolloverToolButtonBorder.insets.right;
            insets.bottom = RolloverToolButtonBorder.insets.bottom;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(3, 8, 5, 10);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(ButtonBorder.insets.top, ButtonBorder.insets.left, ButtonBorder.insets.bottom, ButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = ButtonBorder.insets.left;
            insets.top = ButtonBorder.insets.top;
            insets.right = ButtonBorder.insets.right;
            insets.bottom = ButtonBorder.insets.bottom;
            return insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

