/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jdo.identity.SingleFieldIdentity;

public class ByteIdentity
extends SingleFieldIdentity {
    private byte key;

    private void construct(byte by) {
        this.key = by;
        this.hashCode = super.hashClassName() ^ by;
    }

    public ByteIdentity(Class clazz, byte by) {
        super(clazz);
        this.construct(by);
    }

    public ByteIdentity(Class clazz, Byte by) {
        super(clazz);
        this.setKeyAsObject(by);
        this.construct(by);
    }

    public ByteIdentity(Class clazz, String string) {
        super(clazz);
        this.assertKeyNotNull(string);
        this.construct(Byte.parseByte(string));
    }

    public ByteIdentity() {
    }

    public byte getKey() {
        return this.key;
    }

    public String toString() {
        return Byte.toString(this.key);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ByteIdentity byteIdentity = (ByteIdentity)object;
        return this.key == byteIdentity.key;
    }

    public int compareTo(Object object) {
        if (object instanceof ByteIdentity) {
            ByteIdentity byteIdentity = (ByteIdentity)object;
            int n = super.compare(byteIdentity);
            if (n == 0) {
                return this.key - byteIdentity.key;
            }
            return n;
        }
        if (object == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + object.getClass().getName());
    }

    protected Object createKeyAsObject() {
        return new Byte(this.key);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeByte(this.key);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.key = objectInput.readByte();
    }
}

