/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.util.i18n;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import jlibs.core.annotation.processing.AnnotationError;
import jlibs.core.lang.model.ModelUtil;
import jlibs.core.util.i18n.Bundle;
import jlibs.core.util.i18n.Hint;
import jlibs.core.util.i18n.PropertiesUtil;

class Bundles {
    private Map<Element, List<Element>> classes = new HashMap<Element, List<Element>>();

    Bundles() {
    }

    public void add(Element element) {
        List<Element> list;
        Element container = element.getEnclosingElement();
        if (container instanceof PackageElement) {
            container = element;
        }
        if ((list = this.classes.get(container)) == null) {
            list = new ArrayList<Element>();
            this.classes.put(container, list);
        }
        list.add(element);
    }

    public void generateProperties(Map<String, Element> entries, BufferedWriter props) throws IOException {
        for (Map.Entry<Element, List<Element>> entry : this.classes.entrySet()) {
            PropertiesUtil.writeComments(props, "-------------------------------------------------[ " + entry.getKey().getSimpleName() + " ]---------------------------------------------------");
            props.newLine();
            for (Element method : entry.getValue()) {
                AnnotationMirror mirror = ModelUtil.getAnnotationMirror(method, Bundle.class);
                for (AnnotationValue value : (Collection)ModelUtil.getAnnotationValue(method, mirror, "value")) {
                    AnnotationMirror entryMirror = (AnnotationMirror)value.getValue();
                    String rhs = (String)ModelUtil.getAnnotationValue(method, entryMirror, "rhs");
                    if (rhs.length() > 0) {
                        Element clash;
                        String lhs = (String)ModelUtil.getAnnotationValue(method, entryMirror, "lhs");
                        if (lhs.length() == 0) {
                            String hintName = (String)ModelUtil.getAnnotationValue(method, entryMirror, "hintName");
                            if (hintName.length() == 0) {
                                Hint hint = Hint.valueOf(((VariableElement)ModelUtil.getAnnotationValue(method, entryMirror, "hint")).getSimpleName().toString());
                                if (hint == Hint.NONE) {
                                    throw new AnnotationError("");
                                }
                                hintName = hint.key();
                            }
                            lhs = method.getEnclosingElement().getSimpleName() + "." + method.getSimpleName() + "." + hintName;
                        }
                        if ((clash = entries.put(lhs, method)) != null) {
                            String signature;
                            if (clash instanceof ExecutableElement) {
                                signature = ModelUtil.signature((ExecutableElement)clash, false);
                            } else {
                                if (clash instanceof TypeElement) {
                                    throw new AnnotationError(method, "key '" + lhs + "' is already used by \"" + ((TypeElement)clash).getQualifiedName());
                                }
                                signature = clash.getSimpleName().toString();
                            }
                            throw new AnnotationError(method, "key '" + lhs + "' is already used by \"" + signature + "\" in " + clash.getEnclosingElement());
                        }
                        PropertiesUtil.writeProperty(props, lhs, rhs);
                        continue;
                    }
                    String comment = (String)ModelUtil.getAnnotationValue(method, entryMirror, "value");
                    if (comment.length() > 0) {
                        PropertiesUtil.writeComments(props, comment);
                        continue;
                    }
                    props.newLine();
                }
            }
            props.newLine();
        }
    }
}

