/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import jlibs.core.io.IOUtil;
import jlibs.xml.sax.SAXDelegate;
import jlibs.xml.sax.XMLDocument;
import jlibs.xml.sax.XMLWriter;
import jlibs.xml.xsl.TransformerUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ObjectInputSource<E>
extends InputSource {
    protected final E input;

    public ObjectInputSource(E input) {
        this.input = input;
    }

    public E getObject() {
        return this.input;
    }

    void writeTo(SAXDelegate saxDelegate) throws SAXException {
        XMLDocument xml = new XMLDocument(saxDelegate);
        xml.startDocument();
        this.write(this.input, xml);
        xml.endDocument();
    }

    protected abstract void write(E var1, XMLDocument var2) throws SAXException;

    private SAXSource createSource() {
        return new SAXSource(new XMLWriter(), this);
    }

    public void writeTo(Writer writer, boolean omitXMLDeclaration, int indentAmount) throws TransformerException {
        Transformer transformer = TransformerUtil.newTransformer(null, omitXMLDeclaration, indentAmount, null);
        transformer.transform(this.createSource(), new StreamResult(writer));
    }

    public void writeTo(OutputStream out, boolean omitXMLDeclaration, int indentAmount, String encoding) throws TransformerException {
        Transformer transformer = TransformerUtil.newTransformer(null, omitXMLDeclaration, indentAmount, encoding);
        transformer.transform(this.createSource(), new StreamResult(out));
    }

    public void writeTo(String systemID, boolean omitXMLDeclaration, int indentAmount, String encoding) throws TransformerException {
        Transformer transformer = TransformerUtil.newTransformer(null, omitXMLDeclaration, indentAmount, encoding);
        transformer.transform(this.createSource(), new StreamResult(systemID));
    }

    public static void main(String[] args) throws Exception {
        new ObjectInputSource<String>(null){

            @Override
            protected void write(String input, XMLDocument xml) throws SAXException {
                String google = "http://google.com";
                String yahoo = "http://yahoo.com";
                xml.addProcessingInstruction("san", "test='1.2'");
                xml.declarePrefix("google", google);
                xml.declarePrefix("yahoo", yahoo);
                xml.declarePrefix("http://msn.com");
                xml.startElement(google, "hello");
                xml.addAttribute("name", "value");
                xml.addElement("xyz", "helloworld");
                xml.addElement(google, "hai", "test");
                xml.addXML(new InputSource("xml/xsds/note.xsd"), true);
                xml.addComment("this is comment");
                xml.addCDATA("this is sample cdata");
            }
        }.writeTo(new OutputStreamWriter((OutputStream)System.out, IOUtil.UTF_8), false, 4);
    }
}

