/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.async;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jlibs.xml.sax.async.AttributeType;
import jlibs.xml.sax.async.DTDAttribute;
import jlibs.xml.sax.async.Namespaces;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.AttributesImpl;

public class DTD {
    public String root;
    public Map<String, Map<String, DTDAttribute>> attributes = new HashMap<String, Map<String, DTDAttribute>>();
    private Namespaces namespaces;
    public Set<String> nonMixedElements = new HashSet<String>();
    public InputSource externalDTD;

    public DTD(Namespaces namespaces) {
        this.namespaces = namespaces;
    }

    public void reset() {
        this.root = null;
        this.attributes.clear();
        this.nonMixedElements.clear();
        this.externalDTD = null;
    }

    public AttributeType attributeType(String element, String attribute) {
        DTDAttribute dtdAttr;
        AttributeType type = AttributeType.CDATA;
        Map<String, DTDAttribute> attrList = this.attributes.get(element);
        if (attrList != null && (dtdAttr = attrList.get(attribute)) != null) {
            type = dtdAttr.type == AttributeType.ENUMERATION ? AttributeType.NMTOKEN : dtdAttr.type;
        }
        return type;
    }

    public void addMissingAttributes(String element, AttributesImpl attributes) {
        Map<String, DTDAttribute> attList = this.attributes.get(element);
        if (attList == null) {
            return;
        }
        for (DTDAttribute dtdAttr : attList.values()) {
            switch (dtdAttr.valueType) {
                case DEFAULT: 
                case FIXED: {
                    if (attributes.getIndex(dtdAttr.name) != -1 || dtdAttr.isNamespace()) break;
                    AttributeType type = dtdAttr.type == AttributeType.ENUMERATION ? AttributeType.NMTOKEN : dtdAttr.type;
                    String namespaceURI = "";
                    String localName = dtdAttr.name;
                    String qname = localName;
                    int colon = qname.indexOf(58);
                    if (colon != -1) {
                        localName = qname.substring(colon + 1);
                        String prefix = qname.substring(0, colon);
                        if (prefix.length() > 0) {
                            namespaceURI = this.namespaces.getNamespaceURI(prefix);
                        }
                    }
                    attributes.addAttribute(namespaceURI, localName, qname, type.name(), dtdAttr.value);
                }
            }
        }
    }
}

