/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.io;

import java.io.File;
import java.io.IOException;
import opennlp.tools.ml.maxent.io.GISModelReader;
import opennlp.tools.ml.maxent.quasinewton.QNModel;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.DataReader;

public class QNModelReader
extends GISModelReader {
    public QNModelReader(DataReader dataReader) {
        super(dataReader);
    }

    public QNModelReader(File file) throws IOException {
        super(file);
    }

    @Override
    public void checkModelType() throws IOException {
        String modelType = this.readUTF();
        if (!modelType.equals("QN")) {
            System.out.println("Error: attempting to load a " + modelType + " model as a MAXENT_QN model." + " You should expect problems.");
        }
    }

    @Override
    public QNModel constructModel() throws IOException {
        String[] outcomeLabels = this.getOutcomes();
        int[][] outcomePatterns = this.getOutcomePatterns();
        String[] predLabels = this.getPredicates();
        Context[] params = this.getParameters(outcomePatterns);
        return new QNModel(params, predLabels, outcomeLabels);
    }
}

