/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.xmind.core.IEncryptionData;
import org.xmind.core.IFileEntry;
import org.xmind.core.IFileEntryFilter;
import org.xmind.core.IManifest;
import org.xmind.core.IWorkbook;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.plain.FileEntry;
import org.xmind.core.plain.Workbook;
import org.xmind.core.util.Codec;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.IteratorProxy;

public class Manifest
implements IManifest {
    private static final String PATH_TEMP_DIR = ".temp/";
    private final Workbook ownerWorkbook;
    private Map<String, FileEntry> entriesByPaths;
    private List<FileEntry> entries;
    private final String attPathPrefix;
    private String passwordHint;

    public Manifest(Workbook ownerWorkbook, String attachmentPathPrefix) {
        this.ownerWorkbook = ownerWorkbook;
        this.entriesByPaths = new HashMap<String, FileEntry>();
        this.entries = new ArrayList<FileEntry>();
        this.attPathPrefix = attachmentPathPrefix == null ? "" : attachmentPathPrefix;
        this.passwordHint = null;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    public boolean isOrphan() {
        return false;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        return null;
    }

    protected void addFileEntry(FileEntry entry) {
        this.entries.add(entry);
    }

    protected void removeFileEntry(FileEntry entry) {
        this.entries.remove(entry);
    }

    public List<IFileEntry> getFileEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public Iterator<IFileEntry> iterFileEntries() {
        return new IteratorProxy<IFileEntry>(this.entries.iterator());
    }

    public Iterator<IFileEntry> iterFileEntries(final IFileEntryFilter filter) {
        final Iterator<FileEntry> it = this.entries.iterator();
        return new Iterator<IFileEntry>(){
            IFileEntry nextEntry = this.findNextEntry();

            private IFileEntry findNextEntry() {
                while (it.hasNext()) {
                    IFileEntry e = (IFileEntry)it.next();
                    if (!this.selects(e)) continue;
                    return e;
                }
                return null;
            }

            private boolean selects(IFileEntry e) {
                return filter == null || filter.select(e.getPath(), e.getMediaType(), e.isDirectory());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public IFileEntry next() {
                IFileEntry n = this.nextEntry;
                if (n == null) {
                    throw new NoSuchElementException();
                }
                this.nextEntry = this.findNextEntry();
                return n;
            }

            @Override
            public boolean hasNext() {
                return this.nextEntry != null;
            }
        };
    }

    public IFileEntry getFileEntry(String path) {
        return this.entriesByPaths.get(path);
    }

    public IFileEntry createFileEntry(String path) {
        return this.createFileEntry(path, null);
    }

    public IFileEntry createFileEntry(String path, String mediaType) {
        IFileEntry entry = this.entriesByPaths.get(path);
        if (entry != null) {
            return entry;
        }
        return this.doCreateFileEntry(path, mediaType);
    }

    private FileEntry doCreateFileEntry(String path, String mediaType) {
        String parentPath = Manifest.getParentPath(path);
        if (parentPath != null) {
            this.createFileEntry(parentPath, null);
        }
        FileEntry entry = new FileEntry(this.ownerWorkbook, path, mediaType);
        this.entriesByPaths.put(path, entry);
        return entry;
    }

    private static String getParentPath(String path) {
        int i = path.endsWith("/") ? path.lastIndexOf(47, path.length() - 2) : path.lastIndexOf(47);
        if (i < 0) {
            return null;
        }
        return path.substring(0, i + 1);
    }

    public IFileEntry createAttachmentFromStream(InputStream stream, String sourceName) throws IOException {
        return this.createAttachmentFromStream(stream, sourceName, null);
    }

    public IFileEntry createAttachmentFromStream(InputStream stream, String sourceName, String mediaType) throws IOException {
        MessageDigest digest;
        if (stream == null) {
            throw new IllegalArgumentException("Source stream is null");
        }
        IStorage storage = this.ownerWorkbook.getStorage();
        IOutputTarget outputTarget = storage.getOutputTarget();
        String tempPath = PATH_TEMP_DIR + UUID.randomUUID().toString();
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        try (DigestOutputStream outputStream = new DigestOutputStream(outputTarget.openEntryStream(tempPath), digest);){
            FileUtils.transfer((InputStream)stream, (OutputStream)outputStream, (boolean)false);
        }
        if (sourceName != null) {
            sourceName = FileUtils.getFileName((String)sourceName);
        }
        String hash = String.valueOf(Codec.hexEncode((byte[])digest.digest(), (boolean)false));
        String extName = sourceName == null ? "" : FileUtils.getExtension((String)sourceName);
        String path = String.valueOf(this.attPathPrefix) + hash + extName;
        FileEntry oldEntry = this.entriesByPaths.get(path);
        if (oldEntry != null) {
            storage.deleteEntry(tempPath);
            return oldEntry;
        }
        storage.renameEntry(tempPath, path);
        if (mediaType == null) {
            if (sourceName != null) {
                mediaType = URLConnection.guessContentTypeFromName(sourceName);
            }
            if (mediaType == null) {
                mediaType = "";
            }
        }
        return this.doCreateFileEntry(path, mediaType);
    }

    public IFileEntry createAttachmentFromFilePath(String sourcePath) throws IOException {
        return this.createAttachmentFromFilePath(sourcePath, null);
    }

    public IFileEntry createAttachmentFromFilePath(String sourcePath, String mediaType) throws IOException {
        if (sourcePath == null) {
            throw new IllegalArgumentException("Source path is null");
        }
        File sourceFile = new File(sourcePath);
        if (!sourceFile.exists()) {
            throw new FileNotFoundException("File does not exist: " + sourcePath);
        }
        try (FileInputStream stream = new FileInputStream(sourceFile);){
            IFileEntry iFileEntry = this.createAttachmentFromStream(stream, sourceFile.getName(), mediaType);
            return iFileEntry;
        }
    }

    public IFileEntry cloneEntry(IFileEntry sourceEntry, String targetPath) throws IOException {
        return null;
    }

    public IFileEntry cloneEntryAsAttachment(IFileEntry sourceEntry) throws IOException {
        return null;
    }

    public IEncryptionData getEncryptionData(String entryPath) {
        return null;
    }

    public boolean deleteFileEntry(String path) {
        return false;
    }

    public String makeAttachmentPath(String sourcePath) {
        return null;
    }

    public String makeAttachmentPath(String source, boolean directory) {
        return null;
    }

    public String getPasswordHint() {
        return this.passwordHint;
    }

    public void setPasswordHint(String hint) {
        this.passwordHint = hint;
    }
}

