/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.command.remote;

import org.eclipse.core.runtime.IConfigurationElement;
import org.xmind.core.command.remote.ICommandServer;
import org.xmind.core.command.remote.ICommandServerAdvertiser;
import org.xmind.core.command.remote.ICommandServiceDomain;
import org.xmind.core.command.remote.ICommandServiceDomainDirector;
import org.xmind.core.command.remote.IDomainServiceFactory;
import org.xmind.core.command.remote.IRemoteCommandServiceDiscoverer;
import org.xmind.core.internal.command.remote.CommandServiceDomainManagerImpl;
import org.xmind.core.internal.command.remote.DefaultCommandServiceDomainDirector;
import org.xmind.core.internal.command.remote.IDomainsExtensionConstants;
import org.xmind.core.internal.command.remote.NullDomainService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandServiceDomainImpl
implements ICommandServiceDomain,
IDomainsExtensionConstants {
    private final CommandServiceDomainManagerImpl manager;
    private final String id;
    private final IConfigurationElement element;
    private ICommandServiceDomainDirector director = null;
    private ICommandServer server = null;
    private ICommandServerAdvertiser advertiser = null;
    private IRemoteCommandServiceDiscoverer discoverer = null;

    public CommandServiceDomainImpl(CommandServiceDomainManagerImpl manager, String id, IConfigurationElement element) {
        this.manager = manager;
        this.id = id;
        this.element = element;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.element.getAttribute("name");
    }

    private <T> T createDomainService(String attrName, Class<T> serviceClass) {
        Object service;
        IDomainServiceFactory factory;
        String factoryId = this.element.getAttribute(attrName);
        if (factoryId != null && (factory = this.manager.getServiceFactory(factoryId)) != null && (service = factory.createDomainService(this)) != null && serviceClass.isAssignableFrom(service.getClass())) {
            return serviceClass.cast(service);
        }
        if (serviceClass == ICommandServiceDomainDirector.class) {
            return serviceClass.cast(new DefaultCommandServiceDomainDirector());
        }
        return serviceClass.cast(NullDomainService.getDefault());
    }

    @Override
    public synchronized ICommandServiceDomainDirector getDirector() {
        if (this.director == null) {
            this.director = this.createDomainService("director", ICommandServiceDomainDirector.class);
            this.director.init(this);
        }
        return this.director;
    }

    @Override
    public synchronized ICommandServer getCommandServer() {
        if (this.server == null) {
            this.server = this.createDomainService("server", ICommandServer.class);
            this.server.init(this);
        }
        return this.server;
    }

    @Override
    public synchronized ICommandServerAdvertiser getCommandServerAdvertiser() {
        if (this.advertiser == null) {
            this.advertiser = this.createDomainService("advertiser", ICommandServerAdvertiser.class);
            this.advertiser.init(this);
        }
        return this.advertiser;
    }

    @Override
    public synchronized IRemoteCommandServiceDiscoverer getRemoteCommandServiceDiscoverer() {
        if (this.discoverer == null) {
            this.discoverer = this.createDomainService("discoverer", IRemoteCommandServiceDiscoverer.class);
            this.discoverer.init(this);
        }
        return this.discoverer;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof CommandServiceDomainImpl)) {
            return false;
        }
        CommandServiceDomainImpl that = (CommandServiceDomainImpl)obj;
        return this.id.equals(that.id);
    }

    public String toString() {
        return "CommandServiceDomain#" + this.id;
    }
}

