/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.util.Collection;
import org.xmind.core.Core;
import org.xmind.core.ICloneData;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookComponent;
import org.xmind.core.internal.CloneData;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.marker.IMarker;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.CloneHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbookUtilsImpl {
    private WorkbookUtilsImpl() {
    }

    public static ICloneData clone(IWorkbook targetWorkbook, Collection<? extends Object> sources, ICloneData prevResult) {
        CloneData result = new CloneData(sources, prevResult);
        for (Object object : sources) {
            if (result.get(object) != null) continue;
            CloneHandler handler = new CloneHandler(result);
            if (object instanceof IWorkbookComponent) {
                IWorkbook sourceWorkbook = ((IWorkbookComponent)object).getOwnedWorkbook();
                handler.withWorkbooks(sourceWorkbook, targetWorkbook);
            } else {
                if (!(object instanceof IMarker)) continue;
                handler.withMarkerSheets(((IMarker)object).getOwnedSheet(), targetWorkbook.getMarkerSheet());
            }
            try {
                handler.cloneObject(object);
            }
            catch (IOException e) {
                Core.getLogger().log(e);
            }
        }
        return result;
    }

    public static void increaseStyleRef(WorkbookImpl workbook, IStyled styled) {
        if (workbook == null || styled == null) {
            return;
        }
        String styleId = styled.getStyleId();
        if (styleId == null) {
            return;
        }
        workbook.getStyleRefCounter().increaseRef(styleId);
    }

    public static void decreaseStyleRef(WorkbookImpl workbook, IStyled styled) {
        if (workbook == null || styled == null) {
            return;
        }
        String styleId = styled.getStyleId();
        if (styleId == null) {
            return;
        }
        workbook.getStyleRefCounter().decreaseRef(styleId);
    }
}

