/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.dashboard;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.xmind.gef.ui.internal.SpaceCollaborativeEngine;
import org.xmind.seawind.internal.core.SeawindFolder;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.dashboard.pages.IDashboardContext;
import org.xmind.ui.internal.seawind.SeawindFolderManager;
import org.xmind.ui.internal.seawind.SeawindLibrary;
import org.xmind.ui.internal.seawind.dashboard.CloudComparator;
import org.xmind.ui.internal.seawind.dashboard.CloudFolderPageSection;
import org.xmind.ui.internal.seawind.dashboard.CloudMapPageSection;
import org.xmind.ui.views.Page;

public class CloudMapFolderGridPage
extends Page {
    private IDashboardContext context;
    private SeawindLibrary library;
    private ScrolledForm container;
    private CloudFolderPageSection folderSection;
    private CloudMapPageSection mapSection;
    private GalleryViewer currentViewer;
    private ISelection selection;

    public CloudMapFolderGridPage(IDashboardContext context, SeawindLibrary library) {
        this.context = context;
        this.library = library;
    }

    public Control doCreateControl(Composite parent) {
        this.container = this.createContainer(parent, 64);
        this.hookControl((Control)this.container);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.container.setBackground(parent.getBackground());
        this.container.setForeground(parent.getForeground());
        Composite content = this.container.getBody();
        SpaceCollaborativeEngine spaceCollaborativeEngine = new SpaceCollaborativeEngine();
        this.folderSection = new CloudFolderPageSection(this.context, this.library, content, spaceCollaborativeEngine);
        this.mapSection = new CloudMapPageSection(this.context, this.library, content, spaceCollaborativeEngine);
        this.hookNestedViewerControl(this.folderSection.getViewer());
        this.hookNestedViewerControl(this.mapSection.getViewer());
        this.currentViewer = this.mapSection.getViewer();
        this.context.setSelectionProvider((ISelectionProvider)this.currentViewer);
        this.folderSection.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                if (sel != null) {
                    CloudMapFolderGridPage.this.selection = sel;
                }
            }
        });
        this.mapSection.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                if (sel != null) {
                    CloudMapFolderGridPage.this.selection = sel;
                }
            }
        });
        this.mapSection.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CloudMapFolderGridPage.this.setViewerFocus(CloudMapFolderGridPage.this.mapSection.getViewer());
            }
        });
        this.folderSection.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CloudMapFolderGridPage.this.setViewerFocus(CloudMapFolderGridPage.this.folderSection.getViewer());
            }
        });
        this.container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CloudMapFolderGridPage.this.currentViewer = null;
            }
        });
        this.refresh();
        return this.container;
    }

    private void setViewerFocus(GalleryViewer viewer) {
        if (this.currentViewer == viewer || viewer == null) {
            return;
        }
        if (this.currentViewer != null) {
            this.currentViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        this.currentViewer = viewer;
        this.context.setSelectionProvider((ISelectionProvider)this.currentViewer);
    }

    private ScrolledForm createContainer(Composite parent, int style) {
        final WidgetFactory factory = new WidgetFactory(parent.getDisplay());
        ScrolledForm container = factory.createScrolledForm(parent);
        this.configureContainer(container);
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                factory.dispose();
            }
        });
        return container;
    }

    private void configureContainer(ScrolledForm container) {
        container.getBody().setLayout(this.createFormLayout());
        container.setMinWidth(1);
    }

    private Layout createFormLayout() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        return layout;
    }

    private void hookControl(Control control) {
        control.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                CloudMapFolderGridPage.this.relayout();
            }
        });
    }

    private void relayout() {
        int width = this.container.getClientArea().width;
        this.resetWidth(width, this.folderSection.getControl());
        this.resetWidth(width, this.mapSection.getControl());
        this.container.reflow(true);
    }

    private void resetWidth(int width, Control control) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            GridData gd = (GridData)ld;
            GridLayout gl = (GridLayout)control.getParent().getLayout();
            gd.widthHint = width - gl.marginWidth * 2 - gl.marginLeft - gl.marginRight;
        }
    }

    private void hookNestedViewerControl(GalleryViewer viewer) {
        viewer.getCanvas().setScrollBarVisibility(FigureCanvas.NEVER);
        ScrollBar hBar = viewer.getCanvas().getHorizontalBar();
        hBar.setEnabled(false);
        hBar.setVisible(false);
        ScrollBar vBar = viewer.getCanvas().getVerticalBar();
        vBar.setEnabled(false);
        vBar.setVisible(false);
    }

    public void update() {
        this.update(null);
        this.refresh();
    }

    public void update(Object[] elements) {
        if (elements == null) {
            SeawindFolderManager sfm = this.library.getSeawindFolderManager();
            String currentFolderPath = sfm.getCurrentFolderPath();
            SeawindFolder folder = sfm.getSeawindFolder(currentFolderPath);
            this.mapSection.setInput(folder);
            this.folderSection.setInput(folder);
            this.container.reflow(true);
        } else {
            this.mapSection.getViewer().update(elements);
            this.folderSection.getViewer().update(elements);
        }
    }

    public void refresh() {
        if (this.folderSection == null || this.mapSection == null) {
            return;
        }
        String type = this.context.getPersistedState("sort_type");
        if (type == null || "".equals(type)) {
            type = "by_modification_time_desc";
        }
        this.folderSection.getViewer().setComparator((ViewerComparator)CloudComparator.getComparatorAsType(type));
        this.mapSection.getViewer().setComparator((ViewerComparator)CloudComparator.getComparatorAsType(type));
        this.folderSection.getViewer().refresh();
        this.mapSection.getViewer().refresh();
        if (this.selection != null && this.currentViewer != null) {
            this.currentViewer.setSelection(this.selection);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.currentViewer != null) {
            if (adapter.isAssignableFrom(this.currentViewer.getClass())) {
                return adapter.cast(this.currentViewer);
            }
            Object obj = this.currentViewer.getAdapter(adapter);
            if (obj != null) {
                return (T)obj;
            }
        }
        return (T)super.getAdapter(adapter);
    }
}

