/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.comments;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.IComment;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.gef.EditDomain;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.ui.actions.DelegatingAction;
import org.xmind.ui.commands.DeleteCommentCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.comments.CommentsPopup;
import org.xmind.ui.mindmap.AbstractInfoItemContributor;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.TextFormatter;

public class CommentsInfoItemContributor
extends AbstractInfoItemContributor {
    private static final String PRESENTATION_VIERWER_CLASS_NAME = "PresentationViewer";

    @Override
    public IAction createAction(ITopicPart topicPart, ITopic topic) {
        TreeSet comments = new TreeSet(topic.getOwnedWorkbook().getCommentManager().getComments(topic.getId()));
        if (comments.isEmpty()) {
            return null;
        }
        Object action = null;
        IActionRegistry actionRegistry = (IActionRegistry)topicPart.getAdapter(IActionRegistry.class);
        if (actionRegistry != null && (action = actionRegistry.getAction("org.xmind.ui.editComments")) != null) {
            action = new DelegatingAction((IAction)action);
        }
        if (action == null) {
            action = new ShowCommentsAction(topicPart);
        }
        StringBuilder text = new StringBuilder();
        Iterator commentIt = comments.iterator();
        while (commentIt.hasNext()) {
            IComment comment = (IComment)commentIt.next();
            String author = comment.getAuthor();
            String content = comment.getContent();
            long timeMillisString = comment.getTime();
            text.append(author);
            text.append(" : ");
            text.append(content);
            text.append('\n');
            text.append(TextFormatter.formatTimeMillis((long)timeMillisString, (String)"yyyy-MM-dd"));
            text.append(' ');
            text.append(TextFormatter.formatTimeMillis((long)timeMillisString, (String)"HH:mm"));
            if (commentIt.hasNext()) {
                text.append("\n\n");
            }
            if (text.length() > 500) break;
        }
        if (text.length() > 500) {
            text.delete(501, text.length());
            text.append("...\n...");
        }
        action.setToolTipText(text.toString());
        return action;
    }

    @Override
    public String getSVGFilePath(ITopic topic, IAction action) {
        return "platform:/plugin/org.xmind.ui.mindmap/icons/comments.svg";
    }

    @Override
    protected void registerTopicEvent(ITopicPart topicPart, ITopic topic, ICoreEventRegister register) {
        register.register("commentAdd");
        register.register("commentRemove");
        register.setNextSupport((ICoreEventSupport)topic.getOwnedWorkbook().getAdapter(ICoreEventSupport.class));
        register.register("commentContent");
    }

    private void removeComments(ITopicPart topicPart) {
        ICommandStack commandStack;
        ITopic topic = topicPart.getTopic();
        Set comments = topic.getOwnedWorkbook().getCommentManager().getComments(topic.getId());
        if (comments.isEmpty()) {
            return;
        }
        ArrayList<DeleteCommentCommand> commands = new ArrayList<DeleteCommentCommand>(comments.size());
        for (IComment comment : comments) {
            commands.add(new DeleteCommentCommand(topic, comment));
        }
        CompoundCommand command = new CompoundCommand(MindMapMessages.Comment_Delete_label, commands);
        EditDomain domain = topicPart.getSite().getDomain();
        ICommandStack iCommandStack = commandStack = domain == null ? null : domain.getCommandStack();
        if (commandStack != null) {
            commandStack.execute((Command)command);
        } else {
            command.execute();
        }
    }

    @Override
    public List<IAction> getPopupMenuActions(final ITopicPart topicPart, ITopic topic) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        IAction editCommentsAction = this.createAction(topicPart, topic);
        editCommentsAction.setText(MindMapMessages.ModifyMenu);
        editCommentsAction.setImageDescriptor(null);
        actions.add(editCommentsAction);
        Action deleteCommentsAction = new Action(MindMapMessages.Comment_Delete_label){

            public void run() {
                CommentsInfoItemContributor.this.removeComments(topicPart);
            }
        };
        deleteCommentsAction.setId("org.xmind.ui.removeComments");
        deleteCommentsAction.setImageDescriptor(null);
        actions.add((IAction)deleteCommentsAction);
        return actions;
    }

    @Override
    protected void handleTopicEvent(IInfoPart infoPart, CoreEvent event) {
    }

    @Override
    protected void handleTopicEvent(ITopicPart topicPart, CoreEvent event) {
        topicPart.refresh();
    }

    private static class ShowCommentsAction
    extends Action {
        private ITopicPart topicPart;

        public ShowCommentsAction(ITopicPart topicPart) {
            super(MindMapMessages.EditComments_text, MindMapUI.getImages().get("menu_modify_comment.png", true));
            this.setId("org.xmind.ui.editComments");
            this.topicPart = topicPart;
        }

        public void run() {
            if (this.topicPart == null || this.topicPart.getSite() == null || this.topicPart.getSite().getViewer() == null || this.topicPart.getSite().getViewer().getClass().getSimpleName().equals(CommentsInfoItemContributor.PRESENTATION_VIERWER_CLASS_NAME)) {
                return;
            }
            if (!this.topicPart.getStatus().isActive()) {
                return;
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            CommentsPopup popup = new CommentsPopup(window, this.topicPart, false);
            popup.open();
        }
    }
}

