/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.WizardActivityFilter;
import org.eclipse.ui.internal.dialogs.WizardContentProvider;
import org.eclipse.ui.internal.dialogs.WizardPatternFilter;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardNode;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardSelectionPage;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.io.BundleResource;
import org.xmind.core.util.DOMUtils;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;

public abstract class ImportExportPage
extends WorkbenchWizardSelectionPage {
    public static final String RECENTLY_USED_CATEGORY_ID = "recentlyUsed";
    protected static final String DIALOG_SETTING_SECTION_NAME = "ImportExportPage.";
    private static final String WIZARDS_ORDER_XML_PATH = "src/org/xmind/ui/internal/wizards/wizards_order.xml";
    protected ResourceManager resources;
    private TreeViewer treeViewer;
    protected List<Object> wizardsOrder;

    protected ImportExportPage(IWorkbench aWorkbench, IStructuredSelection currentSelection) {
        super("importExportPage", aWorkbench, currentSelection, null, null);
        this.setTitle(WorkbenchMessages.Select);
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite outerContainer = new Composite(parent, 0);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)outerContainer);
        outerContainer.setLayout((Layout)new GridLayout());
        outerContainer.setLayoutData((Object)new GridData(1808));
        outerContainer.setFont(font);
        Composite comp = this.createTreeViewer(outerContainer);
        Dialog.applyDialogFont((Control)comp);
        this.restoreWidgetValues();
        this.setControl((Control)outerContainer);
        this.initialize();
    }

    protected abstract Composite createTreeViewer(Composite var1);

    protected void treeDoubleClicked(DoubleClickEvent event) {
        ISelection selection = event.getViewer().getSelection();
        IStructuredSelection ss = (IStructuredSelection)selection;
        this.listSelectionChanged((ISelection)ss);
        Object element = ss.getFirstElement();
        TreeViewer v = (TreeViewer)event.getViewer();
        if (v.isExpandable(element)) {
            v.setExpandedState(element, !v.getExpandedState(element));
        } else if (element instanceof WorkbenchWizardElement && this.canFlipToNextPage()) {
            this.getContainer().showPage(this.getNextPage());
            return;
        }
        this.getContainer().showPage(this.getNextPage());
    }

    private void updateSelectedNode(WorkbenchWizardElement wizardElement) {
        this.setErrorMessage(null);
        if (wizardElement == null) {
            this.updateMessage();
            this.setSelectedNode(null);
            return;
        }
        this.setSelectedNode(this.createWizardNode((IWizardDescriptor)wizardElement));
        this.setMessage(wizardElement.getDescription());
    }

    protected void updateMessage() {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            ISelection selection = viewer.getSelection();
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object sel = ss.getFirstElement();
            if (sel instanceof WorkbenchWizardElement) {
                this.updateSelectedNode((WorkbenchWizardElement)sel);
            } else {
                this.setSelectedNode(null);
            }
        } else {
            this.setMessage(null);
        }
    }

    protected void listSelectionChanged(ISelection selection) {
        this.setErrorMessage(null);
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object sel = ss.getFirstElement();
        if (sel instanceof WorkbenchWizardElement) {
            WorkbenchWizardElement currentWizardSelection = (WorkbenchWizardElement)sel;
            this.updateSelectedNode(currentWizardSelection);
        } else {
            this.updateSelectedNode(null);
        }
    }

    private IWizardNode createWizardNode(IWizardDescriptor element) {
        return new WorkbenchWizardNode(this, element){

            public IWorkbenchWizard createWizard() throws CoreException {
                return this.wizardElement.createWizard();
            }
        };
    }

    protected void restoreWidgetValues() {
        this.updateMessage();
    }

    protected void expandPreviouslyExpandedCategories(String setting, IWizardCategory wizardCategories, TreeViewer viewer) {
        String[] expandedCategoryPaths = this.getDialogSettings().getArray(setting);
        if (expandedCategoryPaths == null || expandedCategoryPaths.length == 0) {
            return;
        }
        ArrayList<IWizardCategory> categoriesToExpand = new ArrayList<IWizardCategory>(expandedCategoryPaths.length);
        if (wizardCategories != null) {
            int i = 0;
            while (i < expandedCategoryPaths.length) {
                IWizardCategory category = wizardCategories.findCategory((IPath)new Path(expandedCategoryPaths[i]));
                if (category != null) {
                    categoriesToExpand.add(category);
                }
                ++i;
            }
        }
        if (!categoriesToExpand.isEmpty()) {
            viewer.setExpandedElements(categoriesToExpand.toArray());
        }
    }

    protected void selectPreviouslySelected(String setting, IWizardCategory wizardCategories, TreeViewer viewer) {
        String selectedId = this.getDialogSettings().get(setting);
        if (selectedId == null) {
            return;
        }
        if (wizardCategories == null) {
            return;
        }
        IWizardCategory selected = wizardCategories.findCategory((IPath)new Path(selectedId));
        if (selected == null && (selected = wizardCategories.findWizard(selectedId)) == null) {
            return;
        }
        viewer.setSelection((ISelection)new StructuredSelection((Object)selected), true);
    }

    protected void storeExpandedCategories(String setting, TreeViewer viewer) {
        Object[] expandedElements = viewer.getExpandedElements();
        ArrayList<String> expandedElementPaths = new ArrayList<String>(expandedElements.length);
        int i = 0;
        while (i < expandedElements.length) {
            if (expandedElements[i] instanceof IWizardCategory) {
                expandedElementPaths.add(((IWizardCategory)expandedElements[i]).getPath().toString());
            }
            ++i;
        }
        this.getDialogSettings().put(setting, expandedElementPaths.toArray(new String[expandedElementPaths.size()]));
    }

    protected void storeSelectedCategoryAndWizard(String setting, TreeViewer viewer) {
        Object selected = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
        if (selected != null) {
            if (selected instanceof IWizardCategory) {
                this.getDialogSettings().put(setting, ((IWizardCategory)selected).getPath().toString());
            } else {
                this.getDialogSettings().put(setting, ((IWizardDescriptor)selected).getId());
            }
        }
    }

    public void saveWidgetValues() {
    }

    public IWizardPage getNextPage() {
        ITriggerPoint triggerPoint = this.getTriggerPoint();
        if (triggerPoint == null || WorkbenchActivityHelper.allowUseOf((ITriggerPoint)triggerPoint, (Object)this.getSelectedNode())) {
            return super.getNextPage();
        }
        return null;
    }

    protected ITriggerPoint getTriggerPoint() {
        return null;
    }

    protected void setTreeViewer(TreeViewer viewer) {
        this.treeViewer = viewer;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void initialize() {
    }

    protected static List<Object> getWizardsOrder(String tag) {
        ArrayList<Object> wizardsOrder = new ArrayList<Object>();
        ImportExportPage.loadWizardsOrder(wizardsOrder, tag);
        return wizardsOrder;
    }

    private static void loadWizardsOrder(List<Object> wizardsOrder, String tag) {
        Bundle bundle = Platform.getBundle((String)"org.xmind.ui.mindmap");
        if (bundle == null) {
            return;
        }
        BundleResource xmLResource = new BundleResource(bundle, (IPath)new Path(WIZARDS_ORDER_XML_PATH)).resolve();
        if (xmLResource == null) {
            MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.xmind.ui.mindmap", "Failed to locate wizards order xml: " + bundle.getSymbolicName() + "/" + WIZARDS_ORDER_XML_PATH));
            return;
        }
        URL listXMLURL = xmLResource.toPlatformURL();
        Element element = ImportExportPage.getWizardsOrderElement(listXMLURL);
        if (element == null) {
            return;
        }
        Element orderEle = DOMUtils.getFirstChildElementByTag((Node)element, (String)tag);
        Iterator it = DOMUtils.childElementIterByTag((Node)orderEle, (String)"category");
        while (it.hasNext()) {
            Element categoryEle = (Element)it.next();
            String categoryId = categoryEle.getAttribute("id");
            ArrayList<String> wizardIds = new ArrayList<String>();
            Element[] elementArray = DOMUtils.getChildElementsByTag((Node)categoryEle, (String)"wizard");
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element wizardEle = elementArray[n2];
                wizardIds.add(wizardEle.getAttribute("id"));
                ++n2;
            }
            wizardsOrder.add(new Category(categoryId, wizardIds));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Element getWizardsOrderElement(URL xmlURL) {
        xmlURL = FileLocator.find((URL)xmlURL);
        try {
            InputStream is = xmlURL.openStream();
            if (is == null) return null;
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
                if (doc == null) return null;
                Element element = doc.getDocumentElement();
                return element;
            }
            finally {
                is.close();
            }
        }
        catch (Throwable e) {
            MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.ui.mindmap", "Failed to load wizards order list from " + xmlURL.toExternalForm(), e));
        }
        return null;
    }

    protected class CategorizedWizardSelectionTree {
        private static final int SIZING_LISTS_HEIGHT = 200;
        private IWizardCategory wizardCategories;
        private String message;
        private TreeViewer viewer;

        protected CategorizedWizardSelectionTree(IWizardCategory categories, String msg) {
            this.wizardCategories = categories;
            this.message = msg;
        }

        protected Composite createControl(Composite parent) {
            Font font = parent.getFont();
            Composite outerContainer = new Composite(parent, 0);
            outerContainer.setLayout((Layout)new GridLayout());
            outerContainer.setLayoutData((Object)new GridData(1808));
            outerContainer.setFont(font);
            this.createFilteredTree(outerContainer);
            this.layoutTopControl(this.viewer.getControl());
            return outerContainer;
        }

        private void createFilteredTree(Composite parent) {
            InternalFilteredTree filteredTree = new InternalFilteredTree(parent, 68356, (PatternFilter)new WizardPatternFilter(), this.message);
            this.viewer = filteredTree.getViewer();
            filteredTree.setFont(parent.getFont());
            filteredTree.setQuickSelectionMode(true);
            this.viewer.setContentProvider((IContentProvider)new WizardContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new ImportExportLabelProvider(ImportExportPage.this.resources));
            DataTransferWizardCollectionComparator comparator = DataTransferWizardCollectionComparator.INSTANCE;
            comparator.setWizardsOrder(ImportExportPage.this.wizardsOrder);
            this.viewer.setComparator((ViewerComparator)comparator);
            ArrayList<IWizardCategory> inputArray = new ArrayList<IWizardCategory>();
            if (this.wizardCategories != null) {
                if (this.wizardCategories.getParent() == null) {
                    IWizardCategory[] children = this.wizardCategories.getCategories();
                    int i = 0;
                    while (i < children.length) {
                        inputArray.add(children[i]);
                        ++i;
                    }
                } else {
                    inputArray.add(this.wizardCategories);
                }
            }
            this.viewer.setAutoExpandLevel(-1);
            AdaptableList input = new AdaptableList(inputArray);
            this.viewer.addFilter((ViewerFilter)new WizardActivityFilter());
            this.viewer.setInput((Object)input);
        }

        protected TreeViewer getViewer() {
            return this.viewer;
        }

        private void layoutTopControl(Control control) {
            GridData data = new GridData(1808);
            int availableRows = DialogUtil.availableRows((Composite)control.getParent());
            data.heightHint = availableRows > 50 ? 200 : availableRows * 3;
            control.setLayoutData((Object)data);
        }
    }

    protected static class Category {
        private String id;
        private List<String> descriptorIds;

        public Category(String id, List<String> descriptorIds) {
            this.id = id;
            this.descriptorIds = descriptorIds;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getDescriptorIds() {
            return this.descriptorIds;
        }
    }

    private static class DataTransferWizardCollectionComparator
    extends ViewerComparator {
        public static final DataTransferWizardCollectionComparator INSTANCE = new DataTransferWizardCollectionComparator();
        private List<Object> wizardsOrder;

        private DataTransferWizardCollectionComparator() {
        }

        public void setWizardsOrder(List<Object> wizardsOrder) {
            this.wizardsOrder = wizardsOrder;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof IWizardCategory && e2 instanceof IWizardCategory) {
                return this.indexOf((IWizardCategory)e1) - this.indexOf((IWizardCategory)e2);
            }
            if (e1 instanceof IWizardDescriptor && e2 instanceof IWizardDescriptor) {
                if (ImportExportPage.RECENTLY_USED_CATEGORY_ID.equals(((IWizardDescriptor)e1).getCategory().getId()) && ImportExportPage.RECENTLY_USED_CATEGORY_ID.equals(((IWizardDescriptor)e2).getCategory().getId())) {
                    return 1;
                }
                return this.indexOf((IWizardDescriptor)e1) - this.indexOf((IWizardDescriptor)e2);
            }
            return super.compare(viewer, e1, e2);
        }

        private int indexOf(Object object) {
            block3: {
                block2: {
                    if (!(object instanceof IWizardCategory)) break block2;
                    IWizardCategory wizardCategory = (IWizardCategory)object;
                    for (Object category : this.wizardsOrder) {
                        if (!((Category)category).getId().equals(wizardCategory.getId())) continue;
                        return this.wizardsOrder.indexOf(category);
                    }
                    break block3;
                }
                if (!(object instanceof IWizardDescriptor)) break block3;
                IWizardCategory wizardCategory = ((IWizardDescriptor)object).getCategory();
                for (Object category : this.wizardsOrder) {
                    if (!((Category)category).getId().equals(wizardCategory.getId())) continue;
                    return ((Category)category).getDescriptorIds().indexOf(((IWizardDescriptor)object).getId());
                }
            }
            return -1;
        }
    }

    private static class ImportExportLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ResourceManager resources;

        public ImportExportLabelProvider(ResourceManager resources) {
            this.resources = resources;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public String getText(Object element) {
            IWorkbenchAdapter adapter = this.getAdapter(element);
            if (adapter == null) {
                return "";
            }
            String label = adapter.getLabel(element);
            return this.decorateText(label, element);
        }

        private IWorkbenchAdapter getAdapter(Object o) {
            return (IWorkbenchAdapter)Adapters.adapt((Object)o, IWorkbenchAdapter.class);
        }

        private String decorateText(String input, Object element) {
            return input;
        }

        public Image getImage(Object element) {
            if (element instanceof IWizardCategory) {
                return (Image)this.resources.get((DeviceResourceDescriptor)MindMapUI.getImages().get("icons/impexp/folder.png"));
            }
            IWorkbenchAdapter adapter = this.getAdapter(element);
            if (adapter == null) {
                return null;
            }
            ImageDescriptor descriptor = adapter.getImageDescriptor(element);
            if (descriptor == null) {
                return null;
            }
            descriptor = this.decorateImage(descriptor, element);
            return (Image)this.resources.get((DeviceResourceDescriptor)descriptor);
        }

        private ImageDescriptor decorateImage(ImageDescriptor input, Object element) {
            return input;
        }
    }

    private static class InternalFilteredTree
    extends FilteredTree {
        private ResourceManager resources;
        private Label messageLabel;

        public InternalFilteredTree(Composite parent, int treeStyle, PatternFilter filter, String message) {
            super(parent, treeStyle, filter, true);
            this.messageLabel.setText(message);
        }

        protected void createControl(Composite parent, int treeStyle) {
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 10;
            this.setLayout((Layout)layout);
            if (parent.getLayout() instanceof GridLayout) {
                this.setLayoutData(new GridData(4, 4, true, true));
            }
            if (this.showFilterControls) {
                Composite composite = new Composite((Composite)this, 0);
                this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
                composite.setBackground(parent.getBackground());
                composite.setLayoutData((Object)new GridData(4, 128, true, false));
                composite.setFont(parent.getFont());
                GridLayout layout2 = new GridLayout(2, false);
                layout2.marginWidth = 0;
                layout2.marginHeight = 0;
                layout2.horizontalSpacing = 32;
                composite.setLayout((Layout)layout2);
                this.messageLabel = new Label(composite, 0);
                this.messageLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
                this.messageLabel.setFont(composite.getFont());
                this.messageLabel.setBackground(composite.getBackground());
                this.messageLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#323232")));
                this.filterComposite = new Composite(composite, 2048);
                this.filterComposite.setBackground(this.getDisplay().getSystemColor(25));
                GridLayout filterLayout = new GridLayout(2, false);
                filterLayout.marginHeight = 0;
                filterLayout.marginWidth = 0;
                this.filterComposite.setLayout((Layout)filterLayout);
                this.filterComposite.setFont(composite.getFont());
                this.createFilterControls(this.filterComposite);
                this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
            }
            this.treeComposite = new Composite((Composite)this, 0);
            GridLayout treeCompositeLayout = new GridLayout();
            treeCompositeLayout.marginHeight = 0;
            treeCompositeLayout.marginWidth = 0;
            this.treeComposite.setLayout((Layout)treeCompositeLayout);
            GridData data = new GridData(4, 4, true, true);
            this.treeComposite.setLayoutData((Object)data);
            this.createTreeControl(this.treeComposite, treeStyle);
        }

        protected void createFilterText(Composite parent) {
            super.createFilterText(parent);
            this.filterText.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#b2b2b2")));
        }

        protected void textChanged() {
            super.textChanged();
            if (this.getFilterString() == null || this.getFilterString().equals("")) {
                Display.getCurrent().timerExec((int)this.getRefreshJobDelay() * 3 / 2, new Runnable(){

                    @Override
                    public void run() {
                        InternalFilteredTree.this.getViewer().expandAll();
                    }
                });
            }
        }
    }
}

