/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.biggerplate;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.xmind.ui.biggerplate.BiggerplateMessages;
import org.xmind.ui.biggerplate.BiggerplatePlugin;
import org.xmind.ui.internal.biggerplate.BiggerplateOauth;
import org.xmind.ui.internal.biggerplate.Info;
import org.xmind.ui.preference.PreferenceFieldEditorPageSection;

public class BiggerplatePreferencePageSection
extends PreferenceFieldEditorPageSection
implements IWorkbenchPreferencePage {
    private Composite composite;
    private Label accountLabel;
    private Label usernameLabel;
    private Button changeStatusButton;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(BiggerplatePlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
    }

    protected Control createContents(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 25;
        this.composite.setLayout((Layout)layout);
        Label descriptionLabel = new Label(this.composite, 64);
        descriptionLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        descriptionLabel.setText(BiggerplateMessages.PreferencePage_FeatureDescription_message);
        this.createAccountInfoArea(this.composite);
        this.updateStatusSection(false);
        return this.composite;
    }

    private void updateStatusSection(boolean async) {
        if (this.accountLabel == null || this.accountLabel.isDisposed() || this.usernameLabel == null || this.usernameLabel.isDisposed() || this.changeStatusButton == null || this.changeStatusButton.isDisposed()) {
            return;
        }
        if (async) {
            this.changeStatusButton.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    BiggerplatePreferencePageSection.this.updateStatusSection(false);
                }
            });
        } else {
            boolean biggerplateSignedin;
            String refreshToken = this.getPreferenceStore().getString("org.xmind.ui.biggerplate.preference.refreshToken");
            boolean bl = biggerplateSignedin = refreshToken != null && !refreshToken.equals("");
            if (biggerplateSignedin) {
                this.setEnabled((Control)this.accountLabel, true);
                this.setEnabled((Control)this.usernameLabel, true);
                this.usernameLabel.setText(this.getPreferenceStore().getString("org.xmind.ui.biggerplate.preference.username"));
                this.changeStatusButton.setText(BiggerplateMessages.PreferencePage_UnlinkEvernote_text);
                this.changeStatusButton.getParent().layout();
                Point p = this.changeStatusButton.getParent().computeSize(-1, -1);
                this.changeStatusButton.getParent().setSize(p);
            } else {
                this.setEnabled((Control)this.accountLabel, false);
                this.setEnabled((Control)this.usernameLabel, false);
                this.changeStatusButton.setText(BiggerplateMessages.PreferencePage_LinkEvernote_text);
                this.changeStatusButton.getParent().layout();
            }
            this.composite.layout(true, true);
        }
    }

    private void createAccountInfoArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.accountLabel = new Label(composite, 0);
        this.accountLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.accountLabel.setFont(JFaceResources.getDefaultFont());
        this.accountLabel.setText(BiggerplateMessages.PreferencePage_AccountInfo_label);
        this.usernameLabel = new Label(composite, 0);
        this.usernameLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.usernameLabel.setFont(JFaceResources.getDefaultFont());
        this.usernameLabel.setText("");
        this.changeStatusButton = new Button(composite, 8);
        this.changeStatusButton.setText("");
        this.changeStatusButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean biggerplateSignedin;
                String refreshToken = BiggerplatePreferencePageSection.this.getPreferenceStore().getString("org.xmind.ui.biggerplate.preference.refreshToken");
                boolean bl = biggerplateSignedin = refreshToken != null && !refreshToken.equals("");
                if (biggerplateSignedin && !MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)BiggerplateMessages.PreferencePage_UnlinkAccount_title, (String)BiggerplateMessages.PreferencePage_UnlinkAccount_text)) {
                    return;
                }
                BiggerplatePreferencePageSection.this.changeServiceStatus();
            }
        });
    }

    private void changeServiceStatus() {
        final Display display = Display.getDefault();
        this.changeStatusButton.setEnabled(false);
        Thread t = new Thread(new Runnable(){

            public void run() {
                boolean biggerplateSignedin;
                String refreshToken = BiggerplatePreferencePageSection.this.getPreferenceStore().getString("org.xmind.ui.biggerplate.preference.refreshToken");
                boolean bl = biggerplateSignedin = refreshToken != null && !refreshToken.equals("");
                if (biggerplateSignedin) {
                    BiggerplatePreferencePageSection.this.signOut();
                } else {
                    BiggerplatePreferencePageSection.this.signIn();
                }
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (BiggerplatePreferencePageSection.this.changeStatusButton != null && !BiggerplatePreferencePageSection.this.changeStatusButton.isDisposed()) {
                            BiggerplatePreferencePageSection.this.changeStatusButton.setEnabled(true);
                        }
                    }
                });
                BiggerplatePreferencePageSection.this.updateStatusSection(true);
            }
        });
        t.setDaemon(true);
        t.start();
    }

    private void setEnabled(Control control, boolean enabled) {
        control.setVisible(enabled);
        ((GridData)control.getLayoutData()).exclude = !enabled;
    }

    private void signIn() {
        Info info = new Info();
        String accessToken = BiggerplateOauth.generateAccessToken(info);
        if (accessToken == null || accessToken.equals("")) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)BiggerplateMessages.PreferencePage_LinkFailed_title, (String)BiggerplateMessages.PreferencePage_LinkFailed_text);
                }
            });
        }
    }

    private void signOut() {
        this.getPreferenceStore().setValue("org.xmind.ui.biggerplate.preference.refreshToken", "");
        this.getPreferenceStore().setValue("org.xmind.ui.biggerplate.preference.username", "");
    }
}

