/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.exports.cell;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import net.xmind.verify.ui.VerifyWizardPage20141031;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.aspose.AsposePlugin;
import org.xmind.ui.internal.aspose.exports.ExportMessages;
import org.xmind.ui.internal.aspose.exports.cell.ExcelExportPageBase;
import org.xmind.ui.internal.aspose.exports.cell.ExcelExporter;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.DocumentExportWizard;
import org.xmind.ui.wizards.IExporter;

public class ExcelExportWizard
extends DocumentExportWizard {
    private static final String PAGE_NAME = "org.xmind.ui.export.ExcelExportPage";
    private static final String SECTION_NAME = "org.xmind.ui.export.excel";
    private static final String XLS_EXT = ".xls";
    private static final String XLSX_EXT = ".xlsx";
    private FileDialog fileDialog;
    private ExcelExportPage page;

    public ExcelExportWizard() {
        this.setWindowTitle(ExportMessages.ExcelWizard_WindowTitle);
        this.setDialogSettings(AsposePlugin.getDialogSettings(SECTION_NAME));
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
    }

    protected IExporter createExporter() {
        IMindMap mindmap = this.getSourceMindMap();
        int version = this.getExtension();
        ExcelExporter exporter = new ExcelExporter(mindmap.getSheet(), mindmap.getCentralTopic(), this.getTargetPath(), version);
        exporter.setDialogSettings(this.getDialogSettings());
        exporter.init();
        return exporter;
    }

    public boolean needsPreviousAndNextButtons() {
        if (!super.needsPreviousAndNextButtons()) {
            return false;
        }
        int count = 0;
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof VerifyWizardPage20141031) {
                ++count;
            }
            ++n2;
        }
        return this.getPages().length - count > 1;
    }

    protected void addValidPages() {
        this.addPage((IWizardPage)new VerifyWizardPage20141031("ExportToExcel", ExportMessages.ExcelExportJob_Name));
        this.page = new ExcelExportPage();
        this.addPage((IWizardPage)this.page);
    }

    protected String getFormatName() {
        if (this.getExtension() == 6) {
            return ExportMessages.Excel2007Wizard_FormatName;
        }
        return ExportMessages.ExcelWizard_FormatName;
    }

    protected boolean isExtensionCompatible(String path, String extension) {
        return super.isExtensionCompatible(path, extension) && (XLS_EXT.equalsIgnoreCase(extension) || XLSX_EXT.equalsIgnoreCase(extension));
    }

    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    private int getExtension() {
        if (this.fileDialog == null) {
            return 5;
        }
        int filterIndex = this.fileDialog.getFilterIndex();
        String filterExtension = this.fileDialog.getFilterExtensions()[filterIndex];
        if (filterExtension.equals("*.xlsx")) {
            String target = this.getTargetPath();
            if (!target.contains(XLSX_EXT)) {
                this.setTargetPath(String.valueOf(target) + "x");
            }
            return 6;
        }
        return 5;
    }

    protected String getSuggestedFileName() {
        return String.valueOf(super.getSuggestedFileName()) + XLS_EXT;
    }

    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        VerifyUI20141031.getUsageDataCollector().increase("ExportToExcelCount");
        super.doExport(monitor, display, parentShell);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExcelExportPage
    extends ExcelExportPageBase {
        public ExcelExportPage() {
            super(ExcelExportWizard.PAGE_NAME, ExportMessages.ExcelPage_Title);
            this.setDescription(ExportMessages.ExcelPage_Description);
        }

        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.add(0, ExportMessages.Excel2007Page_FilterName);
            filterNames.add(0, ExportMessages.ExcelPage_FilterName);
            filterExtensions.add(0, "*.xlsx");
            filterExtensions.add(0, "*.xls");
            ExcelExportWizard.this.fileDialog = dialog;
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }
    }
}

